/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncURLUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXSyncDeptService
extends SyncDeptBaseService {
    public WXSyncDeptService(SyncContext ctx) {
        super(ctx);
    }

    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        if (syncType != null) {
            return super.sync(itemType);
        }
        return null;
    }

    @Override
    protected void getAllOrg() throws BOSException {
        JSONArray array = new JSONArray();
        try {
            String url = this.getSyncURL(SyncItemType.GetAllOrg.getName());
            JSONObject response = SyncCommunitcateUtil.getSyncResponse(url);
            if (!"0".equals(response.getString("errcode"))) {
                if (this.syncCtx.getType() == 0 && "48009".equals(response.getString("errcode"))) {
                    url = this.getSyncURL(SyncItemType.GetAllOrg.getName(), "selfBuildtoken", "selfBuildSecret");
                    response = SyncCommunitcateUtil.getSyncResponse(url);
                    if (!"0".equals(response.getString("errcode"))) {
                        throw new BOSException(response.getString("errmsg"));
                    }
                } else {
                    throw new BOSException(response.getString("errmsg"));
                }
            }
            if ((array = response.getJSONArray("department")) != null) {
                logger.info((Object)("*******\u83b7\u53d6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        super.clearXtOrgDatas();
        if (array != null && array.size() > 0) {
            super.insertIntoSyncOrgTable(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncAddNewOrg(String itemType) throws BOSException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        String sql = this.getAddNewOrgSql();
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            int id = this.getMaxOrgId();
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                if (rowSet.getString(1) == null) continue;
                for (i = 0; i < syncJsonKey.length; ++i) {
                    if ("id".equals(syncJsonKey[i])) {
                        dataJSON.put(syncJsonKey[i], (Object)(++id));
                        continue;
                    }
                    dataJSON.put(syncJsonKey[i], (Object)rowSet.getString(syncJsonValue[i]));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    logValue.add(rowSet.getString(syncLogColValue[i]));
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncDept(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncDept(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        JSONArray logArray = new JSONArray();
        JSONObject response = null;
        String result = "";
        boolean flag = true;
        try {
            if (baseType != null) {
                if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
                    String url = this.getSyncURL(itemType);
                    List logParamList = (List)logList.get("logColValue");
                    for (int i = 0; i < dataArray.size(); ++i) {
                        List logInfo = (List)logParamList.get(i);
                        JSONObject dataJSON = dataArray.getJSONObject(i);
                        String easParentId = dataJSON.getString("parentid");
                        String parentId = null;
                        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(easParentId)) {
                            parentId = "1";
                        } else {
                            String sql = "select FWXORGId from T_PM_EASWXORGMAP WHERE FEASORGID = '" + easParentId + "'";
                            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
                            if (rs.next()) {
                                parentId = rs.getString("fwxorgid");
                                dataJSON.put("parentid", (Object)parentId);
                            }
                        }
                        if (StringUtils.isEmpty((String)parentId)) {
                            throw new BOSException(dataJSON.getString("name") + "\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                        }
                        dataJSON.put("parentid", (Object)parentId);
                        response = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                        int errorCode = Integer.parseInt(response.getString("errcode"));
                        if (errorCode == 0) {
                            String updateSql = "update t_pm_easwxorgmap set fwxorgid = " + response.getString("id") + " where forglongname ='" + logInfo.get(0).toString() + "'";
                            EasXtSyncUtil.execute(this.ctx, updateSql);
                        }
                        logArray.add((Object)response);
                    }
                } else {
                    flag = false;
                    result = super.syncDept(syncCtx, dataArray, itemType, logList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (flag) {
                SyncLogUtils.syncLog(syncCtx, logList, logArray, syncType);
            }
        }
        if (flag) {
            result = JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, syncType));
        }
        return result;
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
                head = new String[]{"id", "name", "parentid"};
                return head;
            }
            return super.getSyncJsonKey(itemType);
        }
        return null;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
            head = new String[]{"fwxorgid", "fname", "fparentId"};
            return head;
        }
        return super.getSyncJsonValue(itemType);
    }

    @Override
    protected String getAddNewOrgSql() throws BOSException {
        return WXSyncConfigUtil.getInstance().getValue("selectAddNewOrgInfo");
    }

    @Override
    protected String getSyncURL(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/create");
                return url;
            }
            if (SyncItemType.GetAllOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/list");
                return url;
            }
            if (SyncItemType.DeleteOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/delete");
            }
            if (SyncItemType.MoveOrg.equals((Object)type) || SyncItemType.UpdateOrgName.equals((Object)type) || SyncItemType.SetOrgWeights.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/update");
                return url;
            }
        }
        return url;
    }

    @Override
    protected String getSyncURL(String itemType, String tokenType, String secretName) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/create");
                return url;
            }
            if (SyncItemType.GetAllOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/list", tokenType, secretName);
                return url;
            }
            if (SyncItemType.DeleteOrg.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/delete");
            }
            if (SyncItemType.MoveOrg.equals((Object)type) || SyncItemType.UpdateOrgName.equals((Object)type) || SyncItemType.SetOrgWeights.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/department/update");
                return url;
            }
        }
        return url;
    }

    protected int getMaxOrgId() throws BOSException {
        try {
            String sql = "select fwxorgid from T_wx_org";
            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
            int maxId = 2;
            int orgId = 0;
            if (rs != null) {
                while (rs.next()) {
                    orgId = Integer.parseInt(rs.getString("fwxorgid"));
                    maxId = orgId > maxId ? orgId : maxId;
                }
            }
            return maxId;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String getUpdateOrgSql(String itemType) throws BOSException {
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            return WXSyncConfigUtil.getInstance().getValue("selectUpdateOrgName");
        }
        return super.getUpdateOrgSql(itemType);
    }

    @Override
    protected void updateOrgStatus() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgStatus");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
        String dbType = (String)this.ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updateOrgWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updateOrgWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updateOrgWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updateOrgWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            sql = WXSyncConfigUtil.getInstance().getValue(valueKey);
            sql = "/*dialect*/" + sql;
            EasXtSyncUtil.execute(this.ctx, sql);
        }
    }
}

