/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.HttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WXSyncURLUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.trdsync.wxsync.util.WXSyncURLUtil");
    public static Map tokenMap = null;
    public static final String DEFAULT_MCLOUD = "https://qyapi.weixin.qq.com";
    public static final String WX_TOKEN = "/cgi-bin/gettoken";
    public static final String GETALL_ORG = "/cgi-bin/department/list";
    public static final String ADDNEW_ORG = "/cgi-bin/department/create";
    public static final String UPDATE_ORG = "/cgi-bin/department/update";
    public static final String DELETE_ORG = "/cgi-bin/department/delete";
    public static final String GETALL_PERSON = "/cgi-bin/user/list";
    public static final String ADDNEW_PERSON = "/cgi-bin/user/create";
    public static final String UPDATE_PERSON = "/cgi-bin/user/update";
    public static final String DELETE_PERSON = "/cgi-bin/user/delete";
    public static final String GETONE_PERSON = "/cgi-bin/user/get";
    public static final String GETID_MOBILE_PERSON = "/cgi-bin/user/getuserid";
    public static final String GETONE_EMAIL_PERSON = "/cgi-bin/user/get_userid_by_email";

    public static String getSyncUrl(Context ctx, String syncTypeUrl) throws BOSException {
        return WXSyncURLUtil.getSyncUrl(ctx, syncTypeUrl, "token", "secret");
    }

    public static String getSyncUrl(Context ctx, String syncTypeUrl, String type, String secretName) throws BOSException {
        String secret;
        String eip;
        Map config = new WXSyncHelper(ctx).getConfig(ctx);
        String mCloud = config.get("mCloud") == null ? DEFAULT_MCLOUD : (String)config.get("mCloud");
        String token = WXSyncURLUtil.getToken(mCloud, eip = (String)config.get("eip"), secret = (String)config.get(secretName), type);
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException(type + "\u4e3a\u7a7a");
        }
        String syncUrl = mCloud + syncTypeUrl + "?access_token=" + token;
        return syncUrl;
    }

    private static String getToken(String headUrl, String corpid, String corpsecret, String type) throws BOSException {
        long currentTimeMillis;
        long effectTime;
        if (tokenMap == null) {
            tokenMap = new HashMap();
            if ("token".equalsIgnoreCase(type)) {
                WXSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
            } else if ("selfBuildtoken".equalsIgnoreCase(type)) {
                WXSyncURLUtil.sendSelfBuildToken(headUrl, corpid, corpsecret);
            }
        }
        if (tokenMap.get("token") != null && "token".equalsIgnoreCase(type)) {
            effectTime = (Long)tokenMap.get("effectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                WXSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
            }
        } else if ("token".equalsIgnoreCase(type)) {
            WXSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
        }
        if (tokenMap.get("selfBuildtoken") != null && "selfBuildtoken".equalsIgnoreCase(type)) {
            effectTime = (Long)tokenMap.get("selfBuildEffectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                WXSyncURLUtil.sendSelfBuildToken(headUrl, corpid, corpsecret);
            }
        } else if ("selfBuildtoken".equalsIgnoreCase(type)) {
            WXSyncURLUtil.sendSelfBuildToken(headUrl, corpid, corpsecret);
        }
        return tokenMap.get(type).toString();
    }

    private static void sendToken(String headUrl, String corpid, String corpsecret) throws BOSException {
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("corpid", corpid);
        tokenParam.put("corpsecret", corpsecret);
        JSONObject tokenResult = null;
        try {
            tokenResult = HttpSendUtil.startGet(headUrl + WX_TOKEN, tokenParam);
            if (tokenResult.getInteger("errcode") != 0) {
                logger.error((Object)("\u83b7\u53d6token\u5931\u8d25:" + tokenResult.getString("errmsg")));
                throw new BOSException("\u83b7\u53d6token\u5931\u8d25:" + tokenResult.getString("errmsg"));
            }
            String token = tokenResult.getString("access_token");
            long effectime = System.currentTimeMillis() + (long)(tokenResult.getInteger("expires_in") * 1000);
            tokenMap.put("token", token);
            tokenMap.put("effectime", effectime);
        }
        catch (BOSException e) {
            throw new BOSException("\u83b7\u53d6token\u5931\u8d25:" + tokenResult == null ? "" : tokenResult.getString("errmsg"));
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6token\u5931\u8d25:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private static void sendSelfBuildToken(String headUrl, String corpid, String selfBuildtokenSecret) {
        if (StringUtils.isEmpty((String)selfBuildtokenSecret)) {
            return;
        }
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("corpid", corpid);
        tokenParam.put("corpsecret", selfBuildtokenSecret);
        try {
            JSONObject tokenResult = HttpSendUtil.startGet(headUrl + WX_TOKEN, tokenParam);
            if (tokenResult.getInteger("errcode") != 0) {
                logger.error((Object)("\u83b7\u53d6SelfBuildToken\u5931\u8d25:" + tokenResult.getString("errmsg")));
            } else {
                String token = tokenResult.getString("access_token");
                long effectime = System.currentTimeMillis() + (long)(tokenResult.getInteger("expires_in") * 1000);
                tokenMap.put("selfBuildtoken", token);
                tokenMap.put("selfBuildEffectime", effectime);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5931\u8d25;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void clearTokenCache() {
        if (tokenMap != null) {
            tokenMap.clear();
        }
    }
}

