/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class SyncPartService
extends AbstractEasXtSyncService {
    private Context ctx;

    public SyncPartService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException, EASBizException, EASBizException {
        if (this.isItemUpdate(this.ctx, "isUpdatePluralityMsg")) {
            this.updateXtPartJob(this.ctx);
            this.updatePartJobInfo(this.ctx);
        }
        return "true";
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException {
        if (EasXtSyncItemType.BatchSetPartJob.equals((Object)itemType)) {
            return this.syncBatchSetPartJob(this.ctx, itemType);
        }
        if (EasXtSyncItemType.BatchDeletePartJob.equals((Object)itemType)) {
            return this.syncBatchDeletePartJob(this.ctx, itemType);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
    }

    @Override
    public String afterSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        if (this.isItemUpdate(this.ctx, "isUpdatePluralityMsg")) {
            this.updateXtPartJob(this.ctx);
            this.updatePartJobInfo(this.ctx);
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchSetPartJob(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectBatchSetPartMap");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("openId"));
                o.put("orgId", (Object)rowSet.getString("orgId"));
                o.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("orgId")));
                o.put("jobTitle", (Object)rowSet.getString("jobTitle"));
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("openId", (Object)rowSet.getString("openId"));
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("orgId")));
                logO.put("jobTitle", (Object)rowSet.getString("jobTitle"));
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logO.put("orgLongName", (Object)rowSet.getString("orgLongName"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPartJob(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchDelPartMap one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPartJob(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchDelPartMap over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchDeletePartJob(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("selectBatchDelPartMap");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("openId"));
                o.put("orgId", (Object)rowSet.getString("orgId"));
                o.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("orgId")));
                o.put("jobTitle", (Object)rowSet.getString("jobTitle"));
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("openId", (Object)rowSet.getString("openId"));
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("commitId", (Object)(rowSet.getString("openId") + "____" + rowSet.getString("orgId")));
                logO.put("jobTitle", (Object)rowSet.getString("jobTitle"));
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logO.put("orgLongName", (Object)rowSet.getString("orgLongName"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPartJob(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchDelPartMap one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPartJob(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******selectBatchDelPartMap over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    private void syncPartJob(Context ctx, JSONArray dataArray, JSONArray logArray, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        logger.error((Object)("*****" + itemType.getName() + "********"));
        boolean isAll = true;
        String description = "\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38";
        JSONObject result = null;
        try {
            JSONObject response = null;
            if (EasXtSyncItemType.BatchSetPartJob.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchSetPartJob(dataArray);
            } else if (EasXtSyncItemType.BatchDeletePartJob.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeletePartJob(dataArray);
            } else {
                return;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
                isAll = false;
                result = response;
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                description = response.getString("error");
                result = response;
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        finally {
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
    }
}

