/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncFacadeFactory;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.PrivacyProtectUtil;
import com.kingdee.eas.base.xtsync.xtutil.RegisterUserUtil;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EasXtViewDataUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.xtutil.EasXtViewDataUtil");
    private static final int CELL_TYPE_NUMERIC = 0;
    private static final int CELL_TYPE_STRING = 1;
    private static final int CELL_TYPE_FORMULA = 2;
    private static final int CELL_TYPE_BLANK = 3;
    private static final int CELL_TYPE_BOOLEAN = 4;
    private static final int CELL_TYPE_ERROR = 5;

    public static IRowSet getExportOrg(Context ctx, String exportType) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String exportOrgSql = "";
        if ("ALL".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportAllOrg");
        } else if ("NOBIND".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportNoBindOrg");
        } else if ("SyncBatchOrg".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportSyncBatchOrg");
        } else {
            return null;
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)exportOrgSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet exportFilterData(Context ctx, EasXtSyncItemType itemType, String dataType, String condition, String syncTimeId, boolean success) {
        IRowSet rs = null;
        if ("viewOrgLog".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.orgLogExport(ctx, itemType, "", condition, syncTimeId, success);
        } else if ("viewPersonLog".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.personLogExport(ctx, itemType, "", condition, syncTimeId, success);
        } else if ("viewDeptLeaderLog".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.deptLeaderLogExport(ctx, itemType, "", condition, syncTimeId, success);
        } else if ("viewPartJobLog".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.partJobLogExport(ctx, itemType, "", condition, syncTimeId, success);
        } else if ("viewRelationsLog".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.relationsLogExport(ctx, itemType, "", condition, syncTimeId, success);
        } else if ("viewXtOrg".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.xtOrgExport(ctx, condition);
        } else if ("viewXtUser".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.xtUserExport(ctx, condition);
        } else if ("viewUpdateCellRecords".equalsIgnoreCase(dataType)) {
            rs = EasXtViewDataUtil.updateCellRecordsExport(ctx, condition);
        }
        return rs;
    }

    public static IRowSet orgLogExport(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.ftype syncItemType,log.fcreatetime,log.FOldOrgLongName,log.FOrgLongName,log.FMsgCode,log.FErrorMsg,case when(log.fsuccess = 1) then '\u662f' else '\u5426' end syncSuccess,log.fsynctimeid from T_XT_SYNCDEPTLOG log where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (log.foldorglongname like '%").append(filter).append("%' or ").append(" ferrormsg like '%").append(filter).append("%' or ").append(" log.forglongname like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" FOldPOrgLongName like '%").append(filter).append("%' ").append(" )");
        }
        extraFilter.append("  order by log.FOldOrgLongName asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet personLogExport(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.fxtid,log.FType syncItemType,log.fcreatetime,log.fpersonName,log.FCell,log.FEmail,log.FOldOrgName,log.FJobTitle,";
        sql = EasXtSyncItemType.UpdatePersonOther.equals((Object)itemType) ? sql + " case when(log.FGender = 1) then '\u7537' else '\u5973' end gender," : sql + " case when(p.FGender = 1) then '\u7537' else '\u5973' end gender,";
        sql = sql + " log.FMsgCode,log.FErrorMsg,case when(log.fsuccess = 1) then '\u662f' else '\u5426' end syncSuccess,log.fsynctimeid from T_XT_SYNCPERSONLOG log left join T_BD_Person p on p.FID = log.fpersonid left join T_HR_BDEmployeeType empType ON p.FEmployeeTypeID = empType.FID left join T_PM_EASXTUSERMAP umap on case when(umap.FCell is null or umap.fcell = '') then to_char(umap.FEmail) else to_char(umap.FCell) end = case when(log.FCell is null or log.fcell = '') then to_char(log.FEmail) else to_char(log.FCell) end where 1=1 ";
        StringBuilder extraFilter = new StringBuilder(sql);
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append("and (log.fpersonname like '%").append(filter).append("%' or ").append(" log.fxtid like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FOldOrgName like '%").append(filter).append("%' or ").append(" log.Femail like '%").append(filter).append("%' or ").append(" log.FJobTitle like '%").append(filter).append("%' or ").append(" log.fcell like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ");
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                extraFilter.append(" (umap.fxtid is not null) or ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                extraFilter.append(" (umap.fxtid is null or umap.fxtid = '') or ");
            }
            if ("\u7537".equals(filter)) {
                extraFilter.append(" or p.FGender = '").append(1).append("'");
            } else if ("\u5973".equals(filter)) {
                extraFilter.append(" or p.FGender = '").append(2).append("'");
            }
            extraFilter.append(" log.forgname like '%").append(filter).append("%' ").append(" )");
        }
        extraFilter.append(" order by log.FOldOrgName asc, log.fpersonName asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet deptLeaderLogExport(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.ftype syncItemType,log.fcreatetime,log.fpersonname fresponperson,log.FXtId,log.fcell,log.FOrgLongName,log.FMsgCode,log.FErrorMsg,case when(log.fsuccess = 1) then '\u662f' else '\u5426' end syncSuccess,log.fsynctimeid from T_XT_SYNCORGLEADERLOG log where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (log.fxtid like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FXtId = '").append(filter).append("' or ").append(" log.fcell like '%").append(filter).append("%' or ").append(" log.forglongname like '%").append(filter).append("%' or ").append(" log.fpersonname like '%").append(filter).append("%' ").append(" )");
        }
        extraFilter.append(" order by log.FOrgLongName asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet partJobLogExport(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.ftype syncItemType,log.fcreatetime,log.FPersonName personName,log.FXtId,log.FCell cell,log.FOrgLongName orglongname,log.FOrgId,log.fjobtitle jobTitle,log.FMsgCode,log.FErrorMsg,case when(log.fsuccess = 1) then '\u662f' else '\u5426' end syncSuccess,log.fsynctimeid from T_XT_SYNCPARTLOG log where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (omap.FOrgLongName like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.FXtId like '%").append(filter).append("%' or ").append(" log.FOrgId like '%").append(filter).append("%' or ").append(" log.FCell like '%").append(filter).append("%' or ").append(" log.fjobtitle like '%").append(filter).append("%' or ").append(" log.FPersonName like '%").append(filter).append("%' ").append(" )");
        }
        extraFilter.append(" order by log.FOrgLongName asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet relationsLogExport(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String successReqStr = o.getString("successReqStr");
        int searchTime = o.getIntValue("searchTime");
        if ("undefined".equals(syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        String sql = "select distinct log.FID,log.ftype syncItemType,log.fcreatetime,log.FPersonName personName,log.fxtid,log.FPosition jobtTitle,log.FLeaderPosition leaderJobTitle,log.FLeaderPersonName leaderPersonName,log.FLeaderxtid,log.FMsgCode,log.FErrorMsg,case when(log.fsuccess = 1) then '\u662f' else '\u5426' end syncSuccess,log.fsynctimeid from T_XT_SYNCRELATIONSLOG log left join T_PM_EASXTUSERMAP umap on umap.FXtId = log.fxtid left join T_PM_EASXTUSERMAP umapl on umapl.FXtId = log.FLeaderXtId  where 1=1";
        StringBuilder extraFilter = new StringBuilder(sql);
        EasXtSyncLogUtils.appendCommonFilter(extraFilter, itemType, syncTimeId, success, successReqStr);
        EasXtSyncLogUtils.appendSearchTimeFilter(extraFilter, searchTime);
        if (!StringUtils.isEmpty((String)filter)) {
            extraFilter.append(" and (umap.FOrgLongName like '%").append(filter).append("%' or ").append(" log.ferrormsg like '%").append(filter).append("%' or ").append(" log.FLeaderPersonName like '%").append(filter).append("%' or ").append(" log.fsynctimeid like '%").append(filter).append("%' or ").append(" log.fxtid like '%").append(filter).append("%' or ").append(" log.FLeaderxtid like '%").append(filter).append("%' or ").append(" log.FPosition like '%").append(filter).append("%' or ").append(" log.FLeaderPosition like '%").append(filter).append("%' or ").append(" log.FOrgLongName like '%").append(filter).append("%' or ").append(" log.FCell like '%").append(filter).append("%' or ").append(" umap.FPersonName like '%").append(filter).append("%' or ").append(" umapl.FPersonName like '%").append(filter).append("%' ").append(" )");
        }
        extraFilter.append(" order by log.FLeaderPersonName asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)extraFilter.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet xtOrgExport(Context ctx, String condition) {
        StringBuilder sb = new StringBuilder("select xt.fid,xt.forglongname,xt.fname,xt.fparentid from t_xt_org xt ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fid = '").append(filter).append("'").append(" or xt.fparentid = '").append(filter).append("'").append(" or xt.fname like '%").append(filter).append("%'").append(" or xt.forglongname like '%").append(filter).append("%'").append(")");
        }
        sb.append(" order by xt.forglongname asc ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet xtUserExport(Context ctx, String condition) {
        StringBuilder sb = new StringBuilder("select xt.fid,xt.fpersonname,xt.fcell,xt.femail,xt.forglongname,xt.fposition,case when(xt.fgender = 1) then '\u7537' else '\u5973' end gerder,xt.fphones,case when(xt.fstatus = 1) then '\u6b63\u5e38' else '\u6ce8\u9500\u6216\u7981\u7528' end fstatus from t_xt_user xt ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fid = '").append(filter).append("'").append(" or xt.fpersonname like '%").append(filter).append("%'").append(" or xt.forglongname like '%").append(filter).append("%'").append(" or xt.fposition like '%").append(filter).append("%'").append(" or xt.fphones like '%").append(filter).append("%'").append(" or xt.fcell like '%").append(filter).append("%'").append(" or xt.femail like '%").append(filter).append("%'");
            if ("\u7537".equals(filter)) {
                sb.append(" or xt.fgender = '").append(1).append("'");
            } else if ("\u5973".equals(filter)) {
                sb.append(" or xt.fgender = '").append(2).append("'");
            }
            if ("\u6ce8\u9500".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(2).append("'");
            } else if ("\u6b63\u5e38".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(1).append("'");
            } else if ("\u7981\u7528".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(0).append("'");
            }
            sb.append(")");
        }
        sb.append(" order by xt.forglongname asc ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet updateCellRecordsExport(Context ctx, String condition) {
        StringBuffer sb = new StringBuffer("select xt.fxtid,xt.feid,xt.fnewphone,xt.foldphone,xt.fcreatetime,case when(map.fcell = xt.fnewphone) then '\u5df2\u66f4\u65b0' else '\u672a\u66f4\u65b0' end fbindstatus, xtuser.FPersonName, xtuser.FOrgLongName,xtuser.FPosition from T_XT_CellUpdateRecords xt left join t_pm_easxtusermap map on xt.fxtid = map.fxtid left join t_xt_user xtuser on xtuser.fid = xt.fxtid ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int searchTime = o.getIntValue("searchTime");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fxtid = '").append(filter).append("'").append(" or xt.fnewphone like '%").append(filter).append("%'").append(" or xt.foldphone like '%").append(filter).append("%'").append(" or xt.feid like '%").append(filter).append("%'").append(" or xtuser.FPersonName like '%").append(filter).append("%'").append(" or xtuser.FOrgLongName like '%").append(filter).append("%'").append(" or xtuser.FPosition like '%").append(filter).append("%'");
            sb.append(")");
        }
        if (searchTime != 0) {
            Date searchTimeDate = DateUtils.addDays((Date)new Date(), (int)(-searchTime));
            Timestamp searchTimeStamp = new Timestamp(searchTimeDate.getTime());
            sb.append(" and xt.fcreatetime >={" + searchTimeStamp + "} ");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append(" order by xt.fcreatetime desc ").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static IRowSet getExportPerson(Context ctx, String exportType) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String exportOrgSql = "";
        if ("ALL".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportAllPerson");
        } else if ("NOBIND".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportNoBindPerson");
        } else if ("SyncBatchPerson".equalsIgnoreCase(exportType)) {
            exportOrgSql = easXtSyncUtil.getValue("getExportSyncBatchPerson");
        } else {
            return null;
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)exportOrgSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSyncCondition(Context ctx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String userid = o.getString("userid");
        String personid = o.getString("personid");
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String getSyncCondition = easXtSyncUtil.getValue("getSyncCondition");
        getSyncCondition = !StringUtils.isEmpty((String)userid) && !"null".equalsIgnoreCase(userid) ? getSyncCondition + " and u.fid = '" + userid + "'" : getSyncCondition + " and p.fid = '" + personid + "'";
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)getSyncCondition);
            boolean sensitiveDef = PrivacyProtectUtil.isSensitiveDef();
            if (rs.next()) {
                String forbidden;
                String deletedStatus;
                map = new HashMap();
                String isPrimary = StringUtils.isEmpty((String)rs.getString("isPrimary")) ? "\u65e0" : "\u6709";
                String inService = rs.getString("inService");
                String inServiceName = rs.getString("inServiceName");
                String string = "1".equals(rs.getString("deletedStatus")) ? "\u6b63\u5e38" : (deletedStatus = "2".equals(rs.getString("deletedStatus")) ? "\u7981\u7528" : "");
                String string2 = "0".equals(rs.getString("forbidden")) ? "\u6b63\u5e38" : (forbidden = "1".equals(rs.getString("forbidden")) ? "\u7981\u7528" : "");
                String udelete = "0".equals(rs.getString("udelete")) ? "\u6b63\u5e38" : ("1".equals(rs.getString("udelete")) ? "\u5220\u9664" : "");
                String umail = rs.getString("umail");
                String ucell = rs.getString("ucell");
                String pmail = rs.getString("pmail");
                String pcell = rs.getString("pcell");
                map.put("isPrimary", isPrimary);
                map.put("inService", inService);
                map.put("inServiceName", inServiceName);
                map.put("deletedStatus", deletedStatus);
                map.put("forbidden", forbidden);
                map.put("udelete", udelete);
                map.put("ucell", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(ucell) : ucell);
                map.put("pcell", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(pcell) : pcell);
                map.put("umail", sensitiveDef ? PrivacyProtectUtil.hideEmailInfo(umail) : umail);
                map.put("pmail", sensitiveDef ? PrivacyProtectUtil.hideEmailInfo(pmail) : pmail);
                if (isPrimary.equals("\u65e0") || !"1".equals(inService) && !"4".equals(inService) || deletedStatus.equals("\u7981\u7528") || udelete.equals("\u5220\u9664")) {
                    map.put("inTimeStatus", "\u79bb\u804c");
                } else {
                    map.put("inTimeStatus", "\u5728\u804c");
                }
            } else {
                map = new HashMap();
                map.put("isPrimary", "\u67e5\u65e0\u6b64\u4eba");
                map.put("inService", "\u67e5\u65e0\u6b64\u4eba");
                map.put("inServiceName", "\u67e5\u65e0\u6b64\u4eba");
                map.put("deletedStatus", "\u67e5\u65e0\u6b64\u4eba");
                map.put("forbidden", "\u67e5\u65e0\u6b64\u4eba");
                map.put("udelete", "\u67e5\u65e0\u6b64\u4eba");
                map.put("ucell", "");
                map.put("pcell", "");
                map.put("umail", "");
                map.put("pmail", "");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(map).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXtOrg(Context ctx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String easorgid = o.getString("easorgid");
        String orglongname = o.getString("orglongname");
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String getXtOrgFromOrgMap = easXtSyncUtil.getValue("getXtOrgFromOrgMap");
        String getXtOrg = easXtSyncUtil.getValue("getXtOrg");
        String getXtOrgById = getXtOrgFromOrgMap + " and omap.feasorgid = ? ";
        String getXtOrgByLongName = getXtOrg + " and xt.forglongname = ? ";
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)getXtOrgById, (Object[])new Object[]{easorgid});
            if (rs.next()) {
                map.put("fisbind", StringUtils.isEmpty((String)rs.getString("forgname")) ? "0" : "1");
                map.put("forgname", rs.getString("forgname"));
            }
            if (map.get("forgname") == null || StringUtils.isEmpty((String)map.get("forgname").toString())) {
                rs = DbUtil.executeQuery((Context)ctx, (String)getXtOrgByLongName, (Object[])new Object[]{orglongname});
                if (rs.next()) {
                    map = new HashMap();
                    map.put("fisbind", "0");
                    map.put("forgname", rs.getString("forgname"));
                } else {
                    map.put("fisbind", "none");
                    map.put("forgname", "");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(map).toString();
    }

    public static boolean deleteFromMiddle(Context ctx, List personIds) {
        if (personIds == null || personIds.size() <= 0) {
            return true;
        }
        HashSet<String> pSet = new HashSet<String>();
        HashSet<String> uSet = new HashSet<String>();
        try {
            for (int i = personIds.size() - 1; i > -1; --i) {
                com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)((String)personIds.get(i)));
                if (o == null) {
                    return false;
                }
                String userid = o.getString("userid");
                String personid = o.getString("personid");
                if (!StringUtils.isEmpty((String)userid)) {
                    uSet.add(userid);
                    continue;
                }
                if (StringUtils.isEmpty((String)personid)) continue;
                pSet.add(personid);
            }
            ArrayList plist = new ArrayList(pSet);
            ArrayList ulist = new ArrayList(uSet);
            DbUtil.execute((Context)ctx, (String)("delete from t_pm_easxtusermap where fuserid in " + EasXtCommonUtils.toPreSta(ulist)), (Object[])ulist.toArray());
            DbUtil.execute((Context)ctx, (String)("delete from t_pm_easxtusermap where fpersonid in " + EasXtCommonUtils.toPreSta(plist)), (Object[])plist.toArray());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean quitPersonToMiddle(Context ctx) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String getQuitPersonToMiddle = easXtSyncUtil.getValue("getQuitPersonToMiddle");
        String bindQuitPerson = easXtSyncUtil.getValue("bindQuitPerson");
        try {
            DbUtil.execute((Context)ctx, (String)getQuitPersonToMiddle);
            DbUtil.execute((Context)ctx, (String)bindQuitPerson);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getSyncDeptLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        return EasXtSyncLogUtils.getDeptSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    public static String getSyncPersonLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        return EasXtSyncLogUtils.getPersonSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    public static String getOrgLeaderSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        return EasXtSyncLogUtils.getOrgLeaderSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    public static String getPartJobSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        return EasXtSyncLogUtils.getPartJobSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    public static String getRelationsSyncLog(Context ctx, EasXtSyncItemType itemType, String queryType, String condition, String syncTimeId, boolean success) {
        return EasXtSyncLogUtils.getRelationsSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAllXtOrg(Context ctx, String condition) {
        String filter;
        StringBuilder sb = new StringBuilder("select xt.fid,xt.fparentid,xt.fname,xt.forglongname from t_xt_org xt ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fid = '").append(filter).append("'").append(" or xt.fparentid = '").append(filter).append("'").append(" or xt.fname like '%").append(filter).append("%'").append(" or xt.forglongname like '%").append(filter).append("%'").append(")");
        }
        IRowSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        int index = 1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sb.toString() + ") countt"));
            if (rs.next()) {
                total = rs.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append(" order by xt.forglongname asc ").toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                map = new HashMap();
                map.put("fid", rs.getString("fid"));
                map.put("fparentid", rs.getString("fparentid"));
                map.put("fname", rs.getString("fname"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("findex", index);
                ++index;
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXtPerson4Bind(Context ctx, String condition) {
        StringBuilder sb = new StringBuilder("select xt.fid,xt.fpersonname,xt.fcell,xt.femail,xt.forglongname,xt.fposition,xt.fgender,xt.fphones,xt.fstatus from t_xt_user xt ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        String fcell = o.getString("fcell");
        String femail = o.getString("femail");
        String fpersonname = o.getString("fpersonname");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        if (EasXtCommonUtils.checkSpecialParam(fcell)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)fcell)) {
            sb.append(" where ((fcell = '" + fcell + "' or fpersonname = '" + fpersonname + "')");
        }
        if (!StringUtils.isEmpty((String)femail)) {
            if (sb.indexOf(" where ") > -1) {
                sb.append(" or (femail = '" + femail + "' or fpersonname = '" + fpersonname + "')");
            } else {
                sb.append(" where (femail = '" + femail + "' or fpersonname = '" + fpersonname + "')");
            }
        }
        sb.append(")");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fid = '").append(filter).append("'").append(" or xt.fpersonname like '%").append(filter).append("%'").append(" or xt.forglongname like '%").append(filter).append("%'").append(" or xt.fposition like '%").append(filter).append("%'").append(" or xt.fphones like '%").append(filter).append("%'").append(" or xt.fcell like '%").append(filter).append("%'").append(" or xt.femail like '%").append(filter).append("%'");
            if ("\u7537".equals(filter)) {
                sb.append(" or xt.fgender = '").append(1).append("'");
            } else if ("\u5973".equals(filter)) {
                sb.append(" or xt.fgender = '").append(2).append("'");
            }
            if ("\u6ce8\u9500".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(2).append("'");
            } else if ("\u6b63\u5e38".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(1).append("'");
            } else if ("\u7981\u7528".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(0).append("'");
            }
            sb.append(")");
        }
        IRowSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        int index = 1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sb.toString() + ") countt"));
            if (rs.next()) {
                total = rs.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append(" order by xt.forglongname asc ").toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                map = new HashMap();
                map.put("fid", rs.getString("fid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fposition", rs.getString("fposition"));
                map.put("fgender", rs.getString("fgender"));
                map.put("fphones", rs.getString("fphones"));
                map.put("fstatus", "1".equals(rs.getString("fstatus")) ? "\u6b63\u5e38" : ("0".equals(rs.getString("fstatus")) ? "\u6ce8\u9500" : "\u7981\u7528"));
                map.put("findex", index);
                ++index;
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCleanDate(Context ctx, String condition) {
        StringBuilder sb = new StringBuilder("select * from (");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int type = o.getInteger("type");
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                sb.append("select ex.fid,ex.fpersonname,ex.fusernumber,ex.fcell,ex.femail,ex.forglongname,ex.fposition,ex.fstatus,ex.fxtid from t_pm_easxtusermap ex where ex.fcell in(select fcell from t_pm_easxtusermap where fcell is not null group by fcell having count(*) > 1) union all select ex.fid,ex.fpersonname,ex.fusernumber,ex.fcell,ex.femail,ex.forglongname,ex.fposition,ex.fstatus,ex.fxtid from t_pm_easxtusermap ex where ex.femail in(select femail from t_pm_easxtusermap where femail is not null group by femail having count(*) > 1) ");
                break;
            }
            case 2: {
                sb.append("select ex.fid,ex.fpersonname,ex.fusernumber,ex.fcell,ex.femail,ex.forglongname,ex.fstatus,u.fid fxtid,u.fpersonname fxtpersonname,u.fcell fxtcell from t_pm_easxtusermap ex inner join t_xt_user u on ex.fxtid = u.fid where fxtid in(select fxtid from t_pm_easxtusermap where fxtid is not null group by fxtid having count(*) > 1)");
            }
        }
        sb.append(") u ");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        if (!StringUtils.isEmpty((String)filter)) {
            sb.append(" where ");
            sb.append(" (u.fid = '").append(filter).append("'").append(" or u.fpersonname like '%").append(filter).append("%'").append(" or u.fusernumber like '%").append(filter).append("%'").append(" or u.forglongname like '%").append(filter).append("%'").append(" or u.fposition like '%").append(filter).append("%'").append(" or u.fcell like '%").append(filter).append("%'").append(" or u.femail like '%").append(filter).append("%'");
            sb.append(")");
        }
        IRowSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        int index = 1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sb.toString() + ") countt"));
            if (rs.next()) {
                total = rs.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append("order by fcell").toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                map = new HashMap();
                map.put("fid", rs.getString("fid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("fusernumber", rs.getString("fusernumber"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fstatus", rs.getString("fstatus"));
                map.put("fisbindsucc", rs.getString("fxtid") == null ? 0 : 1);
                map.put("findex", index);
                switch (type) {
                    case 1: {
                        map.put("fposition", rs.getString("fposition"));
                        map.put("ferrormsg", "\u624b\u673a\u53f7\u6216\u90ae\u7bb1\u91cd\u590d");
                        break;
                    }
                    case 2: {
                        map.put("fxtid", rs.getString("fxtid"));
                        map.put("fxtpersonname", rs.getString("fxtpersonname"));
                        map.put("fxtcell", rs.getString("fxtcell"));
                        map.put("ferrormsg", "EAS\u591a\u804c\u5458\u7ed1\u5b9a\u540c\u4e2a\u4e91\u4e4b\u5bb6\u7528\u6237");
                    }
                }
                ++index;
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dataDeal(Context ctx, String condition) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        int type = o.getInteger("type");
        String mapIdStr = o.getString("mapId");
        String[] ids = (String[])com.alibaba.fastjson.JSONObject.parseArray((String)mapIdStr).toArray((Object[])new String[0]);
        StringBuffer param = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                param.append("'" + ids[i] + "'");
                break;
            }
            param.append("'" + ids[i] + "',");
        }
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        try {
            if (type == 0) {
                String selectSql = "select fxtid from t_pm_easxtusermap where fid in(" + param + ")";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                while (rs.next()) {
                    String xtId = rs.getString("fxtid");
                    if (StringUtils.isEmpty((String)xtId)) continue;
                    jsonArray.add((Object)xtId);
                }
                com.alibaba.fastjson.JSONObject response = XtCommunicateUtil.getInstance(ctx).deletePersonStatus(jsonArray);
                if (!response.getBooleanValue("success")) return true;
            }
            if (type != 1) return true;
            String sql = "delete from t_pm_easxtusermap where fid in(" + param + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            return true;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean clearLog(Context ctx, String condition) throws BOSException {
        String sql;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        int logCleanTimeInt = o.getIntValue("logCleanTime");
        int isDeleteOrgLog = o.getInteger("isDeleteOrgLog");
        int isDeletePersonLog = o.getInteger("isDeletePersonLog");
        int isDeleteDeptLeaderLog = o.getInteger("isDeleteDeptLeaderLog");
        int isDeletePartJobLog = o.getInteger("isDeletePartJobLog");
        int isDeleteRelationsLog = o.getInteger("isDeleteRelationsLog");
        StringBuffer detailLogMsg = new StringBuffer();
        detailLogMsg.append("\u662f\u5426\u5220\u9664\u7ec4\u7ec7\u65e5\u5fd7 = ");
        detailLogMsg.append(isDeleteOrgLog);
        detailLogMsg.append(";\u662f\u5426\u5220\u9664\u4eba\u5458\u65e5\u5fd7 = ");
        detailLogMsg.append(isDeletePersonLog);
        detailLogMsg.append(";\u662f\u5426\u5220\u9664\u8d1f\u8d23\u4eba\u65e5\u5fd7 = ");
        detailLogMsg.append(isDeleteDeptLeaderLog);
        detailLogMsg.append(";\u662f\u5426\u5220\u9664\u517c\u804c\u65e5\u5fd7 = ");
        detailLogMsg.append(isDeletePartJobLog);
        detailLogMsg.append(";\u662f\u5426\u5220\u9664\u4e0a\u4e0b\u7ea7\u65e5\u5fd7 = ");
        detailLogMsg.append(isDeleteRelationsLog);
        detailLogMsg.append(";\u4fdd\u7559\u5929\u6570 = ");
        detailLogMsg.append(logCleanTimeInt);
        Date now = new Date();
        Date logCleanTimeDate = DateUtils.addDays((Date)now, (int)(-logCleanTimeInt));
        Timestamp logCleanTime = new Timestamp(logCleanTimeDate.getTime());
        String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"XTSync_ClearLog", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg.toString(), (String)"XTSync_ClearLog", (String)companyId);
        if (null != beginLog) {
            sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (isDeleteOrgLog == 1) {
            sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SYNCDEPTLOG_LOGTEMP') drop table T_XT_SYNCDEPTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "SELECT * into T_XT_SYNCDEPTLOG_LOGTEMP from T_XT_SYNCDEPTLOG where fcreatetime > {" + logCleanTime + "}";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "truncate table T_XT_SYNCDEPTLOG";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "insert into T_XT_SYNCDEPTLOG select * from T_XT_SYNCDEPTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "drop table T_XT_SYNCDEPTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (isDeletePersonLog == 1) {
            sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SYNCPERSONLOG_LOGTEMP') drop table T_XT_SYNCPERSONLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "SELECT * into T_XT_SYNCPERSONLOG_LOGTEMP from T_XT_SYNCPERSONLOG where fcreatetime > {" + logCleanTime + "}";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "truncate table T_XT_SYNCPERSONLOG";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "insert into T_XT_SYNCPERSONLOG select * from T_XT_SYNCPERSONLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "drop table T_XT_SYNCPERSONLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (isDeleteDeptLeaderLog == 1) {
            sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SYNCORGLEADERLOG_LOGTEMP') drop table T_XT_SYNCORGLEADERLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "SELECT * into T_XT_SYNCORGLEADERLOG_LOGTEMP from T_XT_SYNCORGLEADERLOG where fcreatetime > {" + logCleanTime + "}";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "truncate table T_XT_SYNCORGLEADERLOG";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "insert into T_XT_SYNCORGLEADERLOG select * from T_XT_SYNCORGLEADERLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "drop table T_XT_SYNCORGLEADERLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (isDeletePartJobLog == 1) {
            sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SYNCPARTLOG_LOGTEMP') drop table T_XT_SYNCPARTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "SELECT * into T_XT_SYNCPARTLOG_LOGTEMP from T_XT_SYNCPARTLOG where fcreatetime > {" + logCleanTime + "}";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "truncate table T_XT_SYNCPARTLOG";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "insert into T_XT_SYNCPARTLOG select * from T_XT_SYNCPARTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "drop table T_XT_SYNCPARTLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (isDeleteRelationsLog == 1) {
            sql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SYNCRELATIONSLOG_LOGTEMP') drop table T_XT_SYNCRELATIONSLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "SELECT * into T_XT_SYNCRELATIONSLOG_LOGTEMP from T_XT_SYNCRELATIONSLOG where fcreatetime > {" + logCleanTime + "}";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "truncate table T_XT_SYNCRELATIONSLOG";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "insert into T_XT_SYNCRELATIONSLOG select * from T_XT_SYNCRELATIONSLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "drop table T_XT_SYNCRELATIONSLOG_LOGTEMP";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        return true;
    }

    public static boolean handBindXtId(Context ctx, String openId, String userId, String personId) {
        if (StringUtils.isEmpty((String)userId) && StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String sql = "update t_pm_easxtusermap set fxtid = ? where ";
        int count = 1;
        if (!StringUtils.isEmpty((String)userId)) {
            ++count;
            sql = sql + " fuserid = ? ";
        }
        if (!StringUtils.isEmpty((String)personId)) {
            ++count;
            sql = sql.contains(" fuserid ") ? sql + " and fpersonid = ? " : sql + " fpersonid = ? ";
        }
        Object[] params = new Object[count];
        params[0] = openId;
        if (sql.contains("fuserid")) {
            params[1] = userId;
            if (count == 3) {
                params[2] = personId;
            }
        } else {
            params[1] = personId;
        }
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)("\u7ed1\u5b9a\u5931\u8d25\uff0cbind sql =====" + sql + " openId=" + openId + " userId=" + userId + " personId=" + personId));
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAllXtPerson(Context ctx, String condition) {
        String filter;
        StringBuilder sb = new StringBuilder("select xt.fid,xt.fpersonname,xt.fcell,xt.femail,xt.forglongname,xt.fposition,xt.fgender,xt.fphones,xt.fstatus,xt.fpersonnumber from t_xt_user xt ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fid = '").append(filter).append("'").append(" or xt.fpersonname like '%").append(filter).append("%'").append(" or xt.forglongname like '%").append(filter).append("%'").append(" or xt.fposition like '%").append(filter).append("%'").append(" or xt.fphones like '%").append(filter).append("%'").append(" or xt.fcell like '%").append(filter).append("%'").append(" or xt.femail like '%").append(filter).append("%'").append(" or xt.fpersonnumber like '%").append(filter).append("%'");
            if ("\u7537".equals(filter)) {
                sb.append(" or xt.fgender = '").append(1).append("'");
            } else if ("\u5973".equals(filter)) {
                sb.append(" or xt.fgender = '").append(2).append("'");
            }
            if ("\u6ce8\u9500".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(2).append("'");
            } else if ("\u6b63\u5e38".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(1).append("'");
            } else if ("\u7981\u7528".equals(filter)) {
                sb.append(" or xt.fstatus = '").append(0).append("'");
            }
            sb.append(")");
        }
        IRowSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        int index = 1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sb.toString() + ") countt"));
            if (rs.next()) {
                total = rs.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append(" order by xt.forglongname asc ").toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                map = new HashMap();
                map.put("fid", rs.getString("fid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fposition", rs.getString("fposition"));
                map.put("fgender", rs.getString("fgender"));
                map.put("fphones", rs.getString("fphones"));
                map.put("fstatus", "1".equals(rs.getString("fstatus")) ? "\u6b63\u5e38" : ("0".equals(rs.getString("fstatus")) ? "\u6ce8\u9500" : "\u7981\u7528"));
                map.put("findex", index);
                map.put("fjobno", rs.getString("fpersonnumber"));
                ++index;
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSyncRecords(Context ctx, String condition) throws BOSException {
        String sql = "select fid, fsynchtime from t_xt_synchtime order by fsynchtime desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map = new HashMap();
                Timestamp synchtime = rs.getTimestamp("fsynchtime");
                map.put("id", rs.getString("fid"));
                map.put("synchtime", EasXtCommonUtils.formLongTimeString(synchtime));
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONArray.fromObject(list).toString();
    }

    public static boolean setNoSyncOrg(Context ctx, boolean noSync, boolean showSub, String orgId) throws BOSException {
        if (orgId == null) {
            return false;
        }
        orgId = orgId == null ? "" : orgId.replaceAll(" ", "+");
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        StringBuilder detailLogMsg = new StringBuilder();
        detailLogMsg.append("\u7ec4\u7ec7\u3010");
        detailLogMsg.append(adminInfo.getNumber() + "  ");
        detailLogMsg.append(adminInfo.getName());
        detailLogMsg.append("\u3011\u53ca\u5176\u4e0b\u7ea7\u5df2\u88ab\u8bbe\u7f6e\u4e3a'");
        detailLogMsg.append(noSync ? "\u4e0d\u540c\u6b65" : "\u540c\u6b65");
        detailLogMsg.append("';\n");
        String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177-\u540c\u6b65\u8bbe\u7f6e\u8303\u56f4", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg.toString(), (String)"XTSync_Operate", (String)companyId);
        if (null != beginLog) {
            String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        String orgLongNumber = adminInfo.getLongNumber();
        boolean ret = false;
        ret = noSync ? EasXtViewDataUtil.setNoSyncOrgReal(ctx, showSub, orgLongNumber) : EasXtViewDataUtil.setSyncOrgReal(ctx, showSub, orgLongNumber);
        if (ret) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        }
        return ret;
    }

    public static boolean setNoSyncPosition(Context ctx, boolean noSync, boolean showSub, String positionId) throws BOSException {
        if (positionId == null || StringUtils.isEmpty((String)positionId)) {
            return true;
        }
        PositionInfo positionInfo = null;
        try {
            positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (positionInfo == null) {
            return true;
        }
        StringBuilder detailLogMsg = new StringBuilder();
        detailLogMsg.append("\u804c\u4f4d\u3010");
        detailLogMsg.append(positionInfo.getNumber() + "  ");
        detailLogMsg.append(positionInfo.getName());
        detailLogMsg.append("\u3011\u5df2\u88ab\u8bbe\u7f6e\u4e3a'");
        detailLogMsg.append(noSync ? "\u4e0d\u540c\u6b65" : "\u540c\u6b65");
        detailLogMsg.append("';\n");
        String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177-\u540c\u6b65\u8bbe\u7f6e\u8303\u56f4", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg.toString(), (String)"XTSync_Operate", (String)companyId);
        if (null != beginLog) {
            String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        String Sql = null;
        if (noSync) {
            String selectSql = "SELECT * from T_XT_NOSYNCPERSON  WHERE FPERSONID=? AND FPOSITIONID = ?";
            try {
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new String[]{"(" + positionId + ")", positionId});
                if (row.size() < 1) {
                    String insertSql = "INSERT INTO T_XT_NOSYNCPERSON (fpersonid,fpositionid,ftype) VALUES (?,?,2)";
                    DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new String[]{"(" + positionId + ")", positionId});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Sql = "INSERT INTO t_xt_nosyncperson(fpersonid,fpositionid,ftype) SELECT distinct(map.fpersonid),po.fpositionid,2 FROM t_pm_easxtusermap map INNER JOIN  t_bd_person per on map.fpersonid = per.fid INNER JOIN t_org_positionmember po on po.FPERSONID = per.FID where po.FPOSITIONID = ? and po.FISPRIMARY = 1 and not exists(SELECT 1 FROM t_xt_nosyncperson n where n.fpersonid = map.fpersonid )";
        } else {
            Sql = "DELETE FROM t_xt_nosyncperson WHERE fpositionid = ?";
        }
        try {
            DbUtil.execute((Context)ctx, (String)Sql.toString(), (Object[])new String[]{positionId});
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        return true;
    }

    public static boolean setNoSyncOrgReal(Context ctx, boolean showSub, String orgLongNumber) {
        StringBuilder insertOrgSql = new StringBuilder();
        StringBuilder insertPersonSql = new StringBuilder();
        insertOrgSql.append(" insert into T_XT_NoSyncOrg(forgid) select org.fid from t_org_admin org ").append(" where  not exists(select 1 from T_XT_NoSyncOrg nso where org.fid=nso.forgid) and flongnumber ");
        insertPersonSql.append(" insert into T_XT_NoSyncPerson(fpersonid) select p.fid from t_org_admin org ").append(" inner join t_org_position pos on pos.fadminorgunitid = org.fid ").append(" inner join t_org_positionmember pm on pos.fid = pm.fpositionid ").append(" inner join t_bd_person p on p.fid = pm.fpersonid ").append(" where pm.fisprimary = 1 and not exists(select 1 from T_XT_NoSyncPerson nsp where nsp.fpersonid = p.fid)").append(" and org.flongnumber ");
        if (showSub) {
            insertOrgSql.append(" like '" + orgLongNumber + "%'");
            insertPersonSql.append(" like '" + orgLongNumber + "%'");
        } else {
            insertOrgSql.append(" = '" + orgLongNumber + "'");
            insertPersonSql.append(" = '" + orgLongNumber + "'");
        }
        try {
            DbUtil.execute((Context)ctx, (String)insertOrgSql.toString());
            DbUtil.execute((Context)ctx, (String)insertPersonSql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean setSyncOrgReal(Context ctx, boolean showSub, String orgLongNumber) {
        StringBuilder deleteOrgSql = new StringBuilder();
        StringBuilder deletePersonSql = new StringBuilder();
        deleteOrgSql.append("delete from T_XT_NoSyncOrg where forgid in (select org.fid from t_org_admin org where flongnumber ");
        deletePersonSql.append(" delete from T_XT_NoSyncPerson where fpersonid in (").append(" select p.fid from t_org_admin org ").append(" inner join t_org_position pos on pos.fadminorgunitid = org.fid ").append(" inner join t_org_positionmember pm on pos.fid = pm.fpositionid ").append(" inner join t_bd_person p on p.fid = pm.fpersonid ").append(" where org.flongnumber ");
        if (showSub) {
            deleteOrgSql.append(" like '" + orgLongNumber + "!%' or flongnumber = '");
            deleteOrgSql.append(orgLongNumber + "')");
            deletePersonSql.append(" like '" + orgLongNumber + "!%' or org.flongnumber = '");
            deletePersonSql.append(orgLongNumber + "')");
        } else {
            deleteOrgSql.append(" = '" + orgLongNumber + "')");
            deletePersonSql.append(" = '" + orgLongNumber + "')");
        }
        try {
            DbUtil.execute((Context)ctx, (String)deleteOrgSql.toString());
            DbUtil.execute((Context)ctx, (String)deletePersonSql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Map<String, Object> batchSetControl(Context ctx, String fileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (StringUtils.isEmpty((String)(fileName = FilenameUtils.normalize((String)fileName)))) {
            errorMsg = "\u6587\u4ef6\u540d\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\uff01";
            resultMap.put("false", errorMsg);
            return resultMap;
        }
        String filePath = System.getProperty("EAS_HOME") + "/server/properties/xt_keys/";
        File file = new File(filePath, fileName);
        if (!file.exists()) {
            errorMsg = "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01";
            resultMap.put("false", errorMsg);
            return resultMap;
        }
        Workbook wb = null;
        Sheet sheet = null;
        ArrayList<Map<String, String>> PersonList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> orgList = new ArrayList<Map<String, String>>();
        String[] pesonColumns = new String[]{"number", "name", "dept", "position", "status"};
        String[] orgColumns = new String[]{"number", "name", "status"};
        wb = EasXtViewDataUtil.readExcel(filePath + fileName);
        if (wb == null) {
            errorMsg = "\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684Excel\u6587\u4ef6\u7c7b\u578b\uff01";
            resultMap.put("false", errorMsg);
            return resultMap;
        }
        sheet = wb.getSheetAt(0);
        EasXtViewDataUtil.readExcel(sheet, PersonList, pesonColumns);
        sheet = wb.getSheetAt(1);
        EasXtViewDataUtil.readExcel(sheet, orgList, orgColumns);
        Map rowInfo = new HashMap();
        HashMap<Integer, String> perResult = new HashMap<Integer, String>();
        HashMap<Integer, String> orgResult = new HashMap<Integer, String>();
        String orgSql = "select Fid from t_org_admin WHERE FNUMBER=? and fname_l2=?";
        for (int i = 0; i < orgList.size(); ++i) {
            rowInfo = (Map)orgList.get(i);
            String number = rowInfo.get("number").toString();
            String name = rowInfo.get("name").toString();
            String status = rowInfo.get("status").toString();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)orgSql, (Object[])new String[]{number, name});
                if (rs.next()) {
                    String orgId = rs.getString("fid");
                    if ("\u4e0d\u4e0a\u4f20".equals(status) || "0".equals(status)) {
                        EasXtViewDataUtil.setNoSyncOrg(ctx, true, true, orgId);
                        continue;
                    }
                    if ("\u4e0a\u4f20".equals(status) || "1".equals(status)) {
                        EasXtViewDataUtil.setNoSyncOrg(ctx, false, true, orgId);
                        continue;
                    }
                    orgResult.put(i, number);
                    continue;
                }
                orgResult.put(i, number);
                continue;
            }
            catch (Exception e) {
                orgResult.put(i, number);
                e.printStackTrace();
            }
        }
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<String> removeList = new ArrayList<String>();
        String perSql = "select Fid from T_BD_PERSON WHERE FNUMBER=? and fname_l2=?";
        for (int i = 0; i < PersonList.size(); ++i) {
            rowInfo = (Map)PersonList.get(i);
            String number = rowInfo.get("number").toString();
            String name = rowInfo.get("name").toString();
            String status = rowInfo.get("status").toString();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)perSql, (Object[])new String[]{number, name});
                if (rs.next()) {
                    if ("\u4e0d\u4e0a\u4f20".equals(status) || "0".equals(status)) {
                        String personId = rs.getString("fid");
                        addList.add(personId);
                        continue;
                    }
                    if ("\u4e0a\u4f20".equals(status) || "1".equals(status)) {
                        removeList.add(rs.getString("fid"));
                        continue;
                    }
                    perResult.put(i, number);
                    continue;
                }
                perResult.put(i, number);
                continue;
            }
            catch (BOSException e) {
                perResult.put(i, number);
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                perResult.put(i, number);
                e.printStackTrace();
            }
        }
        try {
            EasXtSyncFacadeFactory.getLocalInstance(ctx).setNoSyncPerson(true, addList);
            EasXtSyncFacadeFactory.getLocalInstance(ctx).setNoSyncPerson(false, removeList);
        }
        catch (BOSException e) {
            errorMsg = "\u4eba\u5458\u540c\u6b65\u8bbe\u7f6e\u65f6\u5f02\u5e38\uff1a" + e.getMessage();
            resultMap.put("false", errorMsg);
            return resultMap;
        }
        ArrayList<HashMap<Integer, String>> msgList = new ArrayList<HashMap<Integer, String>>();
        msgList.add(perResult);
        msgList.add(orgResult);
        resultMap.put("true", msgList);
        return resultMap;
    }

    private static void readExcel(Sheet sheet, List<Map<String, String>> list, String[] columns) {
        Row row = null;
        Cell cell = null;
        int rownum = sheet.getPhysicalNumberOfRows();
        row = sheet.getRow(1);
        int colnum = row.getPhysicalNumberOfCells();
        for (int i = 2; i < rownum; ++i) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            row = sheet.getRow(i);
            if (row == null) break;
            for (int j = 0; j < colnum; ++j) {
                cell = row.getCell(j);
                String cellValue = null;
                if (null != cell) {
                    cell.setCellType(CellType.STRING);
                    switch (cell.getCellType().getCode()) {
                        case 0: {
                            cellValue = cell.getNumericCellValue() + "";
                            break;
                        }
                        case 1: {
                            cellValue = cell.getStringCellValue();
                            break;
                        }
                        case 4: {
                            cellValue = cell.getBooleanCellValue() + "";
                            break;
                        }
                        case 2: {
                            cellValue = cell.getCellFormula() + "";
                            break;
                        }
                        case 3: {
                            cellValue = "";
                            break;
                        }
                        case 5: {
                            cellValue = "\u975e\u6cd5\u5b57\u7b26";
                            break;
                        }
                        default: {
                            cellValue = "\u672a\u77e5\u7c7b\u578b";
                        }
                    }
                }
                map.put(columns[j], cellValue);
            }
            list.add(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook readExcel(String filePath) {
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                HSSFWorkbook hSSFWorkbook = wb = new HSSFWorkbook((InputStream)is);
                return hSSFWorkbook;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                XSSFWorkbook xSSFWorkbook = wb;
                return xSSFWorkbook;
            }
            wb = null;
            Workbook workbook = null;
            return workbook;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean getOrgSyncStatus(Context ctx, String orgId) {
        block8: {
            String sql = "select nso.forgid from T_XT_NoSyncOrg nso where nso.forgid = ?";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgId});
                if (rs.next()) {
                    boolean bl = true;
                    EasXtViewDataUtil.close(rs);
                    return bl;
                }
                EasXtViewDataUtil.close(rs);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EasXtViewDataUtil.close(rs);
            }
        }
        return false;
    }

    public static boolean deleteAllXtOrgLeader(Context ctx) throws BOSException {
        try {
            EasXtViewDataUtil.syncDeleteAllDatas(ctx, EasXtSyncItemType.BatchDeleteOrgLeader);
        }
        catch (EasXtException e1) {
            logger.error((Object)e1.getMessage());
        }
        try {
            DbUtil.execute((Context)ctx, (String)"truncate table T_PM_EASXTORGLEADER");
            DbUtil.execute((Context)ctx, (String)"truncate table T_XT_ORGLEADER");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean deleteAllXtPartJob(Context ctx) throws BOSException {
        try {
            EasXtViewDataUtil.syncDeleteAllDatas(ctx, EasXtSyncItemType.BatchDeletePartJob);
        }
        catch (EasXtException e1) {
            logger.error((Object)e1.getMessage());
        }
        try {
            DbUtil.execute((Context)ctx, (String)"truncate table T_PM_EASXTPARTMAP");
            DbUtil.execute((Context)ctx, (String)"truncate table t_xt_part");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean deleteAllXtRelations(Context ctx) throws BOSException {
        try {
            EasXtViewDataUtil.syncDeleteAllDatas(ctx, EasXtSyncItemType.BatchDeleteRelations);
        }
        catch (EasXtException e1) {
            logger.error((Object)e1.getMessage());
        }
        try {
            DbUtil.execute((Context)ctx, (String)"truncate table T_PM_EASXTRELATIONSMAP");
            DbUtil.execute((Context)ctx, (String)"truncate table t_xt_personrelations");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean syncDeleteAllDatas(Context ctx, EasXtSyncItemType itemType, com.alibaba.fastjson.JSONArray dataArray) throws BOSException, EasXtException {
        try {
            com.alibaba.fastjson.JSONObject response = null;
            if (EasXtSyncItemType.BatchDeleteOrgLeader.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteOrgLeader(dataArray);
            } else if (EasXtSyncItemType.BatchDeletePartJob.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeletePartJob(dataArray);
            } else if (EasXtSyncItemType.BatchDeleteRelations.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteRelations(dataArray);
            } else {
                return false;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    private static boolean syncDeleteAllDatas(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        try {
            com.alibaba.fastjson.JSONObject response = null;
            if (EasXtSyncItemType.BatchDeleteOrgLeader.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteAllOrgLeader();
            } else if (EasXtSyncItemType.BatchDeletePartJob.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteAllPartJob();
            } else if (EasXtSyncItemType.BatchDeleteRelations.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteAllRelations();
            } else {
                return false;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUpdateCellRecords(Context ctx, String condition) {
        String filter;
        StringBuffer sb = new StringBuffer("select xt.*, map.fcell mcell, xtuser.FPersonName, xtuser.FOrgLongName,xtuser.FPosition from T_XT_CellUpdateRecords xt left join t_pm_easxtusermap map on xt.fxtid = map.fxtid left join t_xt_user xtuser on xtuser.fid = xt.fxtid ");
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        int searchTime = o.getIntValue("searchTime");
        if (!StringUtils.isEmpty((String)filter)) {
            if (!sb.toString().contains(" where ")) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(" (xt.fxtid = '").append(filter).append("'").append(" or xt.fnewphone like '%").append(filter).append("%'").append(" or xt.foldphone like '%").append(filter).append("%'").append(" or xt.feid like '%").append(filter).append("%'").append(" or xtuser.FPersonName like '%").append(filter).append("%'").append(" or xtuser.FOrgLongName like '%").append(filter).append("%'").append(" or xtuser.FPosition like '%").append(filter).append("%'");
            sb.append(")");
        }
        if (searchTime != 0) {
            Date searchTimeDate = DateUtils.addDays((Date)new Date(), (int)(-searchTime));
            Timestamp searchTimeStamp = new Timestamp(searchTimeDate.getTime());
            sb.append(" and xt.fcreatetime >={" + searchTimeStamp + "} ");
        }
        IRowSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int total = 0;
        int index = 1;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sb.toString() + ") countt"));
            if (rs.next()) {
                total = rs.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.append(" order by xt.fcreatetime desc ").toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                map = new HashMap();
                String newPhone = rs.getString("fnewphone");
                String bindStatus = "<span style='color:red'>\u672a\u66f4\u65b0</span>";
                if (!StringUtils.isEmpty((String)newPhone) && newPhone.equals(rs.getString("mcell"))) {
                    bindStatus = "\u5df2\u66f4\u65b0";
                }
                map.put("fid", rs.getString("fid"));
                map.put("fxtid", rs.getString("fxtid"));
                map.put("fnewphone", newPhone);
                map.put("foldphone", rs.getString("foldphone"));
                map.put("feid", rs.getString("feid"));
                map.put("fcreatetime", rs.getString("FCreateTime"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fposition", rs.getString("fposition"));
                map.put("fbindstatus", bindStatus);
                map.put("findex", index);
                ++index;
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    public static void bindUpdateCellToMap(Context ctx, String id, String xtId) throws BOSException {
        logger.error((Object)"\u662f\u5426\u8fdb\u5165\u4e91\u4e4b\u5bb6\u66f4\u65b0\u624b\u673a\u53f7\u5230\u672c\u5730\u63a5\u53e3");
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("bindUpdateCellToMap");
        if (!StringUtils.isEmpty((String)id)) {
            EasXtViewDataUtil.bindMapCellToEAS(ctx, xtId);
        } else {
            try {
                EasXtViewDataUtil.bindMapCellToEAS(ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private static void bindMapCellToEAS(Context ctx) throws BOSException {
        EasXtViewDataUtil.bindUpdateCellToEASReal(ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void bindMapCellToEAS(Context ctx, String xtId) throws BOSException {
        block10: {
            String sql = "select count(1) from t_pm_easxtusermap where fxtid = ? ";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{xtId});
                if (rs.next()) {
                    int count = rs.getInt(1);
                    if (count > 1) {
                        throw new BOSException("\u4e2d\u95f4\u8868\u5b58\u5728\u4e00\u4e2aopenId\u5bf9\u5e94\u591a\u4e2a\u7528\u6237\u6216\u804c\u5458\u7684\u60c5\u51b5\uff0c\u66f4\u65b0\u5931\u8d25\uff1bopenId is " + xtId);
                    }
                    if (count < 1) {
                        throw new BOSException("\u4e2d\u95f4\u8868\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7ed1\u5b9a\u7528\u6237\uff0c\u66f4\u65b0\u5931\u8d25\uff1bopenId is " + xtId);
                    }
                }
                EasXtViewDataUtil.close(rs);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EasXtViewDataUtil.close(rs);
            }
        }
        EasXtViewDataUtil.bindUpdateCellToEASReal(ctx, xtId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindUpdateCellToEASReal(Context ctx, String xtId) throws BOSException {
        String getNeedUpdateCell = null;
        IRowSet rs = null;
        HashMap userMap = new HashMap();
        HashMap personMap = new HashMap();
        HashMap<String, String> umapMap = new HashMap<String, String>();
        boolean isHandUpdate = !StringUtils.isEmpty((String)xtId);
        try {
            if (!StringUtils.isEmpty((String)xtId)) {
                getNeedUpdateCell = EasXtSyncUtil.getInstance(ctx).getValue("getNeedUpdateCellWithXTID");
                rs = DbUtil.executeQuery((Context)ctx, (String)getNeedUpdateCell, (Object[])new Object[]{xtId});
            } else {
                getNeedUpdateCell = EasXtSyncUtil.getInstance(ctx).getValue("getNeedUpdateCell");
                rs = DbUtil.executeQuery((Context)ctx, (String)getNeedUpdateCell);
            }
            HashMap<String, String> tmpMap = null;
            while (rs.next()) {
                String usrId = rs.getString("userid");
                String personId = rs.getString("personid");
                String fxtId = rs.getString("xtid");
                String newPhone = rs.getString("newphone");
                String createtime = rs.getString("createtime");
                if (!StringUtils.isEmpty((String)usrId) && !userMap.containsKey(usrId)) {
                    tmpMap = new HashMap<String, String>();
                    tmpMap.put("newPhone", newPhone);
                    tmpMap.put("createtime", createtime);
                    tmpMap.put("xtid", fxtId);
                    userMap.put(usrId, tmpMap);
                }
                if (!StringUtils.isEmpty((String)personId) && !personMap.containsKey(personId)) {
                    tmpMap = new HashMap();
                    tmpMap.put("newPhone", newPhone);
                    tmpMap.put("createtime", createtime);
                    tmpMap.put("xtid", fxtId);
                    personMap.put(personId, tmpMap);
                }
                if (StringUtils.isEmpty((String)fxtId) || umapMap.containsKey(fxtId)) continue;
                tmpMap = new HashMap();
                umapMap.put(fxtId, newPhone);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Iterator uit = userMap.keySet().iterator();
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = null;
        boolean isRegister = false;
        try {
            ILicenseSrvAgent license = LicenseSrvAgentFactory.getRemoteInstance();
            isRegister = license.isRegister();
        }
        catch (NoSuchMethodError e) {
            logger.error((Object)"8.0\u53ca\u4ee5\u524d\u7248\u672c\uff0c\u65e0\u6ce8\u518c\u7528\u6237\uff01");
        }
        catch (Exception e1) {
            logger.error((Object)"8.0\u53ca\u4ee5\u524d\u7248\u672c\uff0c\u65e0\u6ce8\u518c\u7528\u6237\uff01");
        }
        while (uit.hasNext()) {
            String userId = (String)uit.next();
            HashMap tmpMap = (HashMap)userMap.get(userId);
            String cell = (String)tmpMap.get("newPhone");
            String createTime = (String)tmpMap.get("createtime");
            String tmpXtId = (String)tmpMap.get("xtid");
            if (cell == null) continue;
            try {
                user = iuser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                if (user == null) continue;
                if (cell.equals(user.getCell())) {
                    umapMap.remove(tmpXtId);
                    continue;
                }
                if (EasXtCommonUtils.formLongTimeString(createTime).before(user.getLastUpdateTime()) && !isHandUpdate) {
                    umapMap.remove(tmpXtId);
                    continue;
                }
                user.setNCell(cell);
                if (isRegister) {
                    RegisterUserUtil.updateUserNotSynToCloud(iuser, user);
                    continue;
                }
                iuser.update((IObjectPK)new ObjectUuidPK(userId), (CoreBaseInfo)user);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u9519\u8bef\u7528\u6237\u6570\u636e\u4e3a" + user.getId()));
            }
        }
        Iterator pit = personMap.keySet().iterator();
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo person = null;
        while (pit.hasNext()) {
            String personId = (String)pit.next();
            HashMap tmpMap = (HashMap)personMap.get(personId);
            String cell = (String)tmpMap.get("newPhone");
            String createTime = (String)tmpMap.get("createtime");
            String tmpXtId = (String)tmpMap.get("xtid");
            if (cell == null) continue;
            try {
                person = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                if (cell.equals(person.getCell())) {
                    umapMap.remove(tmpXtId);
                    continue;
                }
                if (EasXtCommonUtils.formLongTimeString(createTime).before(person.getLastUpdateTime()) && !isHandUpdate) {
                    umapMap.remove(tmpXtId);
                    continue;
                }
                person.setNCell(cell);
                iperson.update((IObjectPK)new ObjectUuidPK(personId), (CoreBaseInfo)person);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        String sql = "update t_pm_easxtusermap set fcell = ? where fxtid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (String fxtId : umapMap.keySet()) {
                String cell = (String)umapMap.get(fxtId);
                ps.setString(1, cell);
                ps.setString(2, fxtId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e1) {
            try {
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(ps);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)conn);
            SQLUtils.cleanup((Statement)ps);
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)ps);
        List list = EasXtViewDataUtil.getPluginList(ctx, EasXtSyncUtil.getInstance(ctx).getEid());
        EasXtViewDataUtil.invokePlugin(list, ctx, userMap, personMap);
    }

    public static void invokePlugin(List list, Context ctx, Map userMap, Map personMap) {
        if (null == list) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            EasXtViewDataUtil.invokePlugin((String)list.get(i), ctx, userMap, personMap);
        }
    }

    public static void invokePlugin(String className, Context ctx, Map userMap, Map personMap) {
        try {
            Class<?> clz = Class.forName(className);
            Object obj = clz.newInstance();
            EasXtViewDataUtil.invokePlugin4User(clz, obj, ctx, userMap);
            EasXtViewDataUtil.invokePlugin4Person(clz, obj, ctx, personMap);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void invokePlugin4User(Class clz, Object targetObj, Context ctx, Map userMap) {
        try {
            Method fireUpdateCellWithUserId = clz.getDeclaredMethod("fireUpdateCellWithUserId", Context.class, Map.class);
            fireUpdateCellWithUserId.invoke(targetObj, ctx, userMap);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"\u8c03\u7528\u5904\u7406\u7528\u6237\u624b\u673a\u53d8\u66f4\u7684\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38\uff1a\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
            e.printStackTrace();
        }
    }

    private static void invokePlugin4Person(Class clz, Object targetObj, Context ctx, Map personMap) {
        try {
            Method fireUpdateCellWithPersonId = clz.getDeclaredMethod("fireUpdateCellWithPersonId", Context.class, Map.class);
            fireUpdateCellWithPersonId.invoke(targetObj, ctx, personMap);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error((Object)"\u8c03\u7528\u5904\u7406\u804c\u5458\u624b\u673a\u53d8\u66f4\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38\uff1a\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPluginList(Context ctx, String eid) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select fclassname from T_XT_CellUpdatePlugin order by fcreatetime desc";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                list.add(rs.getString("fclassname"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            EasXtViewDataUtil.close(rs);
        }
        return list;
    }

    public static boolean addSyncPlugin(Context ctx, String pluginName, String eid) {
        boolean ret = false;
        if (StringUtils.isEmpty((String)eid) || StringUtils.isEmpty((String)pluginName)) {
            return false;
        }
        if (!EasXtViewDataUtil.removeSyncPlugin(ctx, pluginName, eid)) {
            return false;
        }
        String sql = "insert into T_XT_CellUpdatePlugin(fid, FCreateTime, fclassname,feid) values(?,?,?,?)";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{BOSUuid.create((String)"F4AF4F04").toString(), new Timestamp(new Date().getTime()), pluginName, eid});
            ret = true;
        }
        catch (BOSException e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean removeSyncPlugin(Context ctx, String pluginName, String eid) {
        boolean ret = false;
        String sql = "delete from T_XT_CellUpdatePlugin where fclassname = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pluginName});
            ret = true;
        }
        catch (BOSException e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    public static void close(IRowSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void updatePersonRealDelete(Context ctx, com.alibaba.fastjson.JSONArray dataArray) {
        if (dataArray.size() == 0) {
            return;
        }
        try {
            String sql = "UPDATE T_BD_PERSONDELETE p  SET fissynctocloud = 1 WHERE EXISTS (SELECT 1 FROM T_pm_easxtusermap where fpersonid = p.fpersonid and fxtid in(" + EasXtCommonUtils.getIncludeStr((String[])dataArray.toArray((Object[])new String[dataArray.size()])) + ")) and fissynctocloud = 0";
            DbUtil.execute((Context)ctx, (String)sql);
            String sql2 = "DELETE FROM T_PM_EASXTUSERMAP p where p.fxtid in( " + EasXtCommonUtils.getIncludeStr((String[])dataArray.toArray((Object[])new String[dataArray.size()])) + ") and exists(SELECT 1 FROM T_bd_persondelete where fpersonid = p.fpersonid and fissynctocloud = 1)";
            DbUtil.execute((Context)ctx, (String)sql2);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static boolean saveClearLog(Context ctx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        int logCleanTimeInt = o.getIntValue("logCleanTime");
        int isDeleteOrgLog = o.getInteger("isDeleteOrgLog");
        int isDeletePersonLog = o.getInteger("isDeletePersonLog");
        int isDeleteDeptLeaderLog = o.getInteger("isDeleteDeptLeaderLog");
        int isDeletePartJobLog = o.getInteger("isDeletePartJobLog");
        int isDeleteRelationsLog = o.getInteger("isDeleteRelationsLog");
        String sql = "insert into T_XT_CleanLogSetting(FID,FCreateTime,FIsDeleteOrgLog,FIsDeletePersonLog,FIsDeleteDeptLeaderLog, FIsDeletePartJobLog ,FIsDeleteRelationsLog, FLogCleanTime) values(?,?,?,?,?,?,?,?)";
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(BOSUuid.create((String)"F4AF4F04").toString());
        param.add(new Timestamp(new Date().getTime()));
        param.add(isDeleteOrgLog);
        param.add(isDeletePersonLog);
        param.add(isDeleteDeptLeaderLog);
        param.add(isDeletePartJobLog);
        param.add(isDeleteRelationsLog);
        param.add(logCleanTimeInt);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param.toArray());
        return true;
    }
}

