/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.CodeException;
import com.tool.classfile.ConstantPool;
import com.tool.classfile.DynamicClassLoader;
import com.tool.classfile.ExtraAttribute;
import com.tool.classfile.FieldDefinition;
import com.tool.classfile.InnerClass;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.MethodRef;
import com.tool.classfile.SourceWriter;
import com.tool.classfile.binary.ClassFile;
import com.tool.classfile.pcodes.CodesBlock;
import com.tool.classfile.pcodes.CodesWriter;
import com.tool.classfile.sc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

public class ClassDefinition {
    public ConstantPool pool = new ConstantPool();
    public int magic = -889275714;
    public int major_version = 45;
    public int minor_version = 3;
    public int access_flags;
    public String className;
    public String superClassName;
    public String[] interfaces;
    public Hashtable fields = new Hashtable();
    public Hashtable methods = new Hashtable();
    public String sourceFile = null;
    public String sourceDir = null;
    public boolean deprecated = false;
    public Vector extra_attributes = new Vector();
    public Vector inner_classes = new Vector();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tool$classfile$FieldDefinition;
    static /* synthetic */ Class class$com$tool$classfile$MethodDefinition;
    static /* synthetic */ Class class$com$tool$classfile$InnerClass;
    static /* synthetic */ Class class$com$tool$classfile$ExtraAttribute;

    private void init(String name, String superClass, int _access_flags, String[] _interfaces) {
        this.className = sc.className(name);
        this.superClassName = superClass == null && (_access_flags & 0x200) == 0 ? sc.className(class$java$lang$Object == null ? (class$java$lang$Object = ClassDefinition.class$("java.lang.Object")) : class$java$lang$Object) : superClass;
        this.access_flags = _access_flags;
        this.interfaces = _interfaces == null ? new String[0] : _interfaces;
    }

    public ClassDefinition(String name, String superClass, int _access_flags, String[] _interfaces) {
        this.init(name, superClass, _access_flags, _interfaces);
    }

    public ClassDefinition(String fullname) throws Exception {
        String[] ifs;
        String superClass;
        String name;
        int acc_flags = 0;
        fullname = fullname.trim();
        int index = fullname.indexOf(" class ");
        if (index < 0) {
            CodeException.assertThat(fullname.startsWith("class "));
            fullname = fullname.substring(5).trim();
        } else {
            String flags = fullname.substring(0, index).trim();
            acc_flags = this.parse_access_flags(flags);
            fullname = fullname.substring(index + 6).trim();
        }
        index = fullname.indexOf(32);
        if (index < 0) {
            name = fullname;
            superClass = "java/lang/Object";
            ifs = new String[]{};
        } else {
            name = fullname.substring(0, index).trim();
            if ((fullname = fullname.substring(index + 1).trim()).startsWith("extends ")) {
                index = (fullname = fullname.substring(7).trim()).indexOf(32);
                if (index < 0) {
                    superClass = fullname;
                    fullname = "";
                } else {
                    superClass = fullname.substring(0, index).trim();
                    fullname = fullname.substring(index).trim();
                }
                superClass = sc.classDescriptor(sc.getJavaClass(superClass));
            } else {
                superClass = "java/lang/Object";
            }
            if (fullname.startsWith("implements ")) {
                fullname = fullname.substring(10).trim();
                Vector<String> is = new Vector<String>();
                while (fullname.length() > 0) {
                    fullname = fullname + " ";
                    index = fullname.indexOf(32);
                    is.addElement(fullname.substring(0, index));
                    fullname = fullname.substring(index).trim();
                }
                ifs = new String[is.size()];
                int i = 0;
                while (i < is.size()) {
                    ifs[i] = sc.classDescriptor(sc.getJavaClass((String)is.elementAt(i)));
                    ++i;
                }
            } else {
                ifs = new String[]{};
            }
        }
        this.init(name, superClass, acc_flags, ifs);
    }

    private static String method_key(String name, String descriptor) {
        return name + descriptor;
    }

    public void removeMethod(MethodDefinition md) {
        this.methods.remove(ClassDefinition.method_key(md.name, md.descriptor));
    }

    public MethodDefinition getMethod(String name, String descriptor) {
        return (MethodDefinition)this.methods.get(ClassDefinition.method_key(name, descriptor));
    }

    public MethodDefinition declareMethod(String name, String descriptor, int access_flags, String[] exceptions) {
        String methodKey = ClassDefinition.method_key(name, descriptor);
        if (this.methods.containsKey(methodKey)) {
            throw new CodeException("method " + methodKey + " redefined.");
        }
        MethodDefinition method = new MethodDefinition(this, name, descriptor, exceptions, access_flags);
        this.methods.put(methodKey, method);
        return method;
    }

    public MethodDefinition declareMethod(Method md) {
        String name = md.getName();
        String descriptor = sc.methodDescriptor(md);
        int access_flags = md.getModifiers() & 0xFFFFFBFF;
        Class<?>[] es = md.getExceptionTypes();
        String[] exceptions = new String[es.length];
        int i = 0;
        while (i < es.length) {
            exceptions[i] = sc.className(es[i]);
            ++i;
        }
        return this.declareMethod(name, descriptor, access_flags, exceptions);
    }

    public MethodDefinition declareMethod(String fullname) throws Exception {
        int index = fullname.indexOf(40);
        String s = fullname.substring(0, index).trim();
        fullname = fullname.substring(index + 1);
        index = s.lastIndexOf(32);
        String name = s.substring(index).trim();
        s = s.substring(0, index).trim();
        index = s.lastIndexOf(32);
        String type = s.substring(index).trim();
        s = s.substring(0, index).trim();
        int acc_flags = this.parse_access_flags(s);
        Vector<String> pns = new Vector<String>();
        index = fullname.indexOf(41);
        String ps = fullname.substring(0, index).trim();
        fullname = fullname.substring(index + 1).trim();
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        if (ps.length() > 0) {
            ps = ps + ",";
            while (ps.length() > 0) {
                index = ps.indexOf(44);
                String p = ps.substring(0, index).trim();
                ps = ps.substring(index + 1).trim();
                index = p.indexOf(32);
                if (index > 0) {
                    sb.append(sc.classDescriptor(sc.getJavaClass(p.substring(0, index).trim())));
                    pns.addElement(p.substring(index).trim());
                    continue;
                }
                sb.append(sc.classDescriptor(sc.getJavaClass(p)));
                pns.addElement(null);
            }
        }
        sb.append(")");
        sb.append(sc.classDescriptor(sc.getJavaClass(type)));
        String desc = sb.toString();
        Vector<String> es = new Vector<String>();
        if (fullname.startsWith("throws")) {
            s = fullname.substring(6).trim();
            while (s.length() > 0) {
                s = s + " ";
                index = s.indexOf(32);
                String e = s.substring(0, index).trim();
                s = s.substring(index).trim();
                es.addElement(sc.className(sc.getJavaClass(e)));
            }
        }
        String[] exs = (String[])sc.toArray(class$java$lang$String == null ? (class$java$lang$String = ClassDefinition.class$("java.lang.String")) : class$java$lang$String, es);
        MethodDefinition method = this.declareMethod(name, desc, acc_flags, exs);
        int i = 0;
        while (i < pns.size()) {
            String pname = (String)pns.elementAt(i);
            if (pname != null) {
                method.args[i].name = pname;
            }
            ++i;
        }
        return method;
    }

    public void declareDefaultConstructor() {
        MethodDefinition method = this.declareMethod("<init>", "()V", 1, null);
        CodesWriter out = new CodesWriter(method);
        CodesBlock block = out.main;
        block._var_load(25, method._this);
        MethodRef ref = new MethodRef(this.superClassName, "<init>", "()V");
        block._invokespecial(ref);
        block._return(177);
        method.setCodes(out);
    }

    public FieldDefinition declareField(String fullname) throws Exception {
        int index = fullname.lastIndexOf(32);
        String name = fullname.substring(index).trim();
        fullname = fullname.substring(0, index).trim();
        index = fullname.lastIndexOf(32);
        String type = fullname.substring(index).trim();
        String flags = fullname.substring(0, index).trim();
        return this.declareField(name, sc.getJavaClass(type), this.parse_access_flags(flags));
    }

    public FieldDefinition getField(String name) {
        return (FieldDefinition)this.fields.get(name);
    }

    public void removeField(String name) {
        this.fields.remove(name);
    }

    private int parse_access_flags(String flags) {
        int access_flags = 0;
        while (flags.length() > 0) {
            flags = flags + " ";
            int index = flags.indexOf(32);
            String f = flags.substring(0, index);
            flags = flags.substring(index + 1).trim();
            if (f.equals("public")) {
                access_flags |= 1;
                continue;
            }
            if (f.equals("protected")) {
                access_flags |= 4;
                continue;
            }
            if (f.equals("private")) {
                access_flags |= 2;
                continue;
            }
            if (f.equals("native")) {
                access_flags |= 0x100;
                continue;
            }
            if (f.equals("static")) {
                access_flags |= 8;
                continue;
            }
            if (f.equals("final")) {
                access_flags |= 0x10;
                continue;
            }
            if (f.equals("transient")) {
                access_flags |= 0x80;
                continue;
            }
            if (f.equals("volatile")) {
                access_flags |= 0x40;
                continue;
            }
            if (f.equals("synchronized")) {
                access_flags |= 0x20;
                continue;
            }
            throw new CodeException("unknown modifier '" + f + "'");
        }
        return access_flags;
    }

    public FieldDefinition declareField(String name, String type, int access_flags) {
        if (this.fields.containsKey(name)) {
            throw new CodeException("field " + name + " redefined.");
        }
        FieldDefinition field = new FieldDefinition(this, name, type, access_flags);
        this.fields.put(name, field);
        return field;
    }

    public FieldDefinition declareField(String name, Class type, int access_flags) {
        return this.declareField(name, sc.classDescriptor(type), access_flags);
    }

    public FieldDefinition[] getFields() {
        return (FieldDefinition[])sc.toArray(class$com$tool$classfile$FieldDefinition == null ? (class$com$tool$classfile$FieldDefinition = ClassDefinition.class$("com.tool.classfile.FieldDefinition")) : class$com$tool$classfile$FieldDefinition, this.fields.elements());
    }

    public MethodDefinition[] getMethods() {
        return (MethodDefinition[])sc.toArray(class$com$tool$classfile$MethodDefinition == null ? (class$com$tool$classfile$MethodDefinition = ClassDefinition.class$("com.tool.classfile.MethodDefinition")) : class$com$tool$classfile$MethodDefinition, this.methods.elements());
    }

    public InnerClass[] getInnerClasses() {
        return (InnerClass[])sc.toArray(class$com$tool$classfile$InnerClass == null ? (class$com$tool$classfile$InnerClass = ClassDefinition.class$("com.tool.classfile.InnerClass")) : class$com$tool$classfile$InnerClass, this.inner_classes.elements());
    }

    public ExtraAttribute[] getExtraAttributes() {
        return (ExtraAttribute[])sc.toArray(class$com$tool$classfile$ExtraAttribute == null ? (class$com$tool$classfile$ExtraAttribute = ClassDefinition.class$("com.tool.classfile.ExtraAttribute")) : class$com$tool$classfile$ExtraAttribute, this.extra_attributes);
    }

    public static final ClassDefinition load(byte[] data) {
        return ClassFile.read(data);
    }

    public static final ClassDefinition load(File file) throws IOException {
        return ClassFile.read(file);
    }

    public static final ClassDefinition load(String filename) throws IOException {
        return ClassFile.read(filename);
    }

    public byte[] toByteArray() {
        return ClassFile.toByteArray(this);
    }

    public Class toClass() throws Exception {
        return this.toClass(null, null);
    }

    public Class toClass(ClassLoader p1) throws Exception {
        return this.toClass(p1, null);
    }

    public Class toClass(ClassLoader p1, ClassLoader p2) throws Exception {
        return new DynamicClassLoader(p1, p2).createClass(sc.javaClassName0(this.className), this.toByteArray());
    }

    public void writeToFile(String file) throws IOException {
        byte[] data = this.toByteArray();
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(data);
        fout.close();
    }

    public void writeToFile(File file) throws IOException {
        byte[] data = this.toByteArray();
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(data);
        fout.close();
    }

    public void dump() throws IOException {
        this.dump(System.out);
    }

    public void dump(OutputStream _out) throws IOException {
        PrintWriter out = new PrintWriter(_out, true);
        out.println("class " + this.className + " extends " + this.superClassName);
        out.println("magic:\t" + Integer.toHexString(this.magic));
        out.println("version:\t" + this.major_version + "." + this.minor_version);
        out.println();
        out.println("constant_pool:");
        out.println();
        out.println("interfaces:\t" + this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            out.println("\t" + this.interfaces[i]);
            ++i;
        }
        out.println();
        FieldDefinition[] flds = this.getFields();
        out.println("fields:\t" + flds.length);
        int i2 = 0;
        while (i2 < flds.length) {
            flds[i2].dump(out);
            out.println();
            ++i2;
        }
        MethodDefinition[] mds = this.getMethods();
        out.println("methods:\t" + mds.length);
        int i3 = 0;
        while (i3 < mds.length) {
            mds[i3].dump(out);
            out.println();
            ++i3;
        }
        InnerClass[] inners = this.getInnerClasses();
        out.println("InnerClasses:\t" + inners.length);
        int i4 = 0;
        while (i4 < inners.length) {
            InnerClass cls = inners[i4];
            System.out.println("\t" + Modifier.toString(cls.access_flags) + " class " + cls.inner_class);
            System.out.println("\t\touter_class:\t" + cls.outer_class);
            System.out.println("\t\tinner_name:\t" + cls.inner_name);
            ++i4;
        }
        out.println("attributes:");
        if (this.deprecated) {
            out.println("\tDeprecated");
        }
        if (this.sourceDir != null) {
            out.println("\tSourceDir\t" + this.sourceDir);
        }
        if (this.sourceFile != null) {
            out.println("\tSourceFile\t" + this.sourceFile);
        }
        ClassDefinition.dumpExtraAttributes(this.extra_attributes, out);
    }

    static void dumpExtraAttributes(Vector attrs, PrintWriter out) throws IOException {
        int i = 0;
        while (i < attrs.size()) {
            ((ExtraAttribute)attrs.elementAt(i)).dump(out);
            ++i;
        }
    }

    public void buildAsm(String file) throws IOException {
        this.buildAsm(new File(file));
    }

    public void buildAsm(File file) throws IOException {
        this.sourceFile = file.getName();
        this.sourceDir = file.getParent();
        SourceWriter out = new SourceWriter(file);
        out.writeLine(Modifier.toString(this.access_flags) + " class " + this.className + " extends " + this.superClassName);
        if (this.interfaces.length > 0) {
            out.writeString("        implements ");
            int i = 0;
            while (i < this.interfaces.length) {
                if (i > 0) {
                    out.writeString(", ");
                }
                out.writeString(sc.javaClassName(this.interfaces[i]));
                ++i;
            }
            out.writeLine();
        }
        out.writeLine("{");
        SourceWriter out1 = new SourceWriter(out);
        FieldDefinition[] flds = this.getFields();
        int i = 0;
        while (i < flds.length) {
            flds[i].buildAsm(out1);
            ++i;
        }
        MethodDefinition[] mds = this.getMethods();
        int i2 = 0;
        while (i2 < mds.length) {
            mds[i2].buildAsm(out1);
            ++i2;
        }
        out.writeLine("}");
        out.close();
    }

    public String getDeclareString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.access_flags));
        sb.append(" class ");
        int index = this.className.lastIndexOf(47);
        if (index < 0) {
            sb.append(this.className);
        } else {
            sb.append(this.className.substring(index + 1));
        }
        if (!this.superClassName.equals("java/lang/Object")) {
            sb.append(" extends ");
            sb.append(sc.javaClassName(this.superClassName));
        }
        if (this.interfaces.length > 0) {
            sb.append(" implements ");
            int i = 0;
            while (i < this.interfaces.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(sc.javaClassName(this.interfaces[i]));
                ++i;
            }
        }
        return sb.toString().trim();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

