/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.ClassDefinition;
import com.tool.classfile.MethodRef;
import com.tool.classfile.SourceWriter;
import com.tool.classfile.pcodes.ByteCodes;
import com.tool.classfile.pcodes.CodesWriter;
import com.tool.classfile.pcodes.LocalVariable;
import com.tool.classfile.sc;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodDefinition {
    public String name;
    public String type;
    public String descriptor;
    public int access_flags;
    public String[] exceptions;
    public LocalVariable _this;
    public LocalVariable[] args;
    public int args_max_index;
    public ClassDefinition parent;
    public Vector extra_attributes = new Vector();
    public boolean deprecated = false;
    public boolean synthetic = false;
    protected ByteCodes codes = null;

    MethodDefinition(ClassDefinition _parent, String _name, String _descriptor, String[] _exceptions, int _access_flags) {
        this.parent = _parent;
        this.name = _name;
        this.descriptor = _descriptor;
        this.exceptions = _exceptions == null ? new String[0] : _exceptions;
        this.type = sc.methodReturnType(this.descriptor);
        this.access_flags = _access_flags;
        int baseIndex = 0;
        if (Modifier.isStatic(this.access_flags)) {
            this._this = null;
        } else {
            this._this = new LocalVariable("this", sc.classType(this.parent.className), 0);
            this._this.isParameter = true;
            ++baseIndex;
        }
        String[] argTypes = sc.methodParameters(this.descriptor);
        this.args = new LocalVariable[argTypes.length];
        int i = 0;
        while (i < this.args.length) {
            this.args[i] = new LocalVariable("p" + i, argTypes[i], baseIndex);
            this.args[i].isParameter = true;
            if (sc.isCategory2(argTypes[i])) {
                ++baseIndex;
            }
            ++i;
            ++baseIndex;
        }
        this.args_max_index = baseIndex;
    }

    public MethodRef newReference() {
        return new MethodRef(this.parent.className, this.name, this.descriptor);
    }

    public ByteCodes getCodes() {
        return this.codes;
    }

    public void setCodes(ByteCodes _codes) {
        if (_codes instanceof CodesWriter) {
            ((CodesWriter)_codes).finish();
        }
        this.codes = _codes;
    }

    private String javaReturnType() {
        if (this.name.equals("<init>")) {
            return "";
        }
        return sc.javaType(this.type) + " ";
    }

    private String javaMethodName() {
        if (this.name.equals("<init>")) {
            String s = sc.javaClassName(this.parent.className);
            int index = s.lastIndexOf(46);
            if (index >= 0) {
                s = s.substring(index + 1);
            }
            return s;
        }
        if (this.name.equals("<clinit>")) {
            return "";
        }
        return this.name;
    }

    public void dump(PrintWriter out) throws IOException {
        out.print(Modifier.toString(this.access_flags) + " " + this.javaReturnType() + this.javaMethodName());
        out.print("(");
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(sc.javaType(this.args[i].type) + " " + this.args[i].name);
            ++i;
        }
        out.println(")");
        if (this.exceptions.length > 0) {
            out.print("\t\tthrows ");
            int i2 = 0;
            while (i2 < this.exceptions.length) {
                if (i2 > 0) {
                    out.print(", ");
                }
                out.print(sc.javaClassName(this.exceptions[i2]));
                ++i2;
            }
            out.println();
        }
        out.println("Attributes:");
        if (this.deprecated) {
            out.println("\tDeprecated");
        }
        if (this.synthetic) {
            out.println("\tSynthetic");
        }
        ClassDefinition.dumpExtraAttributes(this.extra_attributes, out);
        if (this.codes != null) {
            out.println("Codes");
            this.codes.dump(out);
        }
    }

    void buildAsm(SourceWriter out) throws IOException {
        out.writeString(Modifier.toString(this.access_flags) + " " + this.javaReturnType() + this.javaMethodName());
        out.writeString("(");
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                out.writeString(", ");
            }
            out.writeString(sc.javaType(this.args[i].type) + " " + this.args[i].name);
            ++i;
        }
        out.writeString(")");
        if (this.exceptions.length > 0) {
            out.writeString("throws ");
            int i2 = 0;
            while (i2 < this.exceptions.length) {
                if (i2 > 0) {
                    out.writeString(", ");
                }
                out.writeString(sc.javaClassName(this.exceptions[i2]));
                ++i2;
            }
        }
        if (this.codes == null) {
            out.writeLine(";");
        } else {
            out.writeLine();
            out.writeLine("{");
            SourceWriter out1 = new SourceWriter(out);
            this.codes.buildAsm(this, out1);
            out.writeLine("}");
        }
    }

    public String getDeclareString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.access_flags) + " " + this.javaReturnType() + this.javaMethodName());
        sb.append("(");
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(sc.javaType(this.args[i].type) + " " + this.args[i].name);
            ++i;
        }
        sb.append(")");
        if (this.exceptions.length > 0) {
            sb.append("throws ");
            int i2 = 0;
            while (i2 < this.exceptions.length) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(sc.javaClassName(this.exceptions[i2]));
                ++i2;
            }
        }
        return sb.toString().trim();
    }
}

