/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.binary;

import com.tool.classfile.ByteCodeReader;
import com.tool.classfile.binary.AttributeInfo;
import com.tool.classfile.binary.Attributes;

public class CodeAttribute
extends AttributeInfo {
    public final int max_stack;
    public final int max_locals;
    public final byte[] code;
    public final exception_table_struct[] exception_table;
    public final Attributes attributes;

    CodeAttribute(byte[] info) {
        super("Code");
        ByteCodeReader in = new ByteCodeReader(info);
        this.max_stack = in.readu2();
        this.max_locals = in.readu2();
        int len = in.readu4();
        this.code = in.readBytes(len);
        len = in.readu2();
        this.exception_table = new exception_table_struct[len];
        int i = 0;
        while (i < len) {
            exception_table_struct item = new exception_table_struct();
            item.start_pc = in.readu2();
            item.end_pc = in.readu2();
            item.handler_pc = in.readu2();
            item.catch_type = in.readu2();
            this.exception_table[i] = item;
            ++i;
        }
        this.attributes = new Attributes(in);
    }

    public class exception_table_struct {
        public int start_pc;
        public int end_pc;
        public int handler_pc;
        public int catch_type;
    }
}

