/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.ClassDefinition;
import com.tool.classfile.FieldDefinition;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.SourceWriter;
import com.tool.classfile.pcodes.CodesBlock;
import com.tool.classfile.pcodes.CodesWriter;
import com.tool.simplecode.MethodCodes;
import com.tool.simplecode.Unit;
import java.io.File;
import java.io.IOException;

public class BuildEnv {
    public SourceWriter out;
    public final ClassDefinition cls;
    public final MethodDefinition method;
    public final CodesWriter codes;
    public final CodesBlock main;
    public CodesBlock current_block;
    public Unit current_unit = null;

    public BuildEnv(SourceWriter _out, CodesWriter _codes) {
        this.out = _out;
        this.codes = _codes;
        this.main = this.codes.main;
        this.method = this.codes.method;
        this.cls = this.method.parent;
        this.current_block = this.main;
    }

    public static void buildSource(ClassDefinition def, String filename, MethodCodes[] mds) throws IOException {
        SourceWriter out = new SourceWriter(filename);
        BuildEnv.buildSource(def, out, mds);
        out.close();
    }

    public static void buildSource(ClassDefinition def, File filename, MethodCodes[] mds) throws IOException {
        SourceWriter out = new SourceWriter(filename);
        BuildEnv.buildSource(def, out, mds);
        out.close();
    }

    public static void buildSource(ClassDefinition def, SourceWriter out, MethodCodes[] mds) throws IOException {
        String className;
        String packageName;
        int index = def.className.lastIndexOf(47);
        if (index >= 0) {
            packageName = def.className.substring(0, index).replace('/', '.');
            className = def.className.substring(index + 1);
        } else {
            packageName = null;
            className = def.className;
        }
        File f = out.getSourceFile();
        if (f == null) {
            def.sourceDir = null;
            def.sourceFile = className + ".java";
        } else {
            def.sourceDir = f.getParent();
            def.sourceFile = f.getName();
        }
        if (packageName != null) {
            out.writeLine("package " + packageName + ";");
        }
        out.writeLine("/* auto generate by simplecode*/");
        out.writeLine();
        out.writeLine(def.getDeclareString());
        out.writeLine("{");
        SourceWriter out1 = new SourceWriter(out);
        FieldDefinition[] fs = def.getFields();
        int i = 0;
        while (i < fs.length) {
            out1.writeLine(fs[i].getDeclareString() + ";");
            ++i;
        }
        out1.writeLine();
        MethodDefinition[] methods = def.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            MethodCodes mc = null;
            int j = 0;
            while (j < mds.length) {
                if (mds[j].method == methods[i2]) {
                    mc = mds[j];
                    break;
                }
                ++j;
            }
            if (mc != null) {
                mc.buildSource(out1);
            } else {
                out1.writeString(methods[i2].getDeclareString());
                if (methods[i2].getCodes() == null) {
                    out1.writeLine(";");
                } else {
                    out1.writeLine();
                    out1.writeLine("{");
                    out1.writeLine("    /*no source*/");
                    out1.writeLine("}");
                }
            }
            ++i2;
        }
        out.writeLine("}");
        out.writeLine();
    }
}

