/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso;

import com.kingdee.eas.cp.eip.sso.AuthPatternParseException;
import com.kingdee.eas.cp.eip.sso.EasAuthPattern;
import com.kingdee.eas.cp.eip.sso.IEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import com.kingdee.eas.cp.eip.sso.xml.NodeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nanoxml.XMLParseException;

public class EasMultiAuthManager {
    public static final String EAS_AUTH_SCOPE_APPLICATION = "application";
    public static final String EAS_AUTH_SCOPE_SESSION = "session";
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";
    public static final String KINGDEE_CLOUD_AUTH_PATTERN = "KingdeeCloud";
    public static final String EAS_BASETRDLTPATOKEN_AUTH_PATTERN = "BaseTrdLtpaToken";
    private static final String AUTH_CONFIG = "auth.config";
    private static final String PORTAL_CONFIG = "portal.config";
    private static final String AUTH_CONFIG_NAME = "easAuthPatterns.xml";
    private static final HashMap authHandlerMap = new HashMap();
    private static final List authPatternList = new ArrayList();
    private static final HashMap authPatternMap = new HashMap();
    private static String defaultAuthPattern = "BaseDB";
    private static String scope = "application";

    private EasMultiAuthManager() {
    }

    private static void loadConfig() throws AuthPatternParseException {
        File file;
        String portalConfig;
        String configFile = System.getProperty(AUTH_CONFIG);
        if ((configFile == null || "".equals(configFile)) && (portalConfig = System.getProperty(PORTAL_CONFIG)) != null && !"".equals(portalConfig)) {
            File portalConfigFile = new File(portalConfig);
            configFile = portalConfigFile.getParentFile().getAbsolutePath() + "/" + AUTH_CONFIG_NAME;
        }
        if (!(file = new File(configFile)).exists()) {
            throw new AuthPatternParseException("Eas auth pattern config file is not exist.config file path =[" + configFile + "]");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            EasMultiAuthManager.innerLoad(bis);
        }
        catch (IOException ioe) {
            throw new AuthPatternParseException(ioe);
        }
        catch (XMLParseException pe) {
            throw new AuthPatternParseException(pe);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void builtInLtpa() {
        EasAuthPattern authPatternDesc = new EasAuthPattern();
        authPatternDesc.setName(EAS_BASETRDLTPATOKEN_AUTH_PATTERN);
        authPatternDesc.setAuthHandler("com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenAuthHandler");
        authPatternDesc.setDisplayName(EAS_BASETRDLTPATOKEN_AUTH_PATTERN);
        authPatternDesc.setDescription("System built-in auth patterns,EAS BaseTrdLtpaToken auth.");
        authPatternList.add(authPatternDesc);
        authPatternMap.put(authPatternDesc.getName(), authPatternDesc);
    }

    private static void builtIn() {
        EasAuthPattern authPatternDesc = new EasAuthPattern();
        authPatternDesc.setName(EAS_DEFAULT_AUTH_PATTERN);
        authPatternDesc.setAuthHandler("com.kingdee.eas.cp.eip.sso.EasDefaultAuthHandler");
        authPatternDesc.setDisplayName(EAS_DEFAULT_AUTH_PATTERN);
        authPatternDesc.setDescription("System built-in auth patterns,EAS default database auth.");
        EasAuthPattern authPatternDesc1 = new EasAuthPattern();
        authPatternDesc1.setName(KINGDEE_CLOUD_AUTH_PATTERN);
        authPatternDesc1.setAuthHandler("com.kingdee.eas.cp.eip.sso.kdCloud.KingdeeCloudAuthHandler");
        authPatternDesc1.setDisplayName(KINGDEE_CLOUD_AUTH_PATTERN);
        authPatternDesc1.setDescription("Kingdee Cloud auth patterns");
        authPatternList.add(authPatternDesc);
        authPatternList.add(authPatternDesc1);
        authPatternMap.put(authPatternDesc.getName(), authPatternDesc);
        authPatternMap.put(authPatternDesc1.getName(), authPatternDesc1);
        EasMultiAuthManager.builtInLtpa();
        defaultAuthPattern = EAS_DEFAULT_AUTH_PATTERN;
        scope = EAS_AUTH_SCOPE_APPLICATION;
        System.out.println("[EAS Multi Auth]load system built-in auth patterns.");
    }

    private static void innerLoad(BufferedInputStream bis) throws AuthPatternParseException {
        String rootNodeName = "authPatterns";
        String authPatternNodeName = "authPattern";
        String defaultAuthNodeName = "default";
        String scopeNodeName = "scope";
        INode root = null;
        try {
            root = NodeFactory.build(bis);
        }
        catch (IOException e) {
            throw new AuthPatternParseException("Invalidate auth pattern config file.", e);
        }
        if (root == null || !rootNodeName.equals(root.getNodeName())) {
            throw new AuthPatternParseException("Invalidate auth pattern config file.root=null");
        }
        String childNodeName = "";
        boolean existDefaultAuth = false;
        boolean existAuthPattern = false;
        boolean existAuthScope = false;
        EasAuthPattern easAuthPattern = null;
        int authPatternMapIdx = 0;
        for (INode childNode = root.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            childNodeName = childNode.getNodeName();
            if (authPatternNodeName.equalsIgnoreCase(childNodeName)) {
                easAuthPattern = EasMultiAuthManager.buildAuthPattern(childNode);
                authPatternList.add(authPatternMapIdx++, easAuthPattern);
                authPatternMap.put(easAuthPattern.getName(), easAuthPattern);
                existAuthPattern = true;
                continue;
            }
            if (defaultAuthNodeName.equalsIgnoreCase(childNodeName)) {
                existDefaultAuth = true;
                defaultAuthPattern = childNode.getNodeValue();
                continue;
            }
            if (!scopeNodeName.equalsIgnoreCase(childNodeName)) continue;
            existAuthScope = true;
            scope = childNode.getNodeValue();
            if (EasMultiAuthManager.validateScope(scope)) continue;
            throw new AuthPatternParseException("Invalid auth scope,scope value is only application or session.scope=[" + scope + "]");
        }
        if (!EasMultiAuthManager.validateDefaultAuthPattern(defaultAuthPattern)) {
            throw new AuthPatternParseException("Invalid default auth pattern,all auth patterns don't contain this pattern,default=[" + defaultAuthPattern + "]");
        }
        if (!(existAuthPattern || existDefaultAuth || existAuthScope)) {
            throw new AuthPatternParseException("Invalid auth pattern config file.must exist 3 child elements:authPattern/default/scope.");
        }
    }

    public static boolean validateDefaultAuthPattern(String authPattern) {
        boolean result = false;
        if (authPatternMap.containsKey(authPattern)) {
            result = true;
        }
        return result;
    }

    private static boolean validateScope(String scope) {
        boolean result = false;
        if (EAS_AUTH_SCOPE_APPLICATION.equalsIgnoreCase(scope) || EAS_AUTH_SCOPE_SESSION.equalsIgnoreCase(scope)) {
            result = true;
        }
        return result;
    }

    private static EasAuthPattern buildAuthPattern(INode authPatternNode) throws AuthPatternParseException {
        String authPatternName = "name";
        String authPatternDisplayName = "displayName";
        String authPatternDesc = "description";
        String authHandler = "authHandler";
        boolean noexistName = true;
        boolean noexistHandler = true;
        String childNodeName = "";
        EasAuthPattern easAuthPattern = new EasAuthPattern();
        for (INode childNode = authPatternNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            childNodeName = childNode.getNodeName();
            if (authPatternName.equalsIgnoreCase(childNodeName)) {
                easAuthPattern.setName(childNode.getNodeValue());
                noexistName = false;
                continue;
            }
            if (authPatternDisplayName.equalsIgnoreCase(childNodeName)) {
                easAuthPattern.setDisplayName(childNode.getNodeValue());
                continue;
            }
            if (authPatternDesc.equalsIgnoreCase(childNodeName)) {
                easAuthPattern.setDescription(childNode.getNodeValue());
                continue;
            }
            if (!authHandler.equalsIgnoreCase(childNodeName)) continue;
            easAuthPattern.setAuthHandler(childNode.getNodeValue());
            noexistHandler = false;
        }
        if (noexistName || noexistHandler) {
            throw new AuthPatternParseException("invalid authPattern element.must exist two elements at least,name and authHandler element.");
        }
        return easAuthPattern;
    }

    public static List getAllAuthPatterns() {
        return authPatternList;
    }

    public static EasAuthPattern getDefaultAuthPattern() {
        return (EasAuthPattern)authPatternMap.get(defaultAuthPattern);
    }

    public static IEasAuthHandler getAuthHandler(String authPatternName) {
        if (!authHandlerMap.containsKey(authPatternName)) {
            authPatternName = EasMultiAuthManager.getDefaultAuthPattern().getName();
        }
        return (IEasAuthHandler)authHandlerMap.get(authPatternName);
    }

    public static synchronized void unRegisterAuthHandler(String authPattern) {
        authHandlerMap.remove(authPattern);
    }

    public static synchronized void registerAuthHandler(String authPattern, IEasAuthHandler handler) {
        authHandlerMap.put(authPattern, handler);
    }

    private static void loadAuthHandlers() {
        ArrayList tmpList = new ArrayList(authPatternList);
        Iterator ite = tmpList.iterator();
        EasAuthPattern authPattern = null;
        while (ite.hasNext()) {
            authPattern = (EasAuthPattern)ite.next();
            try {
                Class<?> authPatternClass = Class.forName(authPattern.getAuthHandler());
                IEasAuthHandler authHandler = (IEasAuthHandler)authPatternClass.newInstance();
                EasMultiAuthManager.registerAuthHandler(authPattern.getName(), authHandler);
            }
            catch (ClassNotFoundException e) {
                EasMultiAuthManager.removeAuthPattern(authPattern);
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                EasMultiAuthManager.removeAuthPattern(authPattern);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                EasMultiAuthManager.removeAuthPattern(authPattern);
                e.printStackTrace();
            }
        }
    }

    private static void removeAuthPattern(EasAuthPattern authPattern) {
        authPatternList.remove(authPattern);
        authPatternMap.remove(authPattern);
    }

    public static void init() {
        EasMultiAuthManager.builtIn();
        try {
            EasMultiAuthManager.loadConfig();
        }
        catch (AuthPatternParseException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        EasMultiAuthManager.loadAuthHandlers();
    }

    public static void destory() {
        EasMultiAuthManager.clearAuthHandlers();
        EasMultiAuthManager.clearAuthPatterns();
    }

    private static void clearAuthPatterns() {
        authPatternMap.clear();
        authPatternList.clear();
    }

    private static void clearAuthHandlers() {
        authHandlerMap.clear();
    }

    public static boolean isApplicationScope() {
        return EAS_AUTH_SCOPE_APPLICATION.equalsIgnoreCase(scope);
    }

    public static boolean isSessionScope() {
        return EAS_AUTH_SCOPE_SESSION.equalsIgnoreCase(scope);
    }

    public static void main(String[] args) {
        EasMultiAuthManager.destory();
        System.out.println("test");
    }

    static {
        EasMultiAuthManager.init();
    }
}

