/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.ldapadapter.OrgInfoFetchImpl;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.EntryStateEnum;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapFactory;
import com.kingdee.eas.cp.eip.sso.ILdapEntry;
import com.kingdee.eas.cp.eip.sso.ILdapEntryFacade;
import com.kingdee.eas.cp.eip.sso.ILdapMapping;
import com.kingdee.eas.cp.eip.sso.LdapEntryCollection;
import com.kingdee.eas.cp.eip.sso.LdapEntryFacadeFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryInfo;
import com.kingdee.eas.cp.eip.sso.LdapException;
import com.kingdee.eas.cp.eip.sso.LdapMappingCollection;
import com.kingdee.eas.cp.eip.sso.LdapMappingFactory;
import com.kingdee.eas.cp.eip.sso.LdapMappingInfo;
import com.kingdee.eas.cp.eip.sso.app.AbstractLdapEntryFacadeControllerBean;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapProject;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapValueMap;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapEasInfo;
import com.kingdee.eas.cp.eip.sso.user.LdapUtil;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.util.EasToLdapType;
import com.kingdee.eas.cp.eip.sso.util.InstantiationClassUtil;
import com.kingdee.eas.cp.eip.sso.util.LdapConfigManagerUtil;
import com.kingdee.eas.cp.eip.sso.util.LdapIDDNItem;
import com.kingdee.eas.cp.eip.sso.util.LdapImportUtil;
import com.kingdee.eas.cp.eip.sso.util.LongNumberUtil;
import com.kingdee.eas.cp.eip.sso.util.TypeConfigManagerUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class LdapEntryFacadeControllerBean
extends AbstractLdapEntryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.sso.app.LdapEntryFacadeControllerBean");
    private LdapUtil ldapUtil = null;
    private LdapEntryInfo info = null;
    private LdapEasInfo typeValueMap = null;
    private static String baseDN = null;

    private void addEntry(Context ctx, String addType, HashMap map, boolean isImport) throws BOSException, EASBizException {
        try {
            this.ldapUtil.initAddEntry(ctx, addType, map, this.info);
            this.initDirContext(ctx, addType);
            this.ldapUtil.ldapAddEntry(this.info);
        }
        catch (NamingException e) {
            logger.info((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (UserSyncConfigParseException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
            logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01" + e));
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
            logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01" + e));
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!isImport) {
                LdapImportUtil.initException(ctx, this.info);
            }
            this.ldapUtil.close();
        }
    }

    private void updEntry(Context ctx, String addType, HashMap map, String dn, boolean isImport) throws BOSException, EASBizException {
        try {
            this.ldapUtil.initUpdEntry(ctx, dn, addType, map, this.info);
            this.initDirContext(ctx, addType);
            this.ldapUtil.ldapUpdEntry(this.info);
        }
        catch (NamingException e) {
            logger.info((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (UserSyncConfigParseException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
            logger.info((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
            logger.info((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!isImport) {
                LdapImportUtil.initException(ctx, this.info);
            }
            this.ldapUtil.close();
        }
    }

    private void initDirContext(Context ctx, String nodeName) throws BOSException, EASBizException {
        try {
            String ldapResxName = null;
            Map.Entry entry2 = null;
            LdapControlInfo item = null;
            for (Map.Entry entry2 : LdapConfigManagerUtil.init().getReadXMLStartRootNode().entrySet()) {
                if (!entry2.getKey().toString().equals(nodeName)) continue;
                item = (LdapControlInfo)entry2.getValue();
                ldapResxName = item.getAdduction();
                break;
            }
            HashMap ldapResxMap = (HashMap)UserSyncConfigManager.getUserSyncResourcesMap().clone();
            UserResource ldapResx = (UserResource)ldapResxMap.get(ldapResxName);
            String resxType = ldapResx.getResourceType();
            if (this.ldapUtil == null) {
                System.err.println("[Eas user sync]no user resource connect util class for " + resxType + ".");
                return;
            }
            this.ldapUtil.connect(ldapResxName);
        }
        catch (UserSyncConfigParseException e) {
            this.ldapUtil.close();
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
            throw new LdapException(LdapException.NOPARSE);
        }
        catch (IOException e) {
            this.ldapUtil.close();
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
            throw new LdapException(LdapException.NOFILE);
        }
        catch (NamingException e) {
            this.ldapUtil.close();
            LdapImportUtil.initException(this.info, "ldap Server\u8fde\u63a5\u9519\u8bef\uff01");
            throw new LdapException(LdapException.NOCONNECTION);
        }
    }

    private void initLdapControl() {
        if (this.ldapUtil == null) {
            this.ldapUtil = new LdapUtil();
        }
        if (this.info == null) {
            this.info = new LdapEntryInfo();
        }
        this.info.setState(STConverter.tc2sc((String)EntryStateEnum.SSO_DEFAULT.toString()), LocaleUtils.getLocale((String)"L2"));
        this.info.setState(STConverter.sc2tc((String)EntryStateEnum.SSO_DEFAULT.toString()), LocaleUtils.getLocale((String)"L3"));
        this.info.setSyncTime(0);
    }

    private boolean _ldapImportSwitch(Context ctx, String type) throws BOSException, EASBizException {
        String ldapSwitch = null;
        ldapSwitch = null;
        Map.Entry entry2 = null;
        LdapControlInfo item = null;
        try {
            HashMap map = (HashMap)LdapConfigManagerUtil.init().getReadXMLStartRootNode();
            for (Map.Entry entry2 : map.entrySet()) {
                if (!entry2.getKey().toString().equals(type)) continue;
                item = (LdapControlInfo)entry2.getValue();
                ldapSwitch = item.getImportSwitch();
                break;
            }
        }
        catch (UserSyncConfigParseException e) {
            logger.info((Object)("ldap\u6761\u76ee \u914d\u7f6e\u6587\u4ef6\u89e3\u6790 \u5f02\u5e38 " + e));
            return false;
        }
        catch (IOException e) {
            logger.info((Object)("ldap\u6761\u76ee \u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6 \u5f02\u5e38 " + e));
            return false;
        }
        if (ldapSwitch == null) {
            return false;
        }
        return ldapSwitch.toString().equalsIgnoreCase("true");
    }

    @Override
    protected void _delLdapEntry(Context ctx, List list) throws BOSException {
        try {
            ILdapEntry il = LdapEntryFactory.getLocalInstance(ctx);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                il.delete("where id = '" + it.next().toString() + "'");
            }
        }
        catch (EASBizException e) {
            logger.info((Object)("LdapEntry delLdapEntryy exception " + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.info((Object)("LdapEntry delLdapEntry exception " + (Object)((Object)e)));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapDelEntry(Context ctx, String addType, String id, boolean isImport) throws BOSException, EASBizException {
        try {
            ILdapMapping ildap;
            this.initLdapControl();
            LdapMappingInfo ldapMapping = null;
            if (this.typeValueMap == null) {
                this.typeValueMap = TypeConfigManagerUtil.initLdapConfigManager().getReadXML(BOSUuid.read((String)id).getType().toString());
            }
            if (this.typeValueMap == null) {
                return;
            }
            if (addType == null) {
                addType = this.typeValueMap.getKeyName();
            } else if (addType.length() == 0) {
                addType = this.typeValueMap.getKeyName();
            }
            if (addType == null) {
                return;
            }
            if (addType.length() == 0) {
                return;
            }
            LdapImportUtil.initType(this.info, addType);
            LdapImportUtil.initControl(this.info, "del");
            LdapMappingCollection ldapMappingCol = null;
            if (this._ldapImportSwitch(ctx, addType) && (ldapMappingCol = (ildap = LdapMappingFactory.getLocalInstance(ctx)).getLdapMappingCollection("select * where Easid = '" + id + "'")) != null && ldapMappingCol.size() != 0) {
                Iterator it = ldapMappingCol.iterator();
                while (it.hasNext()) {
                    ldapMapping = (LdapMappingInfo)it.next();
                    this.info.setName(ldapMapping.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                    this.info.setNumber(id);
                    LdapImportUtil.initDescription(this.info, ldapMapping.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                    this.initDirContext(ctx, addType);
                    this.ldapUtil.ldapDelEntry(this.info, ldapMapping.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                    EasToLdapType.initEasToLdapType().controlDel(ctx, ldapMapping.getEasid(), addType);
                }
                ildap.delete("where Easid = '" + id + "' or Ldapdn = '" + ldapMapping.getLdapdn(LdapImportUtil.getLanguageTypeLocale()) + "'");
            }
        }
        catch (NamingException e) {
            logger.info((Object)("\u5220\u9664ldap\u6761\u76ee \u5f02\u5e38 " + e));
            return;
        }
        catch (UserSyncConfigParseException e) {
            logger.info((Object)("\u5220\u9664ldap\u6761\u76ee \u914d\u7f6e\u6587\u4ef6\u89e3\u6790 \u5f02\u5e38 " + e));
            return;
        }
        catch (IOException e) {
            logger.info((Object)("\u5220\u9664ldap\u6761\u76ee \u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6 \u5f02\u5e38 " + e));
            return;
        }
        finally {
            if (!isImport) {
                LdapImportUtil.initException(ctx, this.info);
            }
            this.ldapUtil.close();
        }
    }

    @Override
    protected void _ldapDelEntry(Context ctx, String addType, String id) throws BOSException, EASBizException {
        this.ldapDelEntry(ctx, addType, id, false);
    }

    @Override
    protected HashMap _importLdap(Context ctx, List list) throws BOSException, EASBizException {
        int successnum = 0;
        int lostnum = 0;
        try {
            ILdapEntry iLE = LdapEntryFactory.getLocalInstance(ctx);
            Iterator it = list.iterator();
            ArrayList<String> successList = new ArrayList<String>();
            ArrayList<String> lostList = new ArrayList<String>();
            int importNum = 0;
            while (it.hasNext()) {
                LdapEntryInfo ldapEntryInfo = iLE.getLdapEntryInfo((IObjectPK)new ObjectUuidPK(it.next().toString()));
                if (this.importLdapEntry(ctx, ldapEntryInfo)) {
                    ++successnum;
                    successList.add(ldapEntryInfo.getId().toString());
                    continue;
                }
                ++lostnum;
                importNum = ldapEntryInfo.getSyncTime() + 1;
                ldapEntryInfo.setSyncTime(importNum);
                iLE.update((IObjectPK)new ObjectUuidPK(ldapEntryInfo.getId().toString()), (CoreBaseInfo)ldapEntryInfo);
                if (importNum < 3) continue;
                lostList.add(ldapEntryInfo.getId().toString());
            }
            if (lostList.size() != 0) {
                iLE.entryAlignmentActive(lostList, EntryStateEnum.SSO_LOST.toString());
            }
            if (successList.size() != 0) {
                iLE.entryAlignmentActive(successList, EntryStateEnum.SSO_SUCCESS.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)("importLdap ldap entry exception " + (Object)((Object)e)));
        }
        catch (UuidException e) {
            logger.info((Object)("importLdap ldap entry exception " + (Object)((Object)e)));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SUCCESS", String.valueOf(successnum));
        map.put("LOST", String.valueOf(lostnum));
        return map;
    }

    @Override
    protected HashMap _importLdapAll(Context ctx) throws BOSException {
        this.initLdapControl();
        HashMap map = new HashMap();
        HashMap sumMap = new HashMap();
        try {
            map = this._importEntryType(ctx, "user");
            this.sumNumber(map, sumMap);
            map = this._importEntryType(ctx, "orgunit");
            this.sumNumber(map, sumMap);
            map = this._importEntryType(ctx, "principalship");
            this.sumNumber(map, sumMap);
            map = this._importEntryType(ctx, "groups");
            this.sumNumber(map, sumMap);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return sumMap;
    }

    private void sumNumber(HashMap map, HashMap sumMap) {
        int successnum = 0;
        int lostnum = 0;
        int sumSuccessnum = 0;
        int sumLostnum = 0;
        Object ob = null;
        if (map != null) {
            ob = map.get("SUCCESS");
            if (ob != null) {
                successnum = Integer.parseInt(ob.toString());
            }
            if ((ob = map.get("LOST")) != null) {
                lostnum = Integer.parseInt(ob.toString());
            }
            if (sumMap == null) {
                sumMap = new HashMap<String, String>();
            } else {
                ob = sumMap.get("SUCCESS");
                if (ob != null) {
                    sumSuccessnum = Integer.parseInt(ob.toString());
                }
                if ((ob = sumMap.get("LOST")) != null) {
                    sumLostnum = Integer.parseInt(ob.toString());
                }
            }
            sumMap.put("SUCCESS", String.valueOf(sumSuccessnum += successnum));
            sumMap.put("LOST", String.valueOf(sumLostnum += lostnum));
        }
    }

    private void orgunitDel(Context ctx, ArrayList ay) {
        this.initLdapControl();
        try {
            this.initDirContext(ctx, "orgunit");
        }
        catch (EASBizException e1) {
            logger.info((Object)e1);
        }
        catch (BOSException e1) {
            logger.info((Object)e1);
        }
        LdapIDDNItem item = null;
        for (int i = ay.size() - 1; i >= 0; --i) {
            item = (LdapIDDNItem)ay.get(i);
            try {
                this.ldapUtil.ldapDelEntry(this.info, item.getDn());
                continue;
            }
            catch (NamingException e) {
                logger.info((Object)e);
                continue;
            }
            catch (UserSyncConfigParseException e) {
                logger.info((Object)e);
                continue;
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    private void initOrgUnit(Context ctx, String strType, LdapEntryInfo ldapEntryInfo, String tempDn, boolean isUp) {
        boolean signTemp = true;
        this.initLdapControl();
        try {
            this.initDirContext(ctx, "orgunit");
        }
        catch (EASBizException e1) {
            logger.info((Object)e1);
        }
        catch (BOSException e1) {
            logger.info((Object)e1);
        }
        this.ldapUtil.initOrgunitAtt();
        if (isUp) {
            this.ldapUtil.orgunitEntrySelect(ldapEntryInfo.getName(), tempDn);
        } else {
            this.ldapUtil.orgunitEntrySelect(ldapEntryInfo.getName(), ldapEntryInfo.getName());
        }
        ArrayList<LdapIDDNItem> ay = new ArrayList<LdapIDDNItem>();
        Date now = new Date();
        DateFormat d = DateFormat.getDateTimeInstance();
        HashMap<String, String> map = null;
        HashMap map1 = null;
        String nowTime = d.format(now);
        String rootRdn = null;
        LdapIDDNItem item2 = null;
        String tempStr = null;
        LdapMappingInfo mappingInfo = null;
        String rootKey = null;
        String tempKey = null;
        String ndn = null;
        LdapEasInfo easInfo = null;
        String tempNdn = null;
        int numberNum = 0;
        String tempYuan = "";
        String tempYuanDN = "";
        String tempGaiDN = "";
        while (this.ldapUtil.next()) {
            map = new HashMap<String, String>();
            map1 = new HashMap();
            Iterator itAtt = this.ldapUtil.getEntryAtt().iterator();
            item2 = new LdapIDDNItem();
            if (StringUtils.isEmpty((String)this.ldapUtil.getEntryDn())) {
                List list = LongNumberUtil.longNumber2List(ldapEntryInfo.getName());
                numberNum = list.size();
                for (int i = 0; i < numberNum; ++i) {
                    if (i == numberNum - 1) {
                        tempYuan = StringUtils.isEmpty((String)tempYuan) ? this.ldapUtil.getUserProperty(this.ldapUtil.getLdapKey()) + nowTime : tempYuan + "_" + this.ldapUtil.getUserProperty(this.ldapUtil.getLdapKey()) + nowTime;
                        if (StringUtils.isEmpty((String)tempYuanDN)) {
                            tempYuanDN = this.ldapUtil.getLdapKey() + "=" + this.ldapUtil.getUserProperty(this.ldapUtil.getLdapKey());
                            tempGaiDN = tempYuanDN + nowTime;
                            continue;
                        }
                        tempGaiDN = this.ldapUtil.getLdapKey() + "=" + this.ldapUtil.getUserProperty(this.ldapUtil.getLdapKey()) + nowTime + "," + tempYuanDN;
                        tempYuanDN = this.ldapUtil.getLdapKey() + "=" + this.ldapUtil.getUserProperty(this.ldapUtil.getLdapKey()) + "," + tempYuanDN;
                        continue;
                    }
                    tempYuan = StringUtils.isEmpty((String)tempYuan) ? list.get(i).toString() : tempYuan + "_" + list.get(i);
                    tempYuanDN = StringUtils.isEmpty((String)tempYuanDN) ? this.ldapUtil.getLdapKey() + "=" + list.get(i).toString() : this.ldapUtil.getLdapKey() + "=" + list.get(i) + "," + tempYuanDN;
                }
                map.put(this.ldapUtil.getEasKey(), tempYuan);
                map1.put(this.ldapUtil.getEasKey(), ldapEntryInfo.getName());
                rootRdn = tempYuanDN;
                rootKey = tempGaiDN;
                tempKey = ldapEntryInfo.getName();
                tempStr = rootRdn + "," + this.ldapUtil.getBaseDN();
                try {
                    mappingInfo = LdapMappingFactory.getLocalInstance(ctx).getLdapMappingInfo("select * where Ldapdn = '" + tempDn + "'");
                    item2.setId(mappingInfo.getEasid().toString());
                    item2.setDn(tempStr);
                    item2.setNdn(tempKey + "," + this.ldapUtil.getBaseDN());
                    ay.add(item2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                tempStr = this.ldapUtil.getEntryDn() + "," + rootRdn + "," + this.ldapUtil.getBaseDN();
                ndn = LongNumberUtil.dnToStr(this.ldapUtil.getEntryDn() + "," + this.ldapUtil.getLdapKey() + "=" + tempKey + "," + this.ldapUtil.getBaseDN(), this.ldapUtil.getLdapKey());
                map.put(this.ldapUtil.getEasKey(), LongNumberUtil.dnToStr(this.ldapUtil.getEntryDn() + "," + rootKey + "," + this.ldapUtil.getBaseDN(), this.ldapUtil.getLdapKey()));
                map1.put(this.ldapUtil.getEasKey(), LongNumberUtil.dnToStr(this.ldapUtil.getEntryDn() + "," + this.ldapUtil.getLdapKey() + "=" + tempKey + "," + this.ldapUtil.getBaseDN(), this.ldapUtil.getLdapKey()));
                try {
                    mappingInfo = LdapMappingFactory.getLocalInstance(ctx).getLdapMappingInfo("select * where Ldapdn = '" + tempStr + "'");
                    item2.setId(mappingInfo.getEasid().toString());
                    item2.setDn(tempStr);
                    item2.setNdn(ndn);
                    ay.add(item2);
                }
                catch (Exception list) {
                    // empty catch block
                }
            }
            while (itAtt.hasNext()) {
                easInfo = (LdapEasInfo)itAtt.next();
                if (easInfo.getKeyName().equals(this.ldapUtil.getLdapKey())) continue;
                map.put(easInfo.getKeyValue(), this.ldapUtil.getUserProperty(easInfo.getKeyName()));
                map1.put(easInfo.getKeyValue(), this.ldapUtil.getUserProperty(easInfo.getKeyName()));
            }
            try {
                if (signTemp) {
                    signTemp = false;
                    OrgInfoFetchImpl ofi = new OrgInfoFetchImpl();
                    map1.put("FDisplayName", map.get("FDisplayName").toString().substring(0, map.get("FDisplayName").toString().length() - nowTime.length()));
                    LdapMappingInfo lminfo = LdapMappingFactory.getLocalInstance(ctx).getLdapMappingInfo("select * where ldapdn='" + LdapImportUtil.initDN("orgunit", map1, false) + "'");
                    map1 = (HashMap)ofi.getContentInfoMap(ctx, lminfo.getEasid());
                }
                DbUtil.execute((Context)ctx, (String)("delete from t_sso_ldapmapping where FEasid = '" + item2.getId() + "'"));
                if (isUp) {
                    tempNdn = LdapImportUtil.initDN(strType, map1, false);
                    mappingInfo.setLdapdn(STConverter.tc2sc((String)tempNdn), LocaleUtils.getLocale((String)"L2"));
                    mappingInfo.setLdapdn(STConverter.sc2tc((String)tempNdn), LocaleUtils.getLocale((String)"L3"));
                    LdapMappingFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)mappingInfo);
                    this.addEntry(ctx, strType, map1, true);
                }
                this.addEntry(ctx, strType, map, true);
            }
            catch (EASBizException e) {
                logger.info((Object)e);
            }
            catch (BOSException e) {
                logger.info((Object)e);
            }
            catch (UserSyncConfigParseException e) {
                logger.info((Object)e);
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
        for (LdapIDDNItem item2 : ay) {
        }
        this.orgunitDel(ctx, ay);
    }

    private boolean importLdapEntry(Context ctx, LdapEntryInfo ldapEntryInfo) {
        boolean isRe = false;
        String typeControl = ldapEntryInfo.getControl();
        String type = ldapEntryInfo.getType();
        String strType = null;
        try {
            strType = type.substring(type.indexOf("(") + 1, type.indexOf(")"));
            String tempDn = ldapEntryInfo.getDescription(LdapImportUtil.getLanguageTypeLocale());
            if (typeControl.equals("ldap\u6dfb\u52a0Entry") || typeControl.equals("ldap\u4fee\u6539Entry")) {
                if (strType.equals("orgunit") && typeControl.equals("ldap\u4fee\u6539Entry") && !ldapEntryInfo.getName().equals(tempDn.substring(tempDn.indexOf("=") + 1, tempDn.indexOf(",")))) {
                    this.initOrgUnit(ctx, strType, ldapEntryInfo, tempDn, true);
                } else {
                    this.ldapHandleEntry(ctx, strType, ldapEntryInfo.getNumber(), ldapEntryInfo.getPwd(), true);
                }
            } else if (typeControl.equals("ldap\u5220\u9664Entry")) {
                if (strType.equals("orgunit")) {
                    this.initOrgUnit(ctx, strType, ldapEntryInfo, tempDn, true);
                } else {
                    String id = ldapEntryInfo.getNumber();
                    String strDn = ldapEntryInfo.getDescription(LdapImportUtil.getLanguageTypeLocale());
                    LdapImportUtil.initType(this.info, strType);
                    LdapImportUtil.initControl(this.info, "del");
                    this.info.setName(ldapEntryInfo.getName());
                    this.info.setNumber(ldapEntryInfo.getNumber());
                    LdapMappingCollection ldapMappingCol = null;
                    if (this._ldapImportSwitch(ctx, strType)) {
                        ILdapMapping ildap = LdapMappingFactory.getLocalInstance(ctx);
                        LdapImportUtil.initDescription(this.info, strDn);
                        ldapMappingCol = ildap.getLdapMappingCollection("select * where Easid = '" + id + "' or Ldapdn = '" + strDn + "'");
                        if (ldapMappingCol.size() != 0) {
                            this.initDirContext(ctx, strType);
                            this.ldapUtil.ldapDelEntry(this.info, strDn);
                            ildap.delete("where Easid = '" + id + "' or Ldapdn = '" + strDn + "'");
                        }
                        EasToLdapType.initEasToLdapType().controlDel(ctx, id, strType);
                    }
                }
            }
            isRe = true;
        }
        catch (EASBizException e) {
            isRe = false;
            logger.info((Object)("importLdap ldap entry exception " + (Object)((Object)e)));
        }
        catch (BOSException e) {
            isRe = false;
            logger.info((Object)("importLdap ldap entry exception " + (Object)((Object)e)));
        }
        catch (NamingException e) {
            isRe = false;
            logger.info((Object)"ldap Server\u8fde\u63a5\u9519\u8bef\uff01");
        }
        catch (UserSyncConfigParseException e) {
            isRe = false;
            logger.info((Object)"ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
        }
        catch (IOException e) {
            isRe = false;
            logger.info((Object)"ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
        }
        return isRe;
    }

    @Override
    protected HashMap _readLdapEntryMap(Context ctx) throws BOSException, EASBizException {
        HashMap map = null;
        try {
            map = (HashMap)LdapConfigManagerUtil.init().getReadXML();
        }
        catch (UserSyncConfigParseException e) {
            logger.info((Object)("ldap\u5bfc\u5165\u914d\u7f6e\u4fe1\u606fxml\u7ba1\u7406 " + e));
        }
        catch (IOException e) {
            logger.info((Object)("ldap\u5bfc\u5165\u914d\u7f6e\u4fe1\u606fxml\u7ba1\u7406 " + e));
        }
        return map;
    }

    @Override
    protected void _writeLdapEntryMap(Context ctx, HashMap map) throws BOSException, EASBizException {
        try {
            LdapConfigManagerUtil.init().write(map);
        }
        catch (IOException e) {
            logger.info((Object)("\u5199\u5165ldap\u914d\u7f6e\u6587\u4ef6 \u5f02\u5e38 " + e));
            return;
        }
    }

    private void ldapHandleEntry(Context ctx, String addType, String id, String pwd, boolean isImport) throws BOSException, EASBizException {
        block34: {
            this.initLdapControl();
            try {
                if (this.typeValueMap == null) {
                    this.typeValueMap = TypeConfigManagerUtil.initLdapConfigManager().getReadXML(BOSUuid.read((String)id).getType().toString());
                    if (this.typeValueMap == null) {
                        return;
                    }
                }
                if (StringUtils.isEmpty((String)addType) && StringUtils.isEmpty((String)(addType = this.typeValueMap.getKeyName()))) {
                    return;
                }
                if (!this._ldapImportSwitch(ctx, addType)) break block34;
                boolean isHasEasId = true;
                boolean isHasLdapDN = true;
                LdapMappingInfo ldapMappingInfo = null;
                ILdapMapping ildap = LdapMappingFactory.getLocalInstance(ctx);
                try {
                    ldapMappingInfo = ildap.getLdapMappingInfo("select * where Easid = '" + id + "'");
                }
                catch (EASBizException e) {
                    isHasEasId = false;
                }
                catch (BOSException e) {
                    isHasEasId = false;
                }
                HashMap map = (HashMap)((ILdapValueMap)Class.forName(this.typeValueMap.getKeyValue()).newInstance()).getContentInfoMap(ctx, id);
                if (map == null || map.isEmpty()) {
                    return;
                }
                LdapImportUtil.initType(this.info, addType);
                if (addType.equals("orgunit")) {
                    this.info.setName(LdapImportUtil.getOURelativelyValue(addType, map).toString());
                } else {
                    this.info.setName(LdapImportUtil.getEasNumber(LdapImportUtil.getRelativelyValue(addType, map).toString()));
                }
                this.info.setNumber(id);
                if (pwd != null) {
                    this.info.setPwd(PasswordUtils.encodePassword(addType, pwd));
                } else {
                    this.info.setPwd(PasswordUtils.encodePassword(addType, ""));
                }
                String strDn = LdapImportUtil.initDN(addType, map, false);
                if (StringUtils.isEmpty((String)strDn)) {
                    return;
                }
                try {
                    ldapMappingInfo = ildap.getLdapMappingInfo("select * where Ldapdn = '" + strDn.toLowerCase() + "'");
                }
                catch (EASBizException e) {
                    isHasLdapDN = false;
                }
                catch (BOSException e) {
                    isHasLdapDN = false;
                }
                if (!StringUtils.isEmpty((String)pwd)) {
                    map.put(LdapImportUtil.getPwdKey(addType), pwd);
                }
                if (isHasEasId) {
                    if (isHasLdapDN) {
                        if (ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()).equals(strDn)) {
                            LdapImportUtil.initDescription(this.info, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                            this.updEntry(ctx, addType, map, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()), isImport);
                            EasToLdapType.initEasToLdapType().controlUpd(ctx, id, strDn, addType);
                        }
                    } else {
                        if (ldapMappingInfo.getLdapdn() == null) {
                            if (ldapMappingInfo.getLdapdn().length() == 0) {
                                LdapImportUtil.initDescription(this.info, strDn);
                                this.addEntry(ctx, addType, map, isImport);
                                EasToLdapType.initEasToLdapType().controlAdd(ctx, id, strDn, addType);
                            } else {
                                LdapImportUtil.initDescription(this.info, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                                this.updEntry(ctx, addType, map, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()), isImport);
                                EasToLdapType.initEasToLdapType().controlUpd(ctx, id, strDn, addType);
                            }
                        } else {
                            LdapImportUtil.initDescription(this.info, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                            this.updEntry(ctx, addType, map, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()), isImport);
                            EasToLdapType.initEasToLdapType().controlUpd(ctx, id, strDn, addType);
                        }
                        ldapMappingInfo.setLdapdn(STConverter.tc2sc((String)strDn).toLowerCase(), LocaleUtils.getLocale((String)"L2"));
                        ldapMappingInfo.setLdapdn(STConverter.sc2tc((String)strDn).toLowerCase(), LocaleUtils.getLocale((String)"L3"));
                    }
                } else if (isHasLdapDN) {
                    if (ldapMappingInfo.getEasid() == null && ldapMappingInfo.getEasid().length() == 0) {
                        ldapMappingInfo.setEasid(id);
                        LdapImportUtil.initDescription(this.info, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()));
                        this.updEntry(ctx, addType, map, ldapMappingInfo.getLdapdn(LdapImportUtil.getLanguageTypeLocale()), isImport);
                        EasToLdapType.initEasToLdapType().controlUpd(ctx, id, strDn, addType);
                    }
                } else {
                    ldapMappingInfo = new LdapMappingInfo();
                    ldapMappingInfo.setEasid(id);
                    ldapMappingInfo.setLdapdn(STConverter.tc2sc((String)strDn).toLowerCase(), LocaleUtils.getLocale((String)"L2"));
                    ldapMappingInfo.setLdapdn(STConverter.sc2tc((String)strDn).toLowerCase(), LocaleUtils.getLocale((String)"L3"));
                    LdapImportUtil.initDescription(this.info, strDn);
                    this.addEntry(ctx, addType, map, isImport);
                    EasToLdapType.initEasToLdapType().controlAdd(ctx, id, strDn, addType);
                }
                ildap.submit((CoreBaseInfo)ldapMappingInfo);
            }
            catch (UserSyncConfigParseException e) {
                LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
                logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01 " + e));
                return;
            }
            catch (IOException e) {
                LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
                logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01 " + e));
                return;
            }
            catch (InstantiationException e) {
                logger.info((Object)("ldap import InstantiationException " + e));
                return;
            }
            catch (IllegalAccessException e) {
                logger.info((Object)("ldap import IllegalAccessException " + e));
                return;
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)("ldap import classnotfound " + e));
                return;
            }
        }
    }

    @Override
    protected void _ldapHandleEntry(Context ctx, String addType, String id, String pwd) throws BOSException, EASBizException {
        this.ldapHandleEntry(ctx, addType, id, pwd, false);
    }

    @Override
    protected void _ldapHandleEntry(Context ctx, String[] id, String pwd) throws BOSException, EASBizException {
        this.initLdapControl();
        try {
            for (int i = 0; i < id.length; ++i) {
                this.typeValueMap = TypeConfigManagerUtil.initLdapConfigManager().getReadXML(BOSUuid.read((String)id[i]).getType().toString());
                if (this.typeValueMap == null) {
                    return;
                }
                this.ldapHandleEntry(ctx, this.typeValueMap.getKeyName(), id[i], pwd, false);
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (UuidException uuidException) {
        }
        catch (BOSException bOSException) {
        }
        catch (UserSyncConfigParseException userSyncConfigParseException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void _ldapDelEntry(Context ctx, String[] id) throws BOSException, EASBizException {
        this.initLdapControl();
        try {
            for (int i = 0; i < id.length; ++i) {
                this.typeValueMap = TypeConfigManagerUtil.initLdapConfigManager().getReadXML(BOSUuid.read((String)id[i]).getType().toString());
                if (this.typeValueMap == null) {
                    return;
                }
                this._ldapDelEntry(ctx, this.typeValueMap.getKeyName(), id[i]);
            }
        }
        catch (EASBizException e) {
            logger.info((Object)("ldap import EASBizException " + (Object)((Object)e)));
            return;
        }
        catch (UuidException e) {
            logger.info((Object)("ldap import UuidException " + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.info((Object)("ldap import BOSException " + (Object)((Object)e)));
            return;
        }
        catch (UserSyncConfigParseException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01");
            logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff01 " + e));
            return;
        }
        catch (IOException e) {
            LdapImportUtil.initException(this.info, "ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\uff01");
            logger.info((Object)("ldap\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef " + e));
            return;
        }
    }

    @Override
    protected void _ldapControlMapping(Context ctx, String id, String dn) throws BOSException {
        ILdapMapping ildap = LdapMappingFactory.getLocalInstance(ctx);
        LdapMappingInfo mappingInfo = null;
        LdapMappingCollection mappingCol = ildap.getLdapMappingCollection("select * where Ldapdn = '" + dn + "'");
        try {
            if (mappingCol != null) {
                if (mappingCol.size() == 0) {
                    External2EasUsersMapFactory.getLocalInstance(ctx).delete("where FactPath = '" + dn + "'");
                } else {
                    Iterator it = mappingCol.iterator();
                    while (it.hasNext()) {
                        mappingInfo = (LdapMappingInfo)it.next();
                        if (id == null) {
                            mappingInfo.setEasid("");
                            continue;
                        }
                        if (id.length() == 0) {
                            mappingInfo.setEasid("");
                            continue;
                        }
                        mappingInfo.setEasid(id);
                    }
                }
            } else {
                External2EasUsersMapFactory.getLocalInstance(ctx).delete("where FactPath = '" + dn + "'");
            }
        }
        catch (EASBizException e) {
            logger.info((Object)("\u5904\u7406id\uff0ddn\u7684\u6620\u5c04\u5173\u7cfb \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.info((Object)("\u5904\u7406id\uff0ddn\u7684\u6620\u5c04\u5173\u7cfb \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
    }

    @Override
    protected void _ldapProject(Context ctx, String strConnect) throws BOSException {
        try {
            ILdapProject iLdapProject = (ILdapProject)InstantiationClassUtil.initLdapConfigManager("ldapProjectClass.xml").getReadXML();
            iLdapProject.useLdapProject(ctx, strConnect);
        }
        catch (UserSyncConfigParseException e) {
            logger.info((Object)("EAS\u5230ldap\u6620\u5c04 \u5f02\u5e38 " + e));
            return;
        }
        catch (IOException e) {
            logger.info((Object)("EAS\u5230ldap\u6620\u5c04 \u5f02\u5e38 " + e));
            return;
        }
        catch (InstantiationException e) {
            logger.info((Object)("EAS\u5230ldap\u6620\u5c04 \u5f02\u5e38 " + e));
            return;
        }
        catch (IllegalAccessException e) {
            logger.info((Object)("EAS\u5230ldap\u6620\u5c04 \u5f02\u5e38 " + e));
            return;
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)("EAS\u5230ldap\u6620\u5c04 \u5f02\u5e38 " + e));
            return;
        }
    }

    @Override
    protected void _initLdap(Context ctx) throws BOSException {
        try {
            this.builderLdap((IObjectCollection)UserFactory.getLocalInstance((Context)ctx).getUserCollection());
            this.builderLdap((IObjectCollection)RoleFactory.getLocalInstance((Context)ctx).getRoleCollection());
            this.builderLdap((IObjectCollection)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection());
            this.builderLdap((IObjectCollection)PositionFactory.getLocalInstance((Context)ctx).getPositionCollection());
        }
        catch (EASBizException e) {
            logger.info((Object)("\u521d\u59cb\u5316ldap \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.info((Object)("\u521d\u59cb\u5316ldap \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
    }

    private void builderLdap(IObjectCollection obCol) throws EASBizException, BOSException {
        try {
            ObjectBaseInfo info = null;
            String[] id = new String[obCol.size()];
            for (int i = 0; i < obCol.size(); ++i) {
                info = (ObjectBaseInfo)obCol.getObject(i);
                id[i] = info.getId().toString();
            }
            ILdapEntryFacade ildap = LdapEntryFacadeFactory.getRemoteInstance();
            ildap.ldapHandleEntry(id, null);
        }
        catch (EASBizException e) {
            logger.info((Object)("\u6536\u96c6id  \u521d\u59cb\u5316ldap \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
        catch (BOSException e) {
            logger.info((Object)("\u6536\u96c6id  \u521d\u59cb\u5316ldap \u5f02\u5e38 " + (Object)((Object)e)));
            return;
        }
    }

    @Override
    protected List _idToDN(Context ctx, String id) throws BOSException {
        ArrayList<String> ay = null;
        LdapMappingCollection col = LdapMappingFactory.getLocalInstance(ctx).getLdapMappingCollection("select * where Easid = '" + id + "'");
        if (col != null && col.size() != 0) {
            ay = new ArrayList<String>();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ay.add(((LdapMappingInfo)it.next()).getLdapdn().toString());
            }
        }
        return ay;
    }

    @Override
    protected HashMap _importEntryType(Context ctx, String type) throws BOSException {
        LdapEntryCollection col = null;
        LdapEntryCollection reCol = null;
        String tempNumber = "";
        ArrayList<String> list = new ArrayList<String>();
        HashMap map = null;
        try {
            col = LdapEntryFactory.getLocalInstance(ctx).getLdapEntryCollection("select * where type like '%" + type + "%' and state = '" + EntryStateEnum.SSO_DEFAULT.toString() + "' group by number");
            for (int i = 0; i < col.size(); ++i) {
                if (tempNumber.equals(col.get(i).getNumber())) continue;
                tempNumber = col.get(i).getNumber();
                reCol = this.getLdapInfoColTimeACS(ctx, tempNumber, false);
                for (int j = 0; j < reCol.size(); ++j) {
                    list.add(reCol.get(j).getId().toString());
                }
            }
            if (list.size() != 0) {
                map = this._importLdap(ctx, list);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected HashMap _importEntryInfo(Context ctx, LdapEntryInfo info) throws BOSException {
        LdapEntryCollection reCol = null;
        reCol = this.getLdapInfoColTimeACS(ctx, info.getNumber(), false);
        ArrayList<String> list = new ArrayList<String>();
        HashMap map = null;
        for (int j = 0; j < reCol.size(); ++j) {
            list.add(reCol.get(j).getId().toString());
        }
        try {
            if (list != null) {
                map = this._importLdap(ctx, list);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private LdapEntryCollection getLdapInfoColTimeACS(Context ctx, String number, boolean isTree) throws BOSException {
        LdapEntryCollection col = null;
        String sqlStr = "";
        sqlStr = isTree ? "select * where number = '" + number + "' and state <> '" + EntryStateEnum.SSO_SUCCESS.toString() + "' order by createtime asc" : "select * where number = '" + number + "' and state = '" + EntryStateEnum.SSO_DEFAULT.toString() + "' order by createtime asc";
        col = LdapEntryFactory.getLocalInstance(ctx).getLdapEntryCollection(sqlStr);
        return col;
    }

    @Override
    protected LdapEntryCollection _getTreeLdapEntryInfo(Context ctx) throws BOSException {
        LdapEntryCollection col = null;
        LdapEntryCollection reCol = new LdapEntryCollection();
        col = LdapEntryFactory.getLocalInstance(ctx).getLdapEntryCollection();
        Iterator it = col.iterator();
        LdapEntryCollection tempCol = null;
        while (it.hasNext()) {
            LdapEntryInfo entryInfo = (LdapEntryInfo)it.next();
            tempCol = this.getLdapInfoColTimeACS(ctx, entryInfo.getNumber(), false);
            if (tempCol.size() == 0) continue;
            reCol.add(tempCol.get(0));
        }
        return reCol;
    }
}

