/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapFactory;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapInfo;
import com.kingdee.eas.cp.eip.sso.IExternal2EasUsersMap;
import com.kingdee.eas.cp.eip.sso.ILdapMapping;
import com.kingdee.eas.cp.eip.sso.LdapMappingCollection;
import com.kingdee.eas.cp.eip.sso.LdapMappingFactory;
import com.kingdee.eas.cp.eip.sso.LdapMappingInfo;
import com.kingdee.eas.cp.eip.sso.app.AbstractUserSyncHandleFacadeControllerBean;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapServerUtil;
import com.kingdee.eas.cp.eip.sso.special.DefaultOutputXml;
import com.kingdee.eas.cp.eip.sso.user.DatasourceUtilManager;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigWriter;
import com.kingdee.eas.cp.eip.sso.util.UserSyncListenerConfigManagerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class UserSyncHandleFacadeControllerBean
extends AbstractUserSyncHandleFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.sso.app.UserSyncHandleFacadeControllerBean");

    @Override
    protected HashMap _getAllUserNode(Context ctx) throws BOSException {
        try {
            UserSyncConfigManager.loadConfig();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap map = UserSyncConfigManager.getUserSyncResourcesMap();
        return map;
    }

    @Override
    protected void _controlUserNode(Context ctx, HashMap map) throws BOSException {
        try {
            UserSyncConfigManager userSyncConfigManager = new UserSyncConfigManager();
            UserSyncConfigWriter user = new UserSyncConfigWriter();
            user.store(userSyncConfigManager.getConfigFile(), map);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _testConnect(Context ctx, String resType, String key) throws BOSException {
        IDatasourceUtil dsUtil = DatasourceUtilManager.getDatasourceUtil(resType);
        if (dsUtil == null) {
            System.err.println("[Eas user sync]no user resource connect util class for " + resType + ".");
            return false;
        }
        try {
            dsUtil.connect(key);
        }
        catch (NamingException e) {
            logger.error((Object)"NamingException !", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected void _initManager(Context ctx) throws BOSException {
        UserSyncConfigManager.init();
    }

    @Override
    protected HashMap _getSyncClass(Context ctx) throws BOSException {
        try {
            return (HashMap)UserSyncListenerConfigManagerUtil.initLdapConfigManager().getReadXML();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected int _cleanSyncEasData(Context ctx, HashMap map) throws BOSException {
        this._controlUserNode(ctx, map);
        ILdapMapping ldapMapping = LdapMappingFactory.getLocalInstance(ctx);
        IExternal2EasUsersMap external2EasUsersMap = External2EasUsersMapFactory.getLocalInstance(ctx);
        ArrayList<ObjectUuidPK> userPKlist = new ArrayList<ObjectUuidPK>();
        LdapMappingCollection col = ldapMapping.getLdapMappingCollection();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            LdapMappingInfo ldapMappingInfo = (LdapMappingInfo)iter.next();
            try {
                String oql = "where FactPath = '" + ldapMappingInfo.getLdapdn() + "'";
                External2EasUsersMapInfo userMapInfo = external2EasUsersMap.getExternal2EasUsersMapInfo(oql);
                if (!userMapInfo.isSSOCreateUser() || userMapInfo.getEasUserID() == null || "administrator".equals(userMapInfo.getEasUsername()) || "user".equals(userMapInfo.getEasUsername())) continue;
                userPKlist.add(new ObjectUuidPK(userMapInfo.getEasUserID().getId()));
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
        int count = 0;
        try {
            IObjectPK[] pkList = external2EasUsersMap.getPKList();
            count = pkList.length;
            external2EasUsersMap.delete(pkList);
            ldapMapping.delete(ldapMapping.getPKList());
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            if (!userPKlist.isEmpty()) {
                IObjectPK[] arrayPK = userPKlist.toArray(new IObjectPK[0]);
                user.delete(arrayPK);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return count;
    }

    @Override
    protected String _inputXML(Context ctx, Map map, String id) throws BOSException {
        String str = "";
        try {
            str = LdapServerUtil.init().importXML(map, id);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return str;
    }

    @Override
    protected Map _importXML(Context ctx, String easid, String ldapid, Map map) throws BOSException {
        HashMap map1 = null;
        try {
            map1 = (HashMap)DefaultOutputXml.init().readXML(easid);
            return map1;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

