/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.qrcode.IQrCodeService;
import com.kingdee.eas.cp.eip.sso.qrcode.QrTokenOpenIdManager;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AjaxException;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AppAuth2Exception;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.OpenApiAuthException;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.Ajax;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.AppAuth2;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.AuthorizationUtil;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.Base64;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeService
implements IQrCodeService {
    private static final Logger logger = LoggerFactory.getLogger(QrCodeService.class);

    @Override
    public String loginPolling(String dataCenter, String language, String qrCodeToken) throws Exception, AppAuth2Exception, OpenApiAuthException {
        Context ctx = QrTokenOpenIdManager.getContext(dataCenter, language);
        Long start = System.currentTimeMillis();
        String ticket = null;
        int pollingCoun = QrCodeTokenHelper.cbCount;
        ticket = QrTokenOpenIdManager.getTicket(ctx, qrCodeToken);
        while (System.currentTimeMillis() - start < 30000L && this.isNullTicket(ticket)) {
            Thread.sleep(500L);
            ticket = QrTokenOpenIdManager.getTicket(ctx, qrCodeToken);
        }
        if (this.isNullTicket(ticket)) {
            logger.error("loginPolling--{success : false ; errro_code : 408, info : qrcode was not scanned}");
            throw new Exception("408");
        }
        return QrTokenOpenIdManager.getUserInfoMapByToken(ctx, qrCodeToken);
    }

    @Override
    public String getLoginQrCode(String dataCenter, String language) throws Exception {
        String oauth_consumer_key = QrCodeTokenHelper.getAppID();
        String oauth_consumer_secret = QrCodeTokenHelper.getAppSecret();
        String oauth_signature_method = "HMAC-SHA1";
        long oauth_timestamp = System.currentTimeMillis() / 1000L;
        String oauth_nonce = String.valueOf(oauth_timestamp + (long)QrCodeTokenHelper.RAND.nextInt());
        float oauth_version = 1.0f;
        String oauth_token = null;
        String oauth_verifier = null;
        String oauth_token_secret = null;
        StringBuilder sb = new StringBuilder();
        StringBuilder callbackUrl = new StringBuilder();
        callbackUrl.append(QrCodeTokenHelper.getCallbackURL()).append("/").append(dataCenter).append("/").append(language);
        sb.append(QrCodeTokenHelper.getLoginCodeURL()).append("?callback=").append(URLEncoder.encode(callbackUrl.toString(), "utf-8"));
        String systemKey = QrCodeTokenHelper.getSystemKey();
        sb.append("&content=").append(new String(Base64.encodeBase64(systemKey.getBytes("utf-8")), "ISO-8859-1"));
        String url = sb.toString();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String oauth_signature = null;
        try {
            oauth_signature = AuthorizationUtil.generateAuthorizationHeader(oauth_consumer_key, oauth_consumer_secret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, oauth_token, oauth_token_secret, oauth_verifier, url, parameters, "GET");
        }
        catch (Exception e) {
            logger.error("generateAuthorizationHeader error:  ");
            e.printStackTrace();
            throw new Exception("501");
        }
        HttpGet method = new HttpGet(url);
        method.setHeader("Authorization", oauth_signature);
        String retJson = null;
        logger.error("Authorization===" + oauth_signature);
        logger.error("url===" + sb.toString());
        try {
            retJson = Ajax.exceuteRequest((HttpRequestBase)method, "utf-8");
        }
        catch (AjaxException e) {
            logger.equals("get qrcode from yunzhijia error :   " + e.getMessage());
            e.printStackTrace();
            throw new AjaxException("503");
        }
        JSONObject ret = JSON.parseObject((String)retJson);
        JSONObject data = (JSONObject)ret.get((Object)"data");
        Long expireTime = (Long)data.get((Object)"expiretime");
        String pictureUrl = data.getString("url");
        String qrcodeToken = data.getString("token");
        long now = System.currentTimeMillis();
        if (now > expireTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.error("ExpireTime Error ------------  the qrcode from yunzhijia is ExpireTime; ExpireTime is : " + sdf.format(new Date(expireTime)));
            throw new AjaxException("409");
        }
        Context ctx = QrTokenOpenIdManager.getContext(dataCenter, language);
        QrTokenOpenIdManager.applyQrCode(ctx, pictureUrl, qrcodeToken, expireTime);
        return data.toString();
    }

    @Override
    public String getOpenId(String qrcode_ticket, String qrcode_token) throws AppAuth2Exception, OpenApiAuthException, AjaxException {
        String access_token = null;
        try {
            access_token = AppAuth2.getAccess_token();
        }
        catch (AppAuth2Exception e) {
            logger.error("get Access_token Exception : " + e.getMessage());
            throw e;
        }
        String oauth_consumer_key = QrCodeTokenHelper.getAppID();
        String oauth_consumer_secret = QrCodeTokenHelper.getAppSecret();
        String oauth_signature_method = "HMAC-SHA1";
        long oauth_timestamp = System.currentTimeMillis() / 1000L;
        String oauth_nonce = String.valueOf(oauth_timestamp + (long)QrCodeTokenHelper.RAND.nextInt());
        float oauth_version = 1.0f;
        HttpPost post = new HttpPost(QrCodeTokenHelper.getTicketTokenURL());
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        JSONObject params = new JSONObject();
        params.put("access_token", (Object)access_token);
        params.put("ticket", (Object)qrcode_ticket);
        StringEntity paramsEntity = new StringEntity(params.toString(), "utf-8");
        post.setEntity((HttpEntity)paramsEntity);
        try {
            String oauth_signature = AuthorizationUtil.generateAuthorizationHeader(oauth_consumer_key, oauth_consumer_secret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, null, null, null, QrCodeTokenHelper.getTicketTokenURL(), new HashMap<String, Object>(), "POST");
            post.setHeader("Authorization", oauth_signature);
        }
        catch (Exception e) {
            logger.error("generateAuthorizationHeader error:  ");
            e.printStackTrace();
            OpenApiAuthException oaae = new OpenApiAuthException("501");
            throw oaae;
        }
        String ret = null;
        try {
            ret = Ajax.exceuteRequest((HttpRequestBase)post, "utf-8");
        }
        catch (AjaxException e) {
            logger.equals("get openid from yunzhijia error :   " + e.getMessage());
            e.printStackTrace();
            throw new AjaxException("502");
        }
        logger.error(ret);
        if (ret != null) {
            JSONObject retJson = JSONObject.parseObject((String)ret);
            JSONObject data = (JSONObject)retJson.get((Object)"data");
            boolean success = retJson.getBoolean("success");
            if (success) {
                String openid = data.getString("openid");
                String userName = data.getString("username");
                logger.error("QrCodeLogin : from yunzhizjia UserName " + userName);
                return openid;
            }
            logger.error("get openid from yunzhijia; return success is false, Unknown Exception");
            throw new AjaxException("503");
        }
        return null;
    }

    @Override
    public String callbackForTicket(Context ctx, String ticket, String token) throws AppAuth2Exception, OpenApiAuthException, AjaxException {
        String openId = this.getOpenId(ticket, token);
        QrTokenOpenIdManager.updateTicketAndOpenId(ctx, ticket, openId, token);
        return openId;
    }

    private boolean isNullTicket(String ticket) {
        return "NULL_TICKET".equals(ticket) || StringUtils.isEmpty((String)ticket);
    }
}

