/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.qrcode.helper;

import com.kingdee.eas.cp.eip.sso.qrcode.helper.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AuthorizationUtil {
    public static SecureRandom RAND = new SecureRandom();
    private static final Base64 BASE64 = new Base64();
    private static String characterEncoding = "UTF-8";

    public static String generateAuthorizationHeader(String consumerKey, String consumerSecret, String signatureMethod, long timestamp, String nonce, float version, String oauthToken, String oauthTokenSecret, String verifier, String url, Map<String, Object> parameters, String requestType) throws URISyntaxException, IOException, GeneralSecurityException {
        if (StringUtils.isEmpty((CharSequence)consumerKey)) {
            throw new IllegalArgumentException("consumerKey is null or empty!");
        }
        if (StringUtils.isEmpty((CharSequence)consumerSecret)) {
            throw new IllegalArgumentException("consumerSecret is null or empty!");
        }
        if (null == nonce) {
            throw new IllegalArgumentException("nonce is null!");
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("STRING is null or empty!");
        }
        if (StringUtils.isEmpty((CharSequence)requestType)) {
            throw new IllegalArgumentException("requestType is null or empty!");
        }
        if (StringUtils.isEmpty((CharSequence)signatureMethod)) {
            signatureMethod = "HMAC-SHA1";
        }
        LinkedHashMap<String, String> oauthHeaderParams = new LinkedHashMap<String, String>();
        oauthHeaderParams.put("oauth_consumer_key", consumerKey);
        oauthHeaderParams.put("oauth_signature_method", signatureMethod);
        oauthHeaderParams.put("oauth_timestamp", String.valueOf(timestamp));
        oauthHeaderParams.put("oauth_nonce", nonce);
        oauthHeaderParams.put("oauth_version", String.valueOf(version));
        if (StringUtils.isNotEmpty((CharSequence)oauthToken)) {
            if (StringUtils.isEmpty((CharSequence)oauthTokenSecret)) {
                throw new IllegalArgumentException("oauthTokenSecret is null or empty!");
            }
            oauthHeaderParams.put("oauth_token", oauthToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)verifier)) {
            oauthHeaderParams.put("oauth_verifier", verifier);
        }
        HashMap<String, Object> signatureBaseParams = new HashMap<String, Object>(oauthHeaderParams);
        if (null != parameters && !parameters.isEmpty()) {
            signatureBaseParams.putAll(parameters);
        }
        AuthorizationUtil.parseGetParameters(url, signatureBaseParams);
        String oauthBaseString = AuthorizationUtil.getBaseString(requestType, url, signatureBaseParams);
        String signature = AuthorizationUtil.base64Encode(AuthorizationUtil.computeSignature(consumerSecret, oauthTokenSecret, oauthBaseString));
        oauthHeaderParams.put("oauth_signature", signature);
        String authorization = "OAuth " + AuthorizationUtil.encodeParameters(oauthHeaderParams, ",", true);
        return authorization;
    }

    private static void parseGetParameters(String url, Map<String, Object> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                String[] ignore = queryStrs;
                int len$ = queryStrs.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String query = ignore[i$];
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.put(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8"));
                        continue;
                    }
                    signatureBaseParams.put(URLDecoder.decode(split[0], "UTF-8"), "");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private static String getBaseString(String requestType, String url, Map<String, Object> parameters) throws URISyntaxException, IOException {
        return AuthorizationUtil.percentEncode(requestType.toUpperCase()) + '&' + AuthorizationUtil.percentEncode(AuthorizationUtil.normalizeUrl(url)) + '&' + AuthorizationUtil.percentEncode(AuthorizationUtil.normalizeParameters(parameters));
    }

    private static String normalizeUrl(String url) throws URISyntaxException {
        String path1;
        int path;
        boolean dropPort;
        URI uri = new URI(url);
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equalsIgnoreCase("http") && uri.getPort() == 80 || scheme.equalsIgnoreCase("https") && uri.getPort() == 443;
        if (dropPort && (path = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, path);
        }
        if ((path1 = uri.getRawPath()) == null || path1.length() <= 0) {
            path1 = "/";
        }
        return scheme + "://" + authority + path1;
    }

    private static List<Map.Entry<String, Object>> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.value);
        }
        return list;
    }

    private static String normalizeParameters(Map<String, Object> parameters) throws IOException {
        if (null != parameters && !parameters.isEmpty()) {
            ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parameters.size());
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                if ("oauth_signature".equals(parameter.getKey())) continue;
                p.add(new ComparableParameter(parameter));
            }
            Collections.sort(p);
            return AuthorizationUtil.formEncode(AuthorizationUtil.getParameters(p));
        }
        return "";
    }

    public static String percentEncode(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException var2) {
            throw new RuntimeException(var2.getMessage(), var2);
        }
    }

    public static String decodeCharacters(byte[] from) {
        if (StringUtils.isNotEmpty((CharSequence)characterEncoding)) {
            try {
                return new String(from, characterEncoding);
            }
            catch (UnsupportedEncodingException var2) {
                System.err.println(var2 + "");
            }
        }
        return new String(from);
    }

    public static String formEncode(Iterable<? extends Map.Entry<String, Object>> parameters) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        AuthorizationUtil.formEncode(parameters, b);
        return AuthorizationUtil.decodeCharacters(b.toByteArray());
    }

    public static void formEncode(Iterable<? extends Map.Entry<String, Object>> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first = true;
            for (Map.Entry<String, Object> entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(AuthorizationUtil.encodeCharacters(AuthorizationUtil.percentEncode(AuthorizationUtil.toString(entry.getKey()))));
                into.write(61);
                into.write(AuthorizationUtil.encodeCharacters(AuthorizationUtil.percentEncode(AuthorizationUtil.toString(entry.getValue()))));
            }
        }
    }

    public static byte[] encodeCharacters(String from) {
        if (characterEncoding != null) {
            try {
                return from.getBytes(characterEncoding);
            }
            catch (UnsupportedEncodingException var2) {
                System.err.println(var2 + "");
            }
        }
        return from.getBytes();
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    private static byte[] computeSignature(String consumerSecret, String tokenSecret, String baseString) throws GeneralSecurityException, UnsupportedEncodingException {
        String keyString = AuthorizationUtil.percentEncode(consumerSecret) + '&' + AuthorizationUtil.percentEncode(tokenSecret);
        byte[] keyBytes = keyString.getBytes("UTF-8");
        SecretKeySpec key = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(key);
        byte[] text = baseString.getBytes("UTF-8");
        return mac.doFinal(text);
    }

    private static String base64Encode(byte[] b) {
        byte[] b2 = BASE64.encode(b);
        try {
            return new String(b2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException var3) {
            System.err.println(var3 + "");
            return new String(b2);
        }
    }

    private static String encodeParameters(Map<String, String> signatureBaseParams, String splitter, boolean quot) {
        StringBuffer buf = new StringBuffer();
        for (String key : signatureBaseParams.keySet()) {
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(AuthorizationUtil.percentEncode(key)).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(AuthorizationUtil.percentEncode(signatureBaseParams.get(key)));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    public static void main(String[] args) throws URISyntaxException, IOException, GeneralSecurityException {
        String oauth_consumer_key = "10103";
        String oauth_signature_method = "HMAC-SHA1";
        long oauth_timestamp = System.currentTimeMillis() / 1000L;
        String oauth_nonce = String.valueOf(oauth_timestamp + (long)RAND.nextInt());
        float oauth_version = 1.0f;
        String oauth_token = null;
        String oauth_verifier = null;
        String oauth_consumer_secret = "kingdee20150810";
        String oauth_token_secret = null;
        String url = "http://localhost:8000/openapi/v1/oauth/appToken.json";
        HashMap<String, Object> parameters = null;
        String requestType = "post";
        String auth = AuthorizationUtil.generateAuthorizationHeader(oauth_consumer_key, oauth_consumer_secret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, oauth_token, oauth_token_secret, oauth_verifier, url, parameters, requestType);
        oauth_consumer_key = "2AudaAEghEJGEHkw";
        oauth_signature_method = "HMAC-SHA1";
        oauth_timestamp = System.currentTimeMillis() / 1000L;
        oauth_nonce = String.valueOf(oauth_timestamp + (long)RAND.nextInt());
        oauth_version = 1.0f;
        oauth_token = "3f3f94d26637acc3f265c016ca471183";
        oauth_verifier = "3f3f94d26637acc3f265c016ca471183";
        oauth_consumer_secret = "0QNOWUHsWcI9i8UyqBFKUarayqBDUsVnxJrumYHEUl";
        oauth_token_secret = "9a392124d84d6bddd44f86c88bbeca4";
        url = "http://localhost:8000/openapi/v1/ticket/acquire.json";
        parameters = new HashMap<String, Object>();
        parameters.put("openToken", "5fb27cf1b1929c27dade39bf9fcfc6a");
        parameters.put("appid", "10103");
        parameters.put("mid", "10109");
        requestType = "post";
        String auth1 = AuthorizationUtil.generateAuthorizationHeader(oauth_consumer_key, oauth_consumer_secret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, oauth_token, oauth_token_secret, oauth_verifier, url, parameters, requestType);
        System.out.print(auth1);
    }

    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry<String, Object> value;
        private final String key;

        ComparableParameter(Map.Entry<String, Object> value) {
            this.value = value;
            String n = ComparableParameter.toString(value.getKey());
            String v = ComparableParameter.toString(value.getValue());
            this.key = AuthorizationUtil.percentEncode(n) + ' ' + AuthorizationUtil.percentEncode(v);
        }

        private static String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

