/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.qrcode.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeTokenHelper {
    private static Logger logger = LoggerFactory.getLogger(QrCodeTokenHelper.class);
    private static Properties props = null;
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.properties.dir";
    private static final String QRCODETOKEN_PROP_NAME = "QrCodeToken.properties";
    public static final String EASROOT = "easclient.root";
    private static final String APP_ID = "10658";
    private static final String APP_SERCRET = "123456789";
    private static final String TICKETTOKEN_URL = "https://www.yunzhijia.com/openapi/third/v1/ticket/public/tickettocontext";
    private static final String LOGINERCODE_URL = "http://www.yunzhijia.com/openapi/third/v1/space/c/public/getloginercode";
    private static final String AUTH_URL = "http://do.yunzhijia.com/openauth2/api/appAuth2";
    public static final String HTTP_GETMETHOD = "GET";
    public static final String HTTP_POSTMETHOD = "POST";
    public static final String AND = "&";
    public static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    public static final float OAUTH_VERSION = 1.0f;
    public static final Random RAND = new Random();
    public static int cbCount = 0;
    public static final String DEFALUT_SYSTEM_KEY = "EAS";
    private static final String DD_TOKEN_URL = "https://oapi.dingtalk.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Properties prop = null;
        try {
            prop = GlobleLoginConfigFactory.getLocalInstance().getBizConfig();
        }
        catch (BOSException e1) {
            logger.error("get config error");
            e1.printStackTrace();
        }
        if (prop == null) {
            String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + QRCODETOKEN_PROP_NAME;
            FileInputStream fis = null;
            try {
                File file = new File(configFile);
                if (!file.exists()) {
                    logger.error("Eas QrCodeToken init config file is not exist.config file path =[" + configFile + "]");
                }
                fis = new FileInputStream(file);
                props = new Properties();
                props.load(fis);
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6QrCodeToken.properties\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            props = prop;
        }
    }

    public static String getAppID() {
        String appID;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(appID = props.getProperty("app.id")))) {
            appID = APP_ID;
        }
        return appID;
    }

    public static String getAppSecret() {
        String appSecret;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(appSecret = props.getProperty("app.secret")))) {
            appSecret = APP_SERCRET;
        }
        return appSecret;
    }

    public static int getPrivacyStatement() {
        String privacyStatement;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(privacyStatement = props.getProperty("privacyStatement")))) {
            return 0;
        }
        return Integer.valueOf(privacyStatement);
    }

    public static String getCallbackURL() {
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        return props.getProperty("app.callback.url");
    }

    public static String getTicketTokenURL() {
        String ticketURL;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(ticketURL = props.getProperty("app.tickttoken.url")))) {
            ticketURL = TICKETTOKEN_URL;
        }
        return ticketURL;
    }

    public static String getAuthURL() {
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        try {
            String ticketURL = props.getProperty("app.auth.url");
            if (StringUtils.isEmpty((String)ticketURL)) {
                ticketURL = AUTH_URL;
            }
            return ticketURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return AUTH_URL;
        }
    }

    public static String getLoginCodeURL() {
        String ticketURL;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(ticketURL = props.getProperty("app.logincode.url")))) {
            ticketURL = LOGINERCODE_URL;
        }
        return ticketURL;
    }

    public static boolean isPortalEnableQrCode() {
        String portalEnableQrCode;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(portalEnableQrCode = props.getProperty("portal.enableqrcode")))) {
            return false;
        }
        return Boolean.parseBoolean(portalEnableQrCode);
    }

    public static boolean isGuiEnableQrCode() {
        String guiEnableQrCode;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(guiEnableQrCode = props.getProperty("gui.enableqrcode")))) {
            return false;
        }
        return Boolean.parseBoolean(guiEnableQrCode);
    }

    public static boolean isQrcodeDefault() {
        String qrcodeDefault;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(qrcodeDefault = props.getProperty("portal.isqrcodedefault")))) {
            return false;
        }
        return Boolean.parseBoolean(qrcodeDefault);
    }

    public static String getSystemKey() {
        String systemKey;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(systemKey = props.getProperty("app.systemkey")))) {
            return DEFALUT_SYSTEM_KEY;
        }
        return systemKey;
    }

    public static Object getValue(String key) {
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        return props.getProperty(key);
    }

    public static void clearCache() {
        props = null;
    }

    public static String getCookieKey() {
        String appSecret;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(appSecret = props.getProperty("app.env.type")))) {
            return "1";
        }
        return appSecret;
    }

    public static String getDDAppID() {
        String appID;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(appID = props.getProperty("app.dd.id")))) {
            appID = APP_ID;
        }
        return appID;
    }

    public static String getDDAppSecret() {
        String appSecret;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        if (StringUtils.isEmpty((String)(appSecret = props.getProperty("app.dd.secret")))) {
            appSecret = APP_SERCRET;
        }
        return appSecret;
    }

    public static String getDDTokenURL() {
        String ticketURL;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        ticketURL = StringUtils.isEmpty((String)(ticketURL = props.getProperty("app.dd.token.url"))) ? "https://oapi.dingtalk.com/gettoken" : ticketURL + "/gettoken";
        return ticketURL;
    }

    public static String getDDUserURL() {
        String ticketURL;
        if (props == null) {
            QrCodeTokenHelper.init();
        }
        ticketURL = StringUtils.isEmpty((String)(ticketURL = props.getProperty("app.dd.token.url"))) ? "https://oapi.dingtalk.com/topapi/v2/user/getuserinfo" : ticketURL + "/topapi/v2/user/getuserinfo";
        return ticketURL;
    }
}

