/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.special;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.agentuser.PersonHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.SyncUserItem;
import com.kingdee.eas.cp.eip.sso.special.AbstractSyncUserIsvalidationDefault;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SyncUserIsvalidationDefaultPerson
extends AbstractSyncUserIsvalidationDefault {
    private static Logger logger = Logger.getLogger((String)SyncUserIsvalidationDefaultPerson.class.getName());
    private List list;

    @Override
    public SyncUserItem initItem(IDatasourceUtil dsUtil, UserSyncConfigItem syncConfigItem) {
        SyncUserItem item = super.initItem(dsUtil, syncConfigItem);
        this.list.add(item);
        return item;
    }

    @Override
    public void before(Context ctx) {
        this.list = new ArrayList();
    }

    @Override
    public void after(Context ctx) throws Exception {
        UserInfo userInfo = null;
        RoleInfo roleInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        boolean isRole = true;
        boolean isOrg = true;
        String roleNumber = "0006";
        String orgNumber = "1";
        try {
            roleInfo = RoleFactory.getLocalInstance((Context)ctx).getRoleInfoByNumber(roleNumber);
            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("where number='" + orgNumber + "'");
        }
        catch (Exception e) {
            logger.info((Object)("EAS business entity get localInstance Exception:" + e));
        }
        if (roleInfo == null) {
            logger.info((Object)"user sync have no default role");
            isRole = false;
        }
        if (fullOrgUnitInfo == null) {
            logger.info((Object)"user sync have no default org");
            isOrg = false;
            isRole = false;
        }
        IOrgRangeIncludeSubOrg orgRangeIncludeSubOrg = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            try {
                SyncUserItem suItem = (SyncUserItem)it.next();
                logger.info((Object)("user begin to sync: number=" + suItem.getUserNumber() + " name=" + suItem.getUserName()));
                userInfo = this.userFPerson(ctx, suItem);
                if (userInfo == null) continue;
                FullOrgUnitCollection fullOrgUnitColls = this.setUserType(ctx, userInfo, suItem);
                FullOrgUnitCollection fullOrgUnitCollsClone = (FullOrgUnitCollection)fullOrgUnitColls.clone();
                Iterator fullOrgUnitIter = fullOrgUnitCollsClone.iterator();
                OrgRangeIncludeSubOrgInfo orgInfo = null;
                while (fullOrgUnitIter.hasNext()) {
                    orgInfo = new OrgRangeIncludeSubOrgInfo();
                    orgInfo.setUser(userInfo);
                    orgInfo.setOrg((FullOrgUnitInfo)fullOrgUnitIter.next());
                    orgInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
                    orgRangeIncludeSubOrg.addnew((CoreBaseInfo)orgInfo);
                }
                UserFactory.getLocalInstance((Context)ctx).saveRoleInfo(userInfo, fullOrgUnitColls, roleInfo.getId().toString());
                ArrayList<String> userIdList = new ArrayList<String>();
                userIdList.add(userInfo.getId().toString());
                orgRangeIncludeSubOrg.updateAdminOrgRange(userIdList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private UserInfo userFPerson(Context ctx, SyncUserItem suItem) throws Exception {
        UserInfo userInfo = null;
        try {
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            String ldapUserNumber = suItem.getUserNumber();
            if ("administrator".equals(ldapUserNumber) || "user".equals(ldapUserNumber)) {
                logger.info((Object)("user sync number=" + ldapUserNumber + " this number is EAS default user"));
                return null;
            }
            userInfo = user.getUserInfoByNumber(ldapUserNumber);
            if (userInfo == null) {
                logger.info((Object)("user sync number=" + ldapUserNumber + " this number have no EAS user"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return userInfo;
    }

    private FullOrgUnitCollection setUserType(Context ctx, UserInfo userInfo, SyncUserItem suItem) throws Exception {
        FullOrgUnitCollection colls = new FullOrgUnitCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("name", (Object)suItem.getUserName());
        view.setFilter(filter);
        PersonCollection collection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        if (collection != null && collection.size() > 0) {
            PersonInfo person = collection.get(0);
            userInfo.setPerson(person);
            userInfo.setType(UserType.PERSON);
            userInfo.setName(person.getName());
            UserFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)userInfo);
            PersonHelper ph = new PersonHelper();
            colls = ph.addUserOrgRange(ctx, (IObjectPK)new ObjectUuidPK(userInfo.getId()), person, userInfo);
        } else {
            userInfo.setType(UserType.OTHER);
            UserFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)userInfo);
        }
        return colls;
    }

    private void setDefaultUserRole(Context ctx, UserInfo userInfo, FullOrgUnitInfo fullOrgUnitInfo, RoleInfo roleInfo) throws Exception {
        String userId = userInfo.getId().toString();
        String roleId = roleInfo.getId().toString();
        String orgId = fullOrgUnitInfo.getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("If not exists (select * from T_PM_UserRoleOrg ");
        sb.append("where FUserID='" + userId + "' and FRoleID='" + roleId + "' and FOrgID='" + orgId + "') ");
        sb.append("insert into T_PM_UserRoleOrg(FUserID,FRoleID,FOrgID) ");
        sb.append("values('" + userId + "','" + roleId + "','" + orgId + "')");
        String sql = sb.toString();
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.info((Object)("sql exception " + sql + " --- " + (Object)((Object)e)));
            throw e;
        }
        userInfo.setMainRole(roleInfo);
        UserFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)userInfo);
    }

    private void setDefaultOrgUnit(Context ctx, UserInfo userInfo, FullOrgUnitInfo fullOrgUnitInfo) throws Exception {
        String userId = userInfo.getId().toString();
        String orgId = fullOrgUnitInfo.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("user", (Object)userId);
        filter.appendFilterItem("org", (Object)orgId);
        filter.appendFilterItem("type", (Object)new Integer(10));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        OrgRangeCollection collection = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgRangeCollection(view);
        if (collection.size() <= 0) {
            OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
            orgRangeInfo.setOrg(fullOrgUnitInfo);
            orgRangeInfo.setUser(userInfo);
            orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
            OrgRangeFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)orgRangeInfo);
        }
        userInfo.setDefOrgUnit(fullOrgUnitInfo);
        UserFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)userInfo);
    }
}

