/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.LdapEntryFacadeFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapEasInfo;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.util.LdapConfigManagerUtil;
import com.kingdee.eas.cp.eip.sso.util.LdapImportLanguageUtil;
import com.kingdee.eas.cp.eip.sso.util.LdapImportUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public final class LdapUtil
implements IDatasourceUtil {
    protected DirContext dirCtx;
    protected NamingEnumeration namingEnum;
    protected SearchResult searchResult;
    protected Logger logger = Logger.getLogger(LdapUtil.class);
    private Object ldapValue = null;
    private Iterator tempit = null;
    private LdapControlInfo ldapControlInfo = null;
    private LdapEasInfo ldapEasInfo = null;
    private BasicAttribute objclassSet = null;
    private BasicAttributes attrs = null;
    private ModificationItem[] modificationItem = null;
    private String easPro = null;
    private String ldapPro = null;
    private String ldapKeyName = null;
    private String relativelyName = null;
    private String dnStr = null;
    private String person = null;
    private String newDN = null;
    private ArrayList entryAtt = null;
    private String ldapKey = null;
    private String easKey = null;
    private String baseDN = null;

    @Override
    public Object lookup(String userSyncResxName) throws NamingException {
        String flagStr;
        UserResource ldapResx = UserSyncConfigManager.get(userSyncResxName);
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", ldapResx.getContextFactory());
        env.put("java.naming.provider.url", ldapResx.getProviderURL());
        env.put("java.naming.security.authentication", ldapResx.getAuthentication());
        env.put("java.naming.security.principal", ldapResx.getPrincipal());
        String pwd = ldapResx.getCredentials();
        if (pwd != null && pwd.startsWith(flagStr = "encrypt:")) {
            int idx = flagStr.length();
            pwd = pwd.substring(idx);
            pwd = PasswordUtils.decodePassword(ldapResx.getPrincipal(), pwd);
        }
        env.put("java.naming.security.credentials", pwd);
        this.dirCtx = new InitialDirContext(env);
        if (this.dirCtx == null) {
            throw new NamingException("\u94fe\u63a5ldap\u670d\u52a1\u5668\u6709\u8bef\uff01");
        }
        return this.dirCtx;
    }

    @Override
    public void close() {
        if (this.dirCtx != null) {
            try {
                this.dirCtx.close();
                this.dirCtx = null;
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object executeQuery(Object object) {
        UserSyncConfigItem configItem = (UserSyncConfigItem)object;
        String baseDN = configItem.getBaseDN();
        String filterExp = configItem.getFilter();
        Object[] filterParam = this.getFilterParams(configItem);
        String returnAttr = configItem.getReturningAttributes();
        if (returnAttr == null || "".equals(returnAttr)) {
            returnAttr = configItem.getMapToEasUserName() + "," + configItem.getMapToEasUserNumber();
        }
        int searchScope = configItem.getSearchScope();
        if (returnAttr == null || "".equals(returnAttr)) {
            returnAttr = "defaultNamingContext";
        }
        String[] attrNames = returnAttr.indexOf(44) > -1 ? returnAttr.split(",") : new String[]{new String(returnAttr)};
        int countLimited = configItem.getCountLimited();
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(countLimited);
        searchControls.setReturningAttributes(attrNames);
        searchControls.setSearchScope(searchScope);
        try {
            this.namingEnum = this.dirCtx.search(baseDN, filterExp, filterParam, searchControls);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return this.namingEnum;
    }

    @Override
    public Object[] getFilterParams(UserSyncConfigItem configItem) {
        String lastSyncUbound;
        String lastSync = configItem.getLastSync();
        if (lastSync == null || "".equals(lastSync)) {
            lastSync = "19900101010101.0Z";
        }
        if ((lastSyncUbound = configItem.getLastSyncUbound()) == null || "".equals(lastSyncUbound)) {
            Calendar cal = Calendar.getInstance();
            Date currentDate = cal.getTime();
            lastSyncUbound = this.getLastSync(currentDate);
        }
        Object[] filterParam = new Object[]{lastSync, lastSyncUbound};
        return filterParam;
    }

    @Override
    public String getLastSync(Date currentDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String result = format.format(currentDate);
        result = result + "000101.0Z";
        return result;
    }

    @Override
    public Object getConnection() {
        return null;
    }

    @Override
    public void connect(String userSyncResxName) throws NamingException {
        this.lookup(userSyncResxName);
    }

    @Override
    public boolean next() {
        boolean result = false;
        if (this.namingEnum == null) {
            result = false;
        } else {
            try {
                result = this.namingEnum.hasMore();
                if (result) {
                    this.searchResult = (SearchResult)this.namingEnum.next();
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String getUserProperty(String propName) {
        String result = null;
        try {
            Attribute attr = this.searchResult.getAttributes().get(propName);
            if (attr != null) {
                result = (String)attr.get();
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getEntryDn() {
        return this.searchResult.getName();
    }

    public void initAddEntry(Context ctx, String addType, HashMap map, LdapEntryInfo info) throws UserSyncConfigParseException, IOException {
        LdapImportUtil.initControl(info, "add");
        this.attrs = new BasicAttributes();
        this.ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        this.objclassSet = new BasicAttribute("objectclass");
        this.tempit = this.ldapControlInfo.getObjectClass().iterator();
        while (this.tempit.hasNext()) {
            this.objclassSet.add(this.tempit.next().toString());
        }
        this.attrs.put(this.objclassSet);
        if (this.ldapControlInfo.getDefValue() != null && this.ldapControlInfo.getDefValue().size() != 0) {
            for (LdapEasInfo this.ldapEasInfo : this.ldapControlInfo.getDefValue()) {
                this.attrs.put(this.ldapEasInfo.getKeyName(), this.ldapEasInfo.getKeyValue());
            }
        }
        this.person = this.ldapControlInfo.getParent();
        if (this.person != null && this.person.toString().length() != 0) {
            this.attrs.put(this.ldapControlInfo.getParent(), LdapImportUtil.initDN(addType, map, true));
        }
        this.dnStr = LdapImportUtil.initDN(addType, map, false);
        for (LdapEasInfo this.ldapEasInfo : this.ldapControlInfo.getMapValue()) {
            this.ldapKeyName = this.ldapEasInfo.getKeyName();
            Object obValue = map.get(this.ldapEasInfo.getKeyValue());
            if (obValue instanceof ArrayList) {
                BasicAttribute uniquememberSet = this.initMoreBasicAttribute(ctx, obValue, this.ldapKeyName);
                if (uniquememberSet.size() == 0) continue;
                this.attrs.put(uniquememberSet);
                continue;
            }
            this.ldapValue = LdapImportLanguageUtil.getInfoValue(this.ldapEasInfo.getKeyValue(), obValue);
            if (this.ldapValue == null || StringUtils.isEmpty((String)this.ldapValue.toString())) continue;
            if (this.ldapKeyName.equals(this.ldapControlInfo.getRelativelyName())) {
                this.attrs.put(this.ldapKeyName, LdapImportUtil.getEasNumber(this.ldapValue.toString()));
                continue;
            }
            this.attrs.put(this.ldapKeyName, this.ldapValue);
        }
    }

    public void ldapAddEntry(LdapEntryInfo info) throws NamingException {
        try {
            this.ldapLookUp(info, true);
            this.dirCtx.createSubcontext(this.dnStr, (Attributes)this.attrs);
        }
        catch (NamingException e) {
            if (info.getException() == null) {
                LdapImportUtil.initException(info, "ldap\u6dfb\u52a0\u5f02\u5e38\uff01");
            }
            throw e;
        }
    }

    public void initUpdEntry(Context ctx, String oldDN, String addType, HashMap map, LdapEntryInfo info) throws UserSyncConfigParseException, IOException {
        LdapImportUtil.initControl(info, "UPD");
        int i = 0;
        ArrayList<ModificationItem> modificationAy = new ArrayList<ModificationItem>();
        this.ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        this.person = this.ldapControlInfo.getParent();
        if (this.person != null && this.person.toString().length() != 0) {
            modificationAy.add(new ModificationItem(2, new BasicAttribute(this.person.toString(), LdapImportUtil.initDN(addType, map, true))));
            ++i;
        }
        this.tempit = this.ldapControlInfo.getMapValue().iterator();
        String ldapProName = null;
        while (this.tempit.hasNext()) {
            this.ldapEasInfo = (LdapEasInfo)this.tempit.next();
            this.easPro = this.ldapEasInfo.getKeyValue();
            ldapProName = this.ldapEasInfo.getKeyName();
            this.ldapPro = this.ldapEasInfo.getKeyName();
            this.relativelyName = this.ldapControlInfo.getEasRelativelyName();
            Object obValue = map.get(this.easPro);
            if (obValue instanceof ArrayList) {
                BasicAttribute uniquememberSet = this.initMoreBasicAttribute(ctx, obValue, this.ldapKeyName);
                if (uniquememberSet.size() == 0) continue;
                for (int k = 0; k < uniquememberSet.size(); ++k) {
                    try {
                        modificationAy.add(new ModificationItem(1, new BasicAttribute(ldapProName, uniquememberSet.get(k).toString())));
                    }
                    catch (NamingException e) {
                        this.logger.info((Object)("ldap more value:" + e));
                    }
                    ++i;
                }
                modificationAy.add(new ModificationItem(3, new BasicAttribute(ldapProName)));
                ++i;
                continue;
            }
            this.ldapValue = LdapImportLanguageUtil.getInfoValue(this.easPro, obValue);
            if (this.ldapValue == null || StringUtils.isEmpty((String)this.ldapValue.toString())) continue;
            if (this.easPro.toString().equals(this.ldapControlInfo.getEasRelativelyName().toString())) {
                this.newDN = LdapImportUtil.initDN(addType, map, false);
                continue;
            }
            modificationAy.add(new ModificationItem(2, new BasicAttribute(ldapProName, this.ldapValue)));
            ++i;
        }
        this.dnStr = oldDN;
        this.modificationItem = new ModificationItem[i];
        Iterator it = modificationAy.iterator();
        while (it.hasNext()) {
            this.modificationItem[--i] = (ModificationItem)it.next();
            if (i != 0) continue;
            break;
        }
    }

    private BasicAttribute initMoreBasicAttribute(Context ctx, Object ob, String ldapKeyName) {
        BasicAttribute uniquememberSet = new BasicAttribute(ldapKeyName);
        Iterator itMore = ((List)ob).iterator();
        while (itMore.hasNext()) {
            List listMoreDn = null;
            try {
                listMoreDn = LdapEntryFacadeFactory.getLocalInstance(ctx).idToDN(itMore.next().toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (listMoreDn == null || listMoreDn.size() == 0) continue;
            Iterator itMoreDn = listMoreDn.iterator();
            while (itMoreDn.hasNext()) {
                uniquememberSet.add(itMoreDn.next().toString());
            }
        }
        return uniquememberSet;
    }

    public void ldapUpdEntry(LdapEntryInfo info) throws NamingException {
        try {
            this.logger.info((Object)("ldap control dn " + this.dnStr));
            this.logger.info((Object)("ldap control newDN " + this.newDN));
            this.ldapLookUp(info, false);
            if (this.modificationItem.length != 0) {
                this.dirCtx.modifyAttributes(this.dnStr, this.modificationItem);
            }
            if (this.newDN != null && this.newDN.length() != 0) {
                this.dirCtx.rename(this.dnStr, this.newDN);
            }
        }
        catch (NamingException e) {
            if (e.getMessage().indexOf("LDAP: error code 67") != -1) {
                LdapImportUtil.initException(info, "ldap\u4fee\u6539RDN\u5f02\u5e38\uff01");
            } else if (info.getException() == null) {
                LdapImportUtil.initException(info, "ldap\u4fee\u6539\u5f02\u5e38\uff01");
            }
            this.logger.info((Object)("ldap Exception in update():" + e));
            throw e;
        }
    }

    public void ldapDelEntry(LdapEntryInfo info, String strDelDN) throws NamingException, UserSyncConfigParseException, IOException {
        this.dnStr = strDelDN;
        try {
            this.ldapLookUp(info, false);
            this.dirCtx.destroySubcontext(this.dnStr);
        }
        catch (NamingException e) {
            if (e.getMessage().indexOf("LDAP: error code 67") != -1) {
                LdapImportUtil.initException(info, "ldap\u5220\u9664RDN\u5f02\u5e38\uff01");
            } else if (info.getException() == null) {
                LdapImportUtil.initException(info, "ldap\u5220\u9664\u5f02\u5e38\uff01");
            }
            throw e;
        }
    }

    private void ldapLookUp(LdapEntryInfo info, boolean isNull) throws NamingException {
        boolean isTN = false;
        try {
            this.dirCtx.lookup(this.dnStr);
            isTN = true;
        }
        catch (NamingException e) {
            isTN = false;
        }
        if (isNull) {
            if (isTN) {
                LdapImportUtil.initException(info, "ldap\u670d\u52a1\u5668Entry\u6761\u76ee\u5df2\u5b58\u5728\uff01");
                throw new NamingException("ldap\u670d\u52a1\u5668Entry\u6761\u76ee\u5df2\u5b58\u5728\uff01");
            }
        } else if (!isTN) {
            LdapImportUtil.initException(info, "ldap\u670d\u52a1\u5668Entry\u6761\u76ee\u4e0d\u5b58\u5728\uff01");
            throw new NamingException("ldap\u670d\u52a1\u5668Entry\u6761\u76ee\u4e0d\u5b58\u5728\uff01");
        }
    }

    public void initOrgunitAtt() {
        ArrayList<LdapEasInfo> ay = new ArrayList<LdapEasInfo>();
        Map.Entry entry = null;
        Iterator it1 = null;
        try {
            it1 = LdapConfigManagerUtil.init().getReadXMLStartRootNode().entrySet().iterator();
        }
        catch (UserSyncConfigParseException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Iterator it = null;
        while (it1.hasNext()) {
            entry = it1.next();
            if (!entry.getKey().equals("orgunit")) continue;
            LdapControlInfo result = (LdapControlInfo)entry.getValue();
            this.setLdapKey(result.getRelativelyName());
            this.setBaseDN(result.getDn());
            this.setEasKey(result.getEasRelativelyName());
            for (LdapEasInfo ldapEasInfo : result.getMapValue()) {
                ay.add(ldapEasInfo);
            }
        }
        this.setEntryAtt(ay);
    }

    public void orgunitHandle() {
    }

    public Object orgunitEntrySelect(String name, String oldDn) {
        ArrayList ay = this.getEntryAtt();
        String[] attrNames = new String[ay.size()];
        for (int i = 0; i < ay.size(); ++i) {
            attrNames[i] = ((LdapEasInfo)ay.get(i)).getKeyName();
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(0L);
        searchControls.setReturningAttributes(attrNames);
        searchControls.setSearchScope(2);
        try {
            this.namingEnum = this.dirCtx.search(oldDn, "(objectClass=organizationalUnit)", searchControls);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return this.namingEnum;
    }

    public ArrayList getEntryAtt() {
        return this.entryAtt;
    }

    public void setEntryAtt(ArrayList entryAtt) {
        this.entryAtt = entryAtt;
    }

    public String getLdapKey() {
        return this.ldapKey;
    }

    public void setLdapKey(String ldapKey) {
        this.ldapKey = ldapKey;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getEasKey() {
        return this.easKey;
    }

    public void setEasKey(String easKey) {
        this.easKey = easKey;
    }
}

