/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.PortalUserConvertor;
import com.kingdee.eas.cp.common.web.util.WebContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;

public class EASRequestWrapper
extends HttpServletRequestWrapper {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.auth.client.EASRequestWrapper");
    private boolean wrapLiferayRequest = false;

    public EASRequestWrapper(HttpServletRequest request) {
        this(request, false);
    }

    public EASRequestWrapper(HttpServletRequest request, boolean isRequestForLiferay) {
        super(request);
        this.wrapLiferayRequest = isRequestForLiferay;
        this.logger.debug((Object)"[EAS Portal]wrapping an HttpServletRequest in a EASRequestWrapper.");
    }

    public EASRequestWrapper(HttpServletRequest request, WebContext ctx) {
        this(request, ctx, false);
    }

    public EASRequestWrapper(HttpServletRequest request, WebContext ctx, boolean isRequestForLiferay) {
        super(request);
        request.getSession().setAttribute("UserContext", (Object)ctx.getEasContext());
        request.getSession().setAttribute("easWebContextSessionId", (Object)ctx);
        this.wrapLiferayRequest = isRequestForLiferay;
        this.logger.debug((Object)("[EAS Portal]wrapping an HttpServletRequest with EAS user context in a EASRequestWrapper, isRequestForLiferay = " + String.valueOf(isRequestForLiferay)));
    }

    public String getRemoteUser() {
        String user = null;
        Context ctx = (Context)this.getSession().getAttribute("UserContext");
        if (ctx != null) {
            user = ctx.getUserName();
            if (this.wrapLiferayRequest) {
                user = PortalUserConvertor.getLiferayUser((String)user, (String)ctx.getAIS());
            }
        }
        this.logger.debug((Object)("getRemoteUser() returning [" + user + "]"));
        return user;
    }
}

