/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.eas.base.permission.IUserFacade;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.PortalPersonalSetUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.External2EasUsersFacadeFactory;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.cache.SSOCacheResource;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EASWebContextUtil {
    private static Logger logger = Logger.getLogger(EASWebContextUtil.class);

    public static void createWebContext(HttpServletRequest request, EASCredentials easCredentials) {
        try {
            Context ctx = EASLoginHandler.getContextBySessionID(easCredentials.getEasSessionId());
            if (ctx == null) {
                ctx = EASLoginHandler.loginByLtpaToken(easCredentials.getUsername(), easCredentials);
            }
            String number = easCredentials.getUsername();
            number = EASWebContextUtil.getloginUserNumber(number);
            ctx.setUserName(number);
            EASWebContextUtil.addUserInfo(ctx);
            request.setAttribute("isPureWeb", (Object)easCredentials.getIsPureWeb());
            ctx.setClientHostIP(EASWebContextUtil.getClientHostIP(request));
            ctx.setClientHostName(EASWebContextUtil.getClientHostIP(request));
            ctx.put((Object)EASCredentials.ENCRYPT_PASSWORD_KEY, (Object)easCredentials.getEncryptPassword());
            WebContextUtil.createWebContext((HttpServletRequest)request, (Context)ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static String getClientHostIP(HttpServletRequest request) {
        String napClientIP = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)napClientIP)) {
            return request.getRemoteAddr();
        }
        return napClientIP;
    }

    private static String getloginUserNumber(String number) {
        String isMapping = System.getProperty("sso.user.mapping");
        if (isMapping != null && "true".equalsIgnoreCase(isMapping.trim())) {
            boolean isUseExternalUser = false;
            String isUseExternalUserStr = System.getProperty("sso.user.useExternalUser");
            if (isUseExternalUserStr != null) {
                isUseExternalUser = "true".equalsIgnoreCase(isUseExternalUserStr.trim());
            }
            String easUserNumber = null;
            try {
                easUserNumber = External2EasUsersFacadeFactory.getRemoteInstance().getEasUsername(number, !isUseExternalUser);
                if (StringUtil.isEmptyString((String)easUserNumber)) {
                    easUserNumber = External2EasUsersFacadeFactory.getRemoteInstance().getEasUsername(number, isUseExternalUser);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (!StringUtil.isEmptyString((String)easUserNumber)) {
                number = easUserNumber;
            }
        }
        return number;
    }

    private static UserInfo getUserInfo(Context context, String userNumber) throws EASBizException {
        try {
            IUserFacade userFacade = UserFacadeFactory.getRemoteInstance();
            return userFacade.getUserInfo4LoinModule(userNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addUserInfo(Context ctx) throws BOSException, EASBizException, UserException {
        long start = System.currentTimeMillis();
        ctx.setCaller((IObjectPK)new ObjectUuidPK());
        String usernumber = ctx.getUserName();
        UserInfo userInfo = EASWebContextUtil.getUserInfo(ctx, usernumber);
        if (userInfo == null) {
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
        if (userInfo.getDefOrgUnit() == null) {
            throw new UserException(UserException.USER_HAS_NOT_DEF_ORG);
        }
        if (userInfo.getDefOrgUnit() != null && !ToolUtils.isCanBeDefOrg((FullOrgUnitInfo)userInfo.getDefOrgUnit())) {
            throw new UserException(UserException.DEF_ORG_IS_BAD);
        }
        if (userInfo.getCU() == null || StringUtils.isEmpty((String)userInfo.getCU().getNumber())) {
            throw new UserException(UserException.CTRL_UNIT_ERROR);
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ctx.setCaller((IObjectPK)userPK);
        ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
        ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo.getCU());
        System.out.println("sso client service [eas portal] construct web context(add userInfo) spend:" + (System.currentTimeMillis() - start));
    }

    public static void initRpcConfig(Context ctx) {
        String sessionid = ctx.getContextID();
        EASWebContextUtil.initRpcInnerConfig(ctx, sessionid);
    }

    public static void initRpcInnerConfig(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        String rpcUrl = "";
        ConfigurationItem configItem = PortalConfig.getConfigurationItem((String)"rpcUrl");
        if (configItem != null) {
            rpcUrl = configItem.getProperty("rpcUrl");
        }
        if (!StringUtils.isEmpty((String)rpcUrl)) {
            envContext.put("URL", rpcUrl);
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && "apusic".equalsIgnoreCase(serverType)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", "tcp://127.0.0.1:" + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
            System.setProperty("remoteMode", "false");
        } else {
            envContext.put("SESSIONID", sessionid);
            System.setProperty("remoteMode", "true");
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }

    public static String render(HttpServletRequest request, String resName) {
        if (!StringUtils.isEmpty((String)resName) && resName.indexOf("/easWebClient/personalset") > -1) {
            return resName + "?v=" + PortalPersonalSetUtil.getReloadTimeMark();
        }
        StringBuffer buf = new StringBuffer(WebContextUtil.getPortalContextPath((HttpServletRequest)request));
        buf.append(SSOCacheResource.getInstance().getRenderName(resName, false));
        return buf.toString();
    }

    private static boolean isGZipSupport(HttpServletRequest request) {
        String encodingString = request.getHeader("Accept-Encoding");
        return encodingString != null && encodingString.indexOf("gzip") != -1;
    }

    public static String renderSkin(HttpServletRequest request, String resName) {
        String ctxPath = WebContextUtil.getPortalContextPath((HttpServletRequest)request);
        if (!resName.startsWith("/")) {
            resName = "/" + resName;
        }
        StringBuffer buf = new StringBuffer(ctxPath);
        String skinPath = WebContextUtil.getUserSkinPath((HttpServletRequest)request);
        buf.append(SSOCacheResource.getInstance().getRenderName(skinPath.substring(ctxPath.length()) + resName, EASWebContextUtil.isGZipSupport(request)));
        return buf.toString();
    }
}

