/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.eas.base.security.machinecode.MachineCodeDBUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.qrcode.QrTokenOpenIdManager;
import com.kingdee.eas.cp.eip.sso.util.EASWebContextUtil;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class LoginUtil {
    private static Logger logger = Logger.getLogger(LoginUtil.class);

    public static Context createEasContext(String userName, Map attributes, HttpServletRequest request) {
        Context userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (userCtx == null) {
            Context ctx = EASLoginHandler.getContextBySessionID((String)attributes.get("easSessionId"));
            try {
                if (ctx == null) {
                    ctx = LoginUtil.login(userName, null, attributes);
                }
                EASWebContextUtil.addUserInfo(ctx);
                request.setAttribute("isPureWeb", attributes.get("isPureWeb"));
                ctx.setClientHostIP(LoginUtil.getClientHostIP(request));
                ctx.setClientHostName(LoginUtil.getClientHostIP(request));
                ctx.put((Object)EASCredentials.ENCRYPT_PASSWORD_KEY, attributes.get(EASCredentials.ENCRYPT_PASSWORD_KEY));
                WebContextUtil.createWebContext((HttpServletRequest)request, (Context)ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
        return userCtx;
    }

    public static Context login(String userName, String password, Map attributes) throws BOSLoginException {
        LoginContext loginCxt = LoginUtil.createLoginContext(userName, password, attributes);
        Context ctx = LoginUtil.createEASContext(loginCxt);
        ctx = password == null ? LoginUtil.loginByLtpaToken(userName, loginCxt, ctx) : LoginUtil.login(loginCxt, ctx);
        return ctx;
    }

    private static LoginContext createLoginContext(String userName, String password, Map attributes) throws BOSLoginException {
        String authPattern;
        String easSessionID;
        String slnName = (String)attributes.get("solutionName");
        String dataCenter = (String)attributes.get("dataCenter");
        String localeStr = (String)attributes.get("locale");
        Locale locale = new Locale(localeStr);
        String encodedPwd = "";
        if (password != null) {
            encodedPwd = LoginUtil.encodePassword(userName, password);
        }
        LoginContext ctx = new LoginContext(userName, encodedPwd, slnName, dataCenter, locale);
        ctx.setLoginType(LoginType.PORTAL);
        ctx.put("Password", (Object)encodedPwd);
        String encryptPassword = (String)attributes.get(EASCredentials.ENCRYPT_PASSWORD_KEY);
        if (encryptPassword != null && encryptPassword.trim().length() > 0) {
            ctx.put(EASCredentials.ENCRYPT_PASSWORD_KEY, (Object)encryptPassword);
        }
        if ((easSessionID = (String)attributes.get("easSessionID")) != null && easSessionID.trim().length() > 0) {
            ctx.setContextID(easSessionID);
        }
        if ((authPattern = (String)attributes.get("userAuthPattern")) != null && authPattern.trim().length() > 0) {
            ctx.put("UserAuthPattern", (Object)authPattern);
        }
        String loginFlow = (String)attributes.get("loginFlow");
        boolean isNewLoginFlow = false;
        isNewLoginFlow = "oncerpc".equalsIgnoreCase(loginFlow);
        ctx.put("SwitchToNewLoginFlow", (Object)Boolean.toString(isNewLoginFlow));
        return ctx;
    }

    private static Context createEASContext(LoginContext loginCtx) {
        Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
        Iterator it = loginCtx.items.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            userContext.put(entry.getKey(), entry.getValue());
        }
        return userContext;
    }

    private static Context loginByLtpaToken(String userName, LoginContext loginCtx, Context easContext) {
        Context ctx = null;
        try {
            String sessionId = Uuid.create().toString();
            LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
            String usrPass = token.toString();
            String encodePwd = LoginUtil.encodePassword(userName, usrPass);
            loginCtx.setUserPass(encodePwd);
            loginCtx.put("Password", (Object)encodePwd);
            loginCtx.setContextID(sessionId);
            loginCtx.put("UserAuthPattern", (Object)"BaseTrdLtpaToken");
            ctx = LoginUtil.login(loginCtx, easContext);
        }
        catch (Exception e) {
            logger.error((Object)"LoginUtil loginByLtpaToken error");
            e.printStackTrace();
        }
        return ctx;
    }

    private static Context login(LoginContext loginCxt, Context easContext) throws BOSLoginException {
        LoginUtil.initRpcConfig(easContext, easContext.getContextID());
        Context ctx = null;
        try {
            ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
            ctx = loginModule.fullLogin(loginCxt);
        }
        catch (Exception e) {
            logger.error((Object)"LoginUtil login error");
            e.printStackTrace();
        }
        return ctx;
    }

    private static final String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            e.printStackTrace();
        }
        return encodedPassword;
    }

    private static Context getContextBySessionID(String sessionid) {
        ILoginModule loginModule = null;
        Context ctx = null;
        try {
            if ("true".equals(System.getProperty("remoteMode"))) {
                LoginUtil.initRpcConfig(ctx, sessionid);
                loginModule = LoginModuleFactory.getRemoteInstance();
                ctx = loginModule.getContextBySessionID(sessionid);
            } else {
                loginModule = LoginModuleFactory.getLocalInstance(null);
                ctx = loginModule.getContextBySessionID(sessionid);
                LoginUtil.initRpcConfig(ctx, sessionid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ctx;
    }

    public static void initRpcConfig(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        String rpcUrl = "";
        ConfigurationItem configItem = PortalConfig.getConfigurationItem((String)"rpcUrl");
        if (configItem != null) {
            rpcUrl = configItem.getProperty("rpcUrl");
        }
        if (!StringUtils.isEmpty((String)rpcUrl)) {
            envContext.put("URL", rpcUrl);
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && "apusic".equalsIgnoreCase(serverType)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", "tcp://127.0.0.1:" + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
            System.setProperty("remoteMode", "false");
        } else {
            envContext.put("SESSIONID", sessionid);
            System.setProperty("remoteMode", "true");
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }

    private static String getClientHostIP(HttpServletRequest request) {
        String napClientIP = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)napClientIP)) {
            return request.getRemoteAddr();
        }
        return napClientIP;
    }

    public static String findBackgroundShowType(String dataCenter, String lang) {
        String bgShowType = "PART_BG;PART_BG;PART_BG";
        if (StringUtils.isEmpty((String)dataCenter)) {
            return bgShowType;
        }
        try {
            Context context = QrTokenOpenIdManager.getContext((String)dataCenter, (String)lang);
            String permSql = "select FConfigValue from T_JP_PortalProfile where FConfigItem = 'default_background_show'";
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql);
            if (rs != null && rs.next()) {
                bgShowType = rs.getString("FConfigValue");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Find BgShowType Error!");
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)bgShowType)) {
            bgShowType = "PART_BG;PART_BG;PART_BG";
        }
        return bgShowType;
    }

    public static boolean getMachineCodeAuthState(String dataCenter, String lang) {
        if (StringUtils.isEmpty((String)dataCenter)) {
            return false;
        }
        Context context = QrTokenOpenIdManager.getContext((String)dataCenter, (String)lang);
        boolean machineCodeAuthState = MachineCodeDBUtil.getMachineCodeAuthState((Context)context);
        return machineCodeAuthState;
    }
}

