/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.cache.resource;

import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSODefaultResourceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SSODefaultResourceLoader {
    protected static final Logger log = Logger.getLogger(SSODefaultResourceLoader.class);
    private static long lastModified = 0L;

    private static long getLastModified() {
        if (lastModified == 0L) {
            String format = "yyyy-MM-dd HH:mm:ss Z";
            String sLastModified = "";
            try {
                lastModified = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(sLastModified).getTime();
            }
            catch (ParseException e) {
                lastModified = new Date().getTime();
                log.warn((Object)("Unparsable lastModified : " + sLastModified));
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        String resource = resourceUri;
        try (InputStream is = null;){
            SSODefaultResourceProvider resourceProvider = new SSODefaultResourceProvider(resourceUri);
            resource = resourceProvider.getUrl().getFile();
            if (!resourceProvider.exists(context, resource)) {
                response.sendError(404, "Unable to find resource " + resource + ". Check that this file is available in the classpath in sub-directory /resource of the package-directory.");
                log.error((Object)("Unable to find resource " + resource + ". Check that this file is available in the classpath in sub-directory /resource of the package-directory."));
            } else {
                long browserDate;
                long lastModified = resourceProvider.getLastModified(context, resource);
                if (lastModified < 1L) {
                    lastModified = SSODefaultResourceLoader.getLastModified();
                }
                if ((browserDate = request.getDateHeader("If-Modified-Since")) > -1L && (lastModified = lastModified / 1000L * 1000L) == (browserDate = browserDate / 1000L * 1000L)) {
                    response.setStatus(304);
                    return;
                }
                int contentLength = resourceProvider.getContentLength(context, resource);
                String contentEncoding = resourceProvider.getEncoding(context, resource);
                is = resourceProvider.getInputStream(context, resource);
                this.defineContentHeaders(request, response, resource, contentLength, contentEncoding);
                this.defineCaching(request, response, resource, lastModified);
                this.writeResource(request, response, is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResource(HttpServletRequest request, HttpServletResponse response, InputStream in) throws IOException {
        try (ServletOutputStream out = response.getOutputStream();){
            byte[] buffer = new byte[1024];
            int size = in.read(buffer);
            while (size != -1) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
    }

    protected void defineCaching(HttpServletRequest request, HttpServletResponse response, String resource, long lastModified) {
        response.setDateHeader("Last-Modified", lastModified);
        Calendar expires = Calendar.getInstance();
        expires.add(6, 7);
        response.setDateHeader("Expires", expires.getTimeInMillis());
        response.setHeader("Cache-Control", "max-age=43200");
        response.setHeader("Pragma", "");
    }

    protected void defineContentHeaders(HttpServletRequest request, HttpServletResponse response, String resource, int contentLength, String contentEncoding) {
        if (contentLength > -1) {
            response.setContentLength(contentLength);
        }
        if (resource.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (resource.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".htc")) {
            response.setContentType("text/x-component");
        } else if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (resource.endsWith(".jpg") || resource.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (resource.endsWith(".xml") || resource.endsWith(".xsl")) {
            response.setContentType("text/xml");
        }
        if (resource.endsWith(".gz")) {
            response.setHeader("Content-Encoding", "gzip");
            resource = resource.substring(0, resource.length() - 3);
            String type = request.getSession().getServletContext().getMimeType(resource);
            if (type == null) {
                type = "application/octet-stream";
            }
            response.setContentType(type);
        }
    }
}

