/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.cache.resource;

import com.kingdee.eas.cp.eip.sso.web.cache.resource.ISSODirContext;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOBaseDirContext;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOCacheEntry;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOResource;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOResourceAttributes;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOResourceCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;

public class SSOProxyDirContext
implements ISSODirContext {
    protected SSOProxyDirContext proxy = this;
    protected Hashtable env;
    protected ISSODirContext dirContext;
    protected String vPath = null;
    protected String hostName;
    protected String contextName;
    protected SSOResourceCache cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 512;

    public SSOProxyDirContext(ISSODirContext dirContext) {
        SSOBaseDirContext baseDirContext;
        this.dirContext = dirContext;
        if (dirContext instanceof SSOBaseDirContext && (baseDirContext = (SSOBaseDirContext)dirContext).isCached()) {
            try {
                this.cache = new SSOResourceCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cache.setCacheMaxSize(baseDirContext.getCacheMaxSize());
            this.cacheTTL = baseDirContext.getCacheTTL();
            this.cacheObjectMaxSize = baseDirContext.getCacheMaxSize() / 20;
        }
    }

    public SSOResourceCache getCache() {
        return this.cache;
    }

    public ISSODirContext getDirContext() {
        return this.dirContext;
    }

    public String getDocBase() {
        if (this.dirContext instanceof SSOBaseDirContext) {
            return ((SSOBaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        SSOCacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw new NamingException(name + " entry is not exist.");
            }
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new SSOResource((InputStream)object);
        }
        if (object instanceof ISSODirContext) {
            return object;
        }
        if (object instanceof SSOResource) {
            return object;
        }
        return new SSOResource(new ByteArrayInputStream(object.toString().getBytes()));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name);
    }

    @Override
    public List list(String name) throws NamingException {
        return this.dirContext.list(name);
    }

    @Override
    public SSOResourceAttributes getAttributes(String name) throws NamingException {
        SSOCacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw new NamingException(name + " entry is not exist.");
            }
            return entry.attributes;
        }
        return this.dirContext.getAttributes(name);
    }

    public SSOCacheEntry lookupCache(String name) {
        SSOCacheEntry entry = this.cacheLookup(name);
        if (entry == null) {
            entry = new SSOCacheEntry();
            entry.name = name;
            try {
                Object object = this.dirContext.lookup(this.parseName(name));
                if (object instanceof InputStream) {
                    entry.resource = new SSOResource((InputStream)object);
                } else if (object instanceof ISSODirContext) {
                    entry.context = (ISSODirContext)object;
                } else {
                    entry.resource = object instanceof SSOResource ? (SSOResource)object : new SSOResource(new ByteArrayInputStream(object.toString().getBytes()));
                }
                entry.attributes = this.dirContext.getAttributes(name);
            }
            catch (NamingException e) {
                entry.exists = false;
            }
        }
        return entry;
    }

    protected String parseName(String name) throws NamingException {
        return name;
    }

    protected SSOCacheEntry cacheLookup(String name) {
        SSOCacheEntry cacheEntry;
        if (this.cache == null) {
            return null;
        }
        if (name == null) {
            name = "";
        }
        if ((cacheEntry = this.cache.lookup(name)) == null) {
            cacheEntry = new SSOCacheEntry();
            cacheEntry.name = name;
            this.cacheLoad(cacheEntry);
        } else {
            if (!this.validate(cacheEntry)) {
                if (!this.revalidate(cacheEntry)) {
                    this.cacheUnload(cacheEntry.name);
                    return null;
                }
                cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
            }
            ++cacheEntry.accessCount;
        }
        return cacheEntry;
    }

    protected boolean validate(SSOCacheEntry entry) {
        return (!entry.exists || entry.context != null || entry.resource != null && entry.resource.getContent() != null) && System.currentTimeMillis() < entry.timestamp;
    }

    protected boolean revalidate(SSOCacheEntry entry) {
        if (!entry.exists) {
            return false;
        }
        if (entry.attributes == null) {
            return false;
        }
        long lastModified = entry.attributes.getLastModified();
        long contentLength = entry.attributes.getContentLength();
        if (lastModified <= 0L) {
            return false;
        }
        try {
            SSOResourceAttributes attributes = this.dirContext.getAttributes(entry.name);
            long lastModified2 = attributes.getLastModified();
            long contentLength2 = attributes.getContentLength();
            return lastModified == lastModified2 && contentLength == contentLength2;
        }
        catch (NamingException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoad(SSOCacheEntry entry) {
        String name = entry.name;
        boolean exists = true;
        if (entry.attributes == null) {
            try {
                entry.attributes = this.dirContext.getAttributes(entry.name);
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource == null && entry.context == null) {
            try {
                Object object = this.dirContext.lookup(name);
                if (object instanceof InputStream) {
                    entry.resource = new SSOResource((InputStream)object);
                } else if (object instanceof ISSODirContext) {
                    entry.context = (ISSODirContext)object;
                } else {
                    entry.resource = object instanceof SSOResource ? (SSOResource)object : new SSOResource(new ByteArrayInputStream(object.toString().getBytes()));
                }
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource != null && entry.resource.getContent() == null && entry.attributes.getContentLength() >= 0L && entry.attributes.getContentLength() < (long)(this.cacheObjectMaxSize * 1024)) {
            int length = (int)entry.attributes.getContentLength();
            entry.size = (int)((long)entry.size + entry.attributes.getContentLength() / 1024L);
            InputStream is = null;
            try {
                int n;
                is = entry.resource.streamContent();
                byte[] b = new byte[length];
                for (int pos = 0; pos < length && (n = is.read(b, pos, length - pos)) >= 0; pos += n) {
                }
                entry.resource.setContent(b);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        entry.exists = exists;
        entry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        SSOResourceCache sSOResourceCache = this.cache;
        synchronized (sSOResourceCache) {
            if (this.cache.lookup(name) == null && this.cache.allocate(entry.size)) {
                this.cache.load(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheUnload(String name) {
        if (this.cache == null) {
            return false;
        }
        SSOResourceCache sSOResourceCache = this.cache;
        synchronized (sSOResourceCache) {
            return this.cache.unload(name);
        }
    }
}

