/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.web.EASCallbackHandlerForCas3;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EASLoginHandler {
    private static Logger logger = Logger.getLogger(EASLoginHandler.class);

    public static Context login(LoginContext loginCxt, Context userCxt) throws BOSLoginException {
        EASLoginHandler.initRpcConfig(userCxt, userCxt.getContextID());
        Context ctx = null;
        try {
            ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
            ctx = loginModule.fullLogin(loginCxt);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return ctx;
    }

    public static Context loginByLtpaToken(String userName, EASCredentials easCredentials) {
        EASCallbackHandlerForCas3 easchb = new EASCallbackHandlerForCas3();
        Context ctx = null;
        try {
            String sessionId = Uuid.create().toString();
            easCredentials.setEasSessionId(sessionId);
            easchb.createCallbackHandler(easCredentials);
            LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
            String usrPass = token.toString();
            String encodePwd = easchb.encodePassword(userName, usrPass);
            LoginContext loginCtx = easchb.getLoginContext();
            loginCtx.setUserPass(encodePwd);
            loginCtx.put("Password", (Object)encodePwd);
            loginCtx.setContextID(sessionId);
            loginCtx.put("UserAuthPattern", (Object)"BaseTrdLtpaToken");
            ctx = EASLoginHandler.login(easchb.getLoginContext(), easchb.getUserContext());
        }
        catch (BOSLoginException e) {
            logger.error((Object)e);
        }
        return ctx;
    }

    public static Context getContextBySessionID(String sessionid) {
        ILoginModule loginModule = null;
        Context ctx = null;
        try {
            if ("true".equals(System.getProperty("remoteMode"))) {
                EASLoginHandler.initRpcConfig(ctx, sessionid);
                loginModule = LoginModuleFactory.getRemoteInstance();
                ctx = loginModule.getContextBySessionID(sessionid);
            } else {
                loginModule = LoginModuleFactory.getLocalInstance(null);
                ctx = loginModule.getContextBySessionID(sessionid);
                EASLoginHandler.initRpcConfig(ctx, sessionid);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return ctx;
    }

    public static void initRpcConfig(Context ctx) {
        EASLoginHandler.initRpcConfig(ctx, ctx.getContextID());
    }

    public static void initRpcConfig(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        logger.info((Object)("-----portal--initRpcConfig----sessionid-----" + sessionid));
        String rpcUrl = "";
        ConfigurationItem configItem = PortalConfig.getConfigurationItem((String)"rpcUrl");
        if (configItem != null) {
            rpcUrl = configItem.getProperty("rpcUrl");
        }
        if (!StringUtils.isEmpty((String)rpcUrl)) {
            envContext.put("URL", rpcUrl);
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && "apusic".equalsIgnoreCase(serverType)) {
                logger.info((Object)"--PORTAL--:appserver_type:apusic");
                envContext.put("URL", "[LOCAL]");
            } else {
                logger.info((Object)("--PORTAL--:appserver_type:" + serverType));
                logger.info((Object)("-----portal--rpcUrl----tcp://127.0.0.1:" + ORMRPConfig.getTcpConnectionPort()));
                envContext.put("URL", "tcp://127.0.0.1:" + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
            System.setProperty("remoteMode", "false");
        } else {
            envContext.put("SESSIONID", sessionid);
            System.setProperty("remoteMode", "true");
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }
}

