/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.util.PrivacyProtectUtil;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.cp.eip.sso.web.validatecode.DynamicPasswordUtil;
import com.kingdee.eas.cp.eip.sso.web.validatecode.SMSValidataCodeUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SecondAuthentication
extends AbstractAction {
    protected Event doExecute(RequestContext context) throws Exception {
        EASCredentials credentials = (EASCredentials)context.getConversationScope().get("secondAuthContext");
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        request.getSession().setAttribute("secondAuthContext", (Object)credentials);
        Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
        boolean enableSMSValidateCode = SMSValidataCodeUtil.isEnableSMSValidateCode(request);
        boolean enableNormalAndDynamic = DynamicPasswordUtil.isEnableNormalAndDynamic(request);
        if (enableSMSValidateCode || enableNormalAndDynamic) {
            request.setAttribute("phone", (Object)this.getCellOrPhone(ctx));
            return this.result("secondAuthenticationRequired");
        }
        return this.result("secondAuthenticationNotRequired");
    }

    private String getCellOrPhone(Context ctx) {
        String sql = "SELECT FID,FCELL,FEMAIL FROM T_PM_USER WHERE LOWER(FNUMBER)=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{ctx.getUserName().toLowerCase()});
            String cell = null;
            String email = null;
            if (rs.next()) {
                cell = rs.getString("FCELL");
                email = rs.getString("FEMAIL");
            }
            if (StringUtils.isEmpty(cell) && StringUtils.isEmpty(email)) {
                return ctx.getUserName();
            }
            if (StringUtils.isEmpty((String)cell)) {
                return PrivacyProtectUtil.hideEmailInfo(email);
            }
            return PrivacyProtectUtil.hidePhoneInfo(cell);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ctx.getUserName();
        }
    }
}

