/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.validatecode;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.SMSValidataUserManagerFactory;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SMSValidataCodeUtil {
    private static Logger logger = Logger.getLogger(SMSValidataCodeUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEnableSMSValidateCode(HttpServletRequest request) {
        String userNumber;
        EASCredentials credentials = (EASCredentials)request.getSession().getAttribute("secondAuthContext");
        String userAuthPattern = credentials.getUserAuthPattern();
        if ("Kingdee".equals(userAuthPattern)) return false;
        if ("QrCodeToken".equals(userAuthPattern)) return false;
        if ("BaseTrdLtpaToken".equals(userAuthPattern)) {
            return false;
        }
        Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
        if (!SMSValidataCodeUtil.isNeedShowByUserNumber(ctx, userNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber())) {
            return false;
        }
        boolean isEnableValidateCode = false;
        int errorCount = -1;
        Properties properties = null;
        try {
            properties = GlobleLoginConfigFactory.getLocalInstance().getBizConfig();
            if (properties == null) return false;
            String authType = properties.getProperty("authType");
            if (StringUtils.isEmpty((String)authType)) return false;
            if ("2".equals(authType)) {
                isEnableValidateCode = true;
                String errNum = properties.getProperty("errNum");
                if (!StringUtils.isEmpty((String)errNum)) {
                    errorCount = Integer.parseInt(errNum);
                }
            }
            if (!isEnableValidateCode) return false;
            if (errorCount < 0) {
                return true;
            }
            int sessionErrorCount = 0;
            Integer count = (Integer)request.getSession().getAttribute("login_failed_count");
            if (count != null) {
                sessionErrorCount = count;
            }
            if (sessionErrorCount - errorCount < 0) return false;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return isEnableValidateCode;
        }
    }

    private static boolean isNeedShowByUserNumber(Context ctx, String userNumber) {
        try {
            FilterInfo filter0 = new FilterInfo();
            filter0.getFilterItems().add(new FilterItemInfo("user.number", (Object)userNumber));
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("user.loginNumber", (Object)userNumber));
            filter0.mergeFilter(filter1, "or");
            if (SMSValidataUserManagerFactory.getLocalInstance((Context)ctx).exists(filter0)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }
}

