/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.DataCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetExpertBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Cstyle;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.StyleException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import java.util.ArrayList;

public class WorksheetStyleExpert
extends WorksheetExpertBase {
    private ArrayList cellStyles = new ArrayList();

    public WorksheetStyleExpert(WorksheetComponent wc) {
        super(wc);
    }

    public void addCellStylePattern(String stylePattern) {
        Cstyle style;
        try {
            style = Cstyle.apply(stylePattern);
        }
        catch (StyleException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)e.getMessage());
            }
            return;
        }
        this.cellStyles.add(style);
    }

    public void clear() {
        this.cellStyles.clear();
    }

    public void render(DataCellItem dci, ICell cell) {
        try {
            if (this.cellStyles.size() > 0) {
                dci.applyStyle(this.cellStyles.toArray(new Cstyle[0]), cell);
            }
        }
        catch (StyleException e) {
            this.getLogger().debug((Object)e);
        }
    }
}

