/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryAxisManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.ExprUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_QueryManager
extends QueryManager
implements QueryAxisChangeListener {
    static Logger logger = CommonLogger.getLogger(KDOLAP_QueryManager.class);
    private MdxQuery kdQuery = null;
    private MdxQuery cloneQuery = null;
    private final SchemaReader scr;
    private boolean firstExecute = true;

    KDOLAP_QueryManager(KDOLAP_Model model, MdxQuery kdQuery) {
        super(model);
        this.kdQuery = kdQuery;
        this.scr = model.getConnection().getSchemaReader();
        this.qams = new KDOLAP_QueryAxisManager[2];
        for (int i = 0; i < 2; ++i) {
            com.kingdee.bos.olap.Hierarchy[] kdHiers = kdQuery.getMdxHierarchiesOnAxis(i);
            this.qams[i] = new KDOLAP_QueryAxisManager(i, kdQuery.getAxes()[i], model);
            Hierarchy[] hiers = new Hierarchy[kdHiers.length];
            for (int j = 0; j < hiers.length; ++j) {
                hiers[j] = model.lookupHierarchy(kdHiers[j].getUniqueName());
            }
            this.qams[i].setHiers(hiers);
            this.qams[i].addChangeListener(this);
        }
    }

    public SchemaReader getSchemaReader() {
        return this.scr;
    }

    @Override
    public void queryAxisChanged(QueryAxisManager qam, Object source, boolean changedByNavi) {
        this.useQueryAxisManager = true;
    }

    public MdxQuery getKDQuery() {
        if (this.kdQuery != null) {
            return this.kdQuery;
        }
        try {
            KDOLAP_Model kdModel = (KDOLAP_Model)this.model;
            this.kdQuery = kdModel.getConnection().parseQuery(kdModel.getMdxQuery());
        }
        catch (OLAPException ex) {
            logger.fatal((Object)"getKDQuery parse error", (Throwable)ex);
        }
        return this.kdQuery;
    }

    public void setKDQuery(MdxQuery q) {
        this.kdQuery = q;
    }

    protected void onExecute() {
        if (this.useQueryAxisManager) {
            int iQueryAxisManagerToSort = -1;
            if (this.sortRank != null) {
                iQueryAxisManagerToSort = this.iASwap(this.sortRank.activeQueryAxisToSort());
            }
            for (int i = 0; i < this.qams.length; ++i) {
                if (this.qams[i].getPosTreeRoot() == null || !this.firstExecute && !this.qams[i].isChanged() && i != iQueryAxisManagerToSort) continue;
                boolean doHierarchize = false;
                if (this.qams[i].isHierarchizeNeeded() && i != iQueryAxisManagerToSort) {
                    doHierarchize = true;
                }
                this.kdQuery.getAxes()[this.iASwap(i)].setExp(this.qams[i].genExp(doHierarchize));
                this.qams[i].setChanged(false);
            }
        }
        if (!this.useQueryAxisManager) {
            if (this.cloneQuery == null) {
                if (this.filter.isFilterOnQuery() || this.sortRank.isSortOnQuery()) {
                    this.cloneQuery = (MdxQuery)this.kdQuery.clone();
                    this.cloneQuery.setConnection(this.kdQuery.getConnection());
                }
            } else if (this.filter.isFilterOnQuery() || this.sortRank.isSortOnQuery()) {
                this.kdQuery = (MdxQuery)this.cloneQuery.clone();
                this.kdQuery.setConnection(this.cloneQuery.getConnection());
            } else {
                this.kdQuery = this.cloneQuery;
            }
        }
        this.filter.addFilterToQuery();
        this.sortRank.addSortToQuery();
        String mdx = this.kdQuery.toMdx();
        ((KDOLAP_Model)this.model).setCurrentMdx(mdx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)mdx);
        }
        this.firstExecute = false;
    }

    protected String getCurrentMdx() {
        String mdx = this.kdQuery.toString();
        return mdx;
    }

    @Override
    protected Exp createMemberSet(List memList) {
        Exp[] exps = new Exp[memList.size()];
        int i = 0;
        for (KDOLAP_Member m : memList) {
            exps[i++] = ExprUtil.toExp((OLAPElement)m.getKDMember());
        }
        FunCall f = new FunCall("{}", exps, Syntax.Braces);
        return f;
    }

    @Override
    public boolean canExpand(Member member) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
        if (kdMember.isCalculated()) {
            return false;
        }
        if (!this.scr.isDrillable(kdMember)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canExpand(member);
    }

    @Override
    public boolean canExpand(Member[] pathMembers) {
        KDOLAP_Member m = (KDOLAP_Member)pathMembers[pathMembers.length - 1];
        com.kingdee.bos.olap.Member kdMember = m.getKDMember();
        if (kdMember.isCalculated()) {
            return false;
        }
        if (!this.scr.isDrillable(kdMember)) {
            return false;
        }
        Dimension dim = m.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canExpand(pathMembers);
    }

    @Override
    public boolean isExpanded(Member member) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
        if (kdMember.isCalculated()) {
            return false;
        }
        if (!this.scr.isDrillable(kdMember)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.isExpanded(member);
    }

    @Override
    public boolean canCollapse(Member member) {
        if (((KDOLAP_Member)member).getKDMember().isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canCollapse(member);
    }

    @Override
    public boolean canCollapse(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        if (((KDOLAP_Member)member).getKDMember().isCalculated()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canCollapse(pathMembers);
    }

    @Override
    public void expand(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("expand Member" + this.poString(null, member)));
        }
        if (!qam.canExpand(member)) {
            logger.fatal((Object)("Expand Member failed for" + ((KDOLAP_Member)member).getUniqueName()));
            return;
        }
        qam.expand(member);
        this.model.fireModelChanged();
    }

    @Override
    public void expand(Member[] pathMembers) {
        KDOLAP_Member m = (KDOLAP_Member)pathMembers[pathMembers.length - 1];
        Dimension dim = m.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("expand Path" + this.poString(pathMembers, null)));
        }
        if (!qam.canExpand(pathMembers)) {
            logger.fatal((Object)("Expand failed for" + this.poString(pathMembers, null)));
            return;
        }
        qam.expand(pathMembers);
        this.model.fireModelChanged();
    }

    @Override
    public boolean canDrillDown(Member member) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
        if (!this.scr.isDrillable(kdMember)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canDrillDown(member);
    }

    @Override
    public boolean canDrillDown(Level level) {
        Dimension dim = level.getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        return qam.canDrillDown(level);
    }

    public void setSwapAxes(boolean swap) {
        if (this.kdQuery.getAxes().length != 2) {
            return;
        }
        if (swap != this.axesSwapped) {
            this.kdQuery.swapAxes();
            if (this.cloneQuery != null && this.cloneQuery != this.kdQuery) {
                this.cloneQuery.swapAxes();
            }
            this.axesSwapped = swap;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("swapAxes " + this.axesSwapped));
            }
            this.model.fireModelChanged();
        }
    }
}

