/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.report.ui.ColumnFilter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.util.ArrayList;
import java.util.List;

class MemberColFilter
implements ColumnFilter {
    Hierarchy hierarchy = null;
    OlapModel olapModel = null;
    List memberList = null;
    KDPanel container = null;
    boolean[] selectedArray = null;
    boolean showAll = true;

    @Override
    public boolean checkSelectionNull() {
        if (this.isShowAll()) {
            return false;
        }
        return this.getCondition().equals("");
    }

    @Override
    public KDPanel getContainer() {
        return this.container;
    }

    @Override
    public boolean sameCol(Object obj) {
        if (obj instanceof MemberColFilter) {
            String uniqueName = ((MemberColFilter)obj).hierarchy.getUniqueName();
            return this.hierarchy.getUniqueName().equals(uniqueName);
        }
        return false;
    }

    @Override
    public Object clone() {
        MemberColFilter o = new MemberColFilter();
        o.hierarchy = this.hierarchy;
        o.olapModel = this.olapModel;
        o.container = this.container;
        o.memberList = new ArrayList(this.memberList);
        if (this.selectedArray != null) {
            o.selectedArray = (boolean[])this.selectedArray.clone();
        }
        o.showAll = this.showAll;
        return o;
    }

    @Override
    public boolean isShowAll() {
        return this.showAll;
    }

    @Override
    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    @Override
    public String getCondition() {
        String condition = "";
        if (this.selectedArray != null && this.selectedArray.length > 0) {
            boolean first = true;
            for (int i = 0; i < this.selectedArray.length; ++i) {
                if (!this.selectedArray[i]) continue;
                Member member = (Member)this.memberList.get(i);
                if (first) {
                    condition = condition + " " + this.hierarchy.getName() + ".CurrentMember=" + member.getUniqueName();
                    first = false;
                    continue;
                }
                condition = condition + " OR " + this.hierarchy.getName() + ".CurrentMember=" + member.getUniqueName();
            }
        }
        return condition;
    }

    public MemberColFilter(Hierarchy hierarchy, OlapModel olapModel, KDPanel container) {
        this.hierarchy = hierarchy;
        this.olapModel = olapModel;
        this.container = container;
        AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
        this.memberList = amh.findVisibleMembers(hierarchy);
        if (this.memberList.size() > 0) {
            this.selectedArray = new boolean[this.memberList.size()];
            for (int i = 0; i < this.memberList.size(); ++i) {
                this.selectedArray[i] = true;
            }
        }
    }

    public String toString() {
        String filterPrompt = "   ";
        if (!this.isShowAll()) {
            filterPrompt = "!  ";
        }
        return filterPrompt + this.hierarchy.toString();
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public List getMembers() {
        return this.memberList;
    }

    public boolean[] getSelected() {
        return this.selectedArray;
    }

    public boolean setSelected(int index, boolean selected) {
        boolean success = false;
        if (index >= 0 && index < this.selectedArray.length) {
            this.selectedArray[index] = selected;
            success = true;
        }
        return success;
    }

    private MemberColFilter() {
    }
}

