/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.util;

import com.kingdee.bos.ctrl.analysis.util.SoftException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil
implements Serializable {
    private static final long serialVersionUID = 6345585917729997334L;
    private static final Logger log = CommonLogger.getLogger(XmlUtil.class);
    private static final String WEBKEY = XmlUtil.class.getName();
    private Hashtable templatesCache = new Hashtable();

    private XmlUtil() {
    }

    public Transformer getTransformer(ServletContext ctx, String xslUri, boolean xslCache) {
        Hashtable hashtable = this.templatesCache;
        synchronized (hashtable) {
            try {
                Templates templates = null;
                if (xslCache) {
                    templates = (Templates)this.templatesCache.get(xslUri);
                }
                if (templates == null) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    tf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    URL url = ctx.getResource(xslUri);
                    if (url == null) {
                        throw new IllegalArgumentException("stylesheet \"" + xslUri + "\" not found");
                    }
                    StreamSource ss = new StreamSource(url.toExternalForm());
                    if ("file".equals(url.getProtocol())) {
                        File f = new File(url.getFile());
                        ss.setSystemId(f);
                    }
                    templates = tf.newTemplates(ss);
                    if (xslCache) {
                        this.templatesCache.put(xslUri, templates);
                    }
                }
                return templates.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new SoftException(e);
            }
            catch (MalformedURLException e) {
                throw new SoftException(e);
            }
        }
    }

    public static Transformer getTransformer(HttpSession session, String xslUri, boolean xslCache) {
        return XmlUtil.instance(session).getTransformer(session.getServletContext(), xslUri, xslCache);
    }

    public static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setValidating(false);
            dbf.setExpandEntityReferences(true);
            return dbf.newDocumentBuilder();
        }
        catch (FactoryConfigurationError e) {
            throw new SoftException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SoftException(e);
        }
    }

    public static Document createDocument() {
        try {
            return XmlUtil.getParser().newDocument();
        }
        catch (FactoryConfigurationError e) {
            throw new SoftException(e);
        }
    }

    public static void print(Node node, Writer out, Properties p) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DOMSource src = new DOMSource(node);
            StreamResult dest = new StreamResult(out);
            Transformer t = tf.newTransformer();
            if (p != null) {
                t.setOutputProperties(p);
            }
            t.transform(src, dest);
        }
        catch (TransformerConfigurationException e) {
            throw new SoftException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SoftException(e);
        }
        catch (TransformerException e) {
            throw new SoftException(e);
        }
    }

    public static void print(Node node, Writer out) {
        XmlUtil.print(node, out, null);
    }

    public static synchronized XmlUtil instance(HttpSession session) {
        XmlUtil service = (XmlUtil)session.getAttribute(WEBKEY);
        if (service == null) {
            service = new XmlUtil();
            session.setAttribute(WEBKEY, (Object)service);
        }
        return service;
    }

    public static Document getDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Document parse(URL url) {
        try {
            InputSource src = new InputSource(url.toExternalForm());
            return XmlUtil.getParser().parse(src);
        }
        catch (IOException e) {
            throw new SoftException(e);
        }
        catch (SAXException e) {
            throw new SoftException(e);
        }
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        char[] arr = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(arr[i]);
                }
            }
        }
        return sb.toString();
    }

    private static Node getCDataNode(Node dsElement) {
        NodeList nodeList = dsElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node nodeValue = list.item(j);
                if (nodeValue.getNodeType() != 4) continue;
                return nodeValue;
            }
        }
        return null;
    }

    public static String getNodeCDataTagname(Element dsElement) {
        Node node = XmlUtil.getCDataNode(dsElement);
        return node != null ? node.getParentNode().getNodeName() : "";
    }

    public static String getNodeCDataValue(Node dsElement) {
        Node node = XmlUtil.getCDataNode(dsElement);
        String value = node != null ? node.getNodeValue() : "";
        return value;
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        Node nodeAttr = node.getAttributes().getNamedItem(attributeName);
        if (nodeAttr == null) {
            return null;
        }
        return nodeAttr.getNodeValue();
    }

    public static String getNodeAttribute(Node node, String attributeName, String defaultValue) {
        String s = XmlUtil.getNodeAttribute(node, attributeName);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public static String getNodeAttribute(Element xmlElement, String nodeName, String attributeName) {
        String value = "";
        NodeList list = xmlElement.getElementsByTagName(nodeName);
        if (list.getLength() > 0) {
            Node node = list.item(0);
            value = XmlUtil.getNodeAttribute(node, attributeName);
        }
        return value;
    }

    public static String getNodeAttributeByName(Element xmlElement, String nodeName, String nameAttrValue, String attrName) {
        String value = "";
        NodeList list = xmlElement.getElementsByTagName(nodeName);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(nameAttrValue)) continue;
                value = XmlUtil.getNodeAttribute(node, attrName);
                break;
            }
        }
        return value;
    }

    public static String getNodeAttrByName(Element xmlElement, String tagName, String name, String attrName) throws Exception {
        String attrValue = null;
        NodeList list = xmlElement.getElementsByTagName(tagName);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(name)) continue;
                attrValue = XmlUtil.getNodeAttribute(node, attrName);
                break;
            }
        }
        return attrValue;
    }

    public static String getNodeValueByName(Element xmlElement, String tagName, String name) throws Exception {
        String value = "";
        NodeList list = xmlElement.getElementsByTagName(tagName);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!node.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(name)) continue;
                value = node.getFirstChild().getNodeValue();
                break;
            }
        }
        if (value.equals("")) {
            throw new Exception("\u672a\u627e\u5230\u6307\u5b9a\u7ed3\u70b9\u3002[tag]= " + tagName + " [name]=" + name);
        }
        return value;
    }

    public static Node getChildNode(Node node, String tagName) {
        Node[] childNodes = XmlUtil.getChildNodes(node, tagName);
        if (childNodes.length > 0) {
            return childNodes[0];
        }
        return null;
    }

    public static Node[] getChildNodes(Node node, String tagName) {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        int count = 0;
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node nodeChild = nodeList.item(index);
            if (!nodeChild.getNodeName().equalsIgnoreCase(tagName)) continue;
            childNodes.add(nodeChild);
            ++count;
        }
        Node[] childNodesArray = new Node[count];
        Iterator it = childNodes.iterator();
        int index = 0;
        while (it.hasNext()) {
            childNodesArray[index++] = (Node)it.next();
        }
        return childNodesArray;
    }

    public static Node[] getChildNodes(Node node, String[] tagNames) {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        int count = 0;
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Node nodeChild = nodeList.item(index);
            for (int j = 0; j < tagNames.length; ++j) {
                if (!nodeChild.getNodeName().equalsIgnoreCase(tagNames[j])) continue;
                childNodes.add(nodeChild);
                ++count;
            }
        }
        Node[] childNodesArray = new Node[count];
        Iterator it = childNodes.iterator();
        int index = 0;
        while (it.hasNext()) {
            childNodesArray[index++] = (Node)it.next();
        }
        return childNodesArray;
    }

    public static String getNodeTextContent(Node node) {
        String s = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : node.getNodeValue();
        return s == null ? "" : s;
    }

    public static boolean nodeIsExist(Element xmlElement, String nodeName) {
        NodeList list = xmlElement.getElementsByTagName(nodeName);
        return list.getLength() > 0;
    }
}

