/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.pool;

import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.pool.ObjectPool;

public class ThreadPool
extends ObjectPool {
    public static final long IDLE_TIMEOUT = 60000L;
    private long uuid = 0L;

    public ThreadPool(String name, int minSize, int maxSize) {
        super(name, minSize, maxSize);
    }

    @Override
    public Object get(Object obj) {
        this.run((Runnable)obj);
        return null;
    }

    private synchronized void run(Runnable runner) {
        Worker worker;
        if (!this.pool.isEmpty()) {
            worker = (Worker)this.pool.removeFirst();
        } else {
            worker = new Worker(this.name + "-" + ++this.uuid);
            worker.start();
        }
        worker.execute(runner);
    }

    private synchronized boolean timeout(Worker worker) {
        if (worker.runner != null) {
            return false;
        }
        if (this.pool.size() > this.minSize) {
            this.pool.remove(worker);
            return true;
        }
        return false;
    }

    private synchronized boolean free(Worker worker) {
        if (this.pool.size() < this.maxSize) {
            this.pool.addLast(worker);
            return false;
        }
        return true;
    }

    public class Worker
    extends Thread {
        private Runnable runner;

        private Worker(String name) {
            super(name);
            this.runner = null;
            this.setDaemon(true);
        }

        public synchronized void execute(Runnable runner) {
            this.runner = runner;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Worker worker = this;
                synchronized (worker) {
                    if (this.runner == null) {
                        try {
                            this.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.runner == null) {
                    if (!ThreadPool.this.timeout(this)) continue;
                    return;
                }
                try {
                    this.runner.run();
                    continue;
                }
                finally {
                    this.runner = null;
                    if (!ThreadPool.this.free(this)) continue;
                    return;
                    continue;
                }
                break;
            }
        }
    }
}

