/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.chart;

import com.kingdee.bos.ctrl.analysis.web.chart.EASConstant;
import com.kingdee.bos.ctrl.analysis.web.chart.EasGradientPaintFactory;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.chart.ChartConfig;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryAxis;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryAxis3D;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryLabelPositions;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis3D;
import com.kingdee.bos.ctrl.freechart.chart.axis.ValueAxis;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelAnchor;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelPosition;
import com.kingdee.bos.ctrl.freechart.chart.labels.PieSectionLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.PieToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardPieSectionLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardPieToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.plot.CategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.CombinedDomainCategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.DatasetRenderingOrder;
import com.kingdee.bos.ctrl.freechart.chart.plot.MultiplePiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.Plot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotOrientation;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.AreaRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer3D;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.CategoryItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.LineAndShapeRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedAreaRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedBarRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedBarRenderer3D;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.SubCategoryDataset;
import com.kingdee.bos.ctrl.freechart.ui.TextAnchor;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;

public class ChartFactory {
    private static final Logger logger = CommonLogger.getLogger(ChartFactory.class);

    private ChartFactory() {
    }

    public static JFreeChart create(ChartConfig cc) throws BIReportException {
        String methodName = cc.getMethodName();
        try {
            JFreeChart chart = (JFreeChart)ChartFactory.class.getMethod(methodName, ChartConfig.class).invoke(null, cc);
            Plot plot = chart.getPlot();
            Color backgroudColor = new Color(0xFFFFFF);
            chart.setBackgroundPaint((Paint)backgroudColor);
            if (plot instanceof CombinedDomainCategoryPlot) {
                CombinedDomainCategoryPlot cplot = (CombinedDomainCategoryPlot)plot;
                List plots = cplot.getSubplots();
                for (CategoryPlot catPlot : plots) {
                    catPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(100.0f);
                    catPlot.setBackgroundPaint((Paint)new Color(0xFFFFFF));
                    catPlot.setRangeGridIntervalBackgroudPaint((Paint)new Color(15462649));
                    CategoryDataset data = catPlot.getDataset();
                    CategoryItemRenderer renderer = catPlot.getRenderer();
                    int serierCount = data.getRowCount();
                    if (serierCount > EasGradientPaintFactory.getCount()) {
                        serierCount = EasGradientPaintFactory.getCount();
                    }
                    for (int i = 0; i < serierCount; ++i) {
                        GradientPaint p = EasGradientPaintFactory.getGradientPaint(i, false);
                        GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i, true);
                        renderer.setSeriesPaint(i, (Paint)p);
                        renderer.setSeriesOutlinePaint(i, (Paint)p2);
                        renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                    }
                }
            } else if (plot instanceof CategoryPlot) {
                CategoryPlot catPlot = (CategoryPlot)plot;
                catPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(100.0f);
                catPlot.setBackgroundPaint((Paint)new Color(0xFFFFFF));
                catPlot.setRangeGridIntervalBackgroudPaint((Paint)new Color(15462649));
                CategoryDataset data = catPlot.getDataset();
                CategoryItemRenderer renderer = catPlot.getRenderer();
                int serierCount = data.getRowCount();
                if (serierCount > EasGradientPaintFactory.getCount()) {
                    serierCount = EasGradientPaintFactory.getCount();
                }
                for (int i = 0; i < serierCount; ++i) {
                    GradientPaint p = EasGradientPaintFactory.getGradientPaint(i, false);
                    GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i, true);
                    renderer.setSeriesPaint(i, (Paint)p);
                    renderer.setSeriesOutlinePaint(i, (Paint)p2);
                    renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                }
                if (catPlot.getDatasetCount() > 1) {
                    data = catPlot.getDataset(1);
                    renderer = catPlot.getRenderer(1);
                    int serierCount2 = data.getRowCount();
                    if (serierCount2 > EasGradientPaintFactory.getCount()) {
                        serierCount2 = EasGradientPaintFactory.getCount();
                    }
                    for (int i = 0; i < serierCount2; ++i) {
                        GradientPaint p = EasGradientPaintFactory.getGradientPaint(i + serierCount, false);
                        GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i + serierCount, true);
                        renderer.setSeriesPaint(i, (Paint)p);
                        renderer.setSeriesOutlinePaint(i, (Paint)p2);
                        renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                    }
                }
            } else if (plot instanceof MultiplePiePlot) {
                MultiplePiePlot mpplot = (MultiplePiePlot)plot;
                CategoryDataset data = mpplot.getDataset();
                PiePlot piePlot = (PiePlot)mpplot.getPieChart().getPlot();
                piePlot.setLabelShadowPaint(null);
                if (mpplot.getDataExtractOrder().equals((Object)TableOrder.BY_COLUMN)) {
                    int count = data.getRowCount();
                    if (count > EasGradientPaintFactory.getCount()) {
                        count = EasGradientPaintFactory.getCount();
                    }
                    for (int i = 0; i < count; ++i) {
                        piePlot.setSectionPaint(data.getRowKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i));
                    }
                } else {
                    int count = data.getColumnCount();
                    if (count > EasGradientPaintFactory.getCount()) {
                        count = EasGradientPaintFactory.getCount();
                    }
                    for (int i = 0; i < count; ++i) {
                        piePlot.setSectionPaint(data.getColumnKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i, false));
                        piePlot.setSectionOutlinePaint(data.getColumnKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i, true));
                    }
                }
            }
            return chart;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.warn((Object)t.getMessage(), t);
            throw new DashBoardException("\u9519\u8bef\uff1a" + t.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            logger.warn((Object)"\u627e\u4e0d\u5230\u56fe\u8868\u7c7b\u578b\u5bf9\u5e94\u7684\u65b9\u6cd5", (Throwable)e);
            throw new DashBoardException("\u751f\u6210\u56fe\u8868\u5931\u8d25", e);
        }
        catch (Exception e) {
            logger.warn((Object)("\u751f\u6210\u56fe\u8868\u5931\u8d25\u3002\u9519\u8bef\uff1a" + e.getMessage()), (Throwable)e);
            throw new DashBoardException("\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    public static JFreeChart getBar(ChartConfig cc) throws BIReportException {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        CategoryAxis categoryAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis valueAxis = new NumberAxis(cc.getYLabel());
        BarRenderer renderer = new BarRenderer();
        if (cc.isVertical()) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setNegativeItemLabelPosition(position2);
        } else {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setNegativeItemLabelPosition(position2);
        }
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getBar3D(ChartConfig cc) throws BIReportException {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        CategoryAxis3D categoryAxis = new CategoryAxis3D(cc.getXLabel());
        NumberAxis3D valueAxis = new NumberAxis3D(cc.getYLabel());
        BarRenderer3D renderer = new BarRenderer3D();
        if (cc.isVertical()) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setNegativeItemLabelPosition(position2);
        } else {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setNegativeItemLabelPosition(position2);
        }
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        plot.setForegroundAlpha(0.75f);
        renderer.setDrawBarOutline(true);
        renderer.setItemLabelsVisible(true);
        renderer.setBaseItemLabelsVisible(true);
        renderer.setItemLabelAnchorOffset(10.0);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getStackedBar(ChartConfig cc) throws BIReportException {
        CategoryAxis categoryAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis valueAxis = new NumberAxis(cc.getYLabel());
        StackedBarRenderer renderer = new StackedBarRenderer();
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getStackedBar3D(ChartConfig cc) throws BIReportException {
        CategoryAxis3D categoryAxis = new CategoryAxis3D(cc.getXLabel());
        NumberAxis3D valueAxis = new NumberAxis3D(cc.getYLabel());
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getMultiPie(ChartConfig cc) throws BIReportException {
        MultiplePiePlot plot = new MultiplePiePlot(cc.getDataSet());
        plot.setDataExtractOrder(TableOrder.BY_ROW);
        PiePlot pp = (PiePlot)plot.getPieChart().getPlot();
        pp.setBackgroundPaint(null);
        pp.setOutlineStroke(null);
        pp.setSectionOutlineStroke(EASConstant.STOKE_PIESECTIONOUTLINE);
        pp.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}({2})", EASConstant.NUMBERFORMAT, EASConstant.PERCENT_NUMBERFORMAT));
        pp.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("({0},{1}) = {2}", EASConstant.NUMBERFORMAT, EASConstant.PERCENT_NUMBERFORMAT));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getLine(ChartConfig cc) throws BIReportException {
        CategoryAxis categoryAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis valueAxis = new NumberAxis(cc.getYLabel());
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setFillPaint((Paint)Color.white);
        CategoryDataset dataSet = cc.getDataSet();
        int serierCount = dataSet.getRowCount();
        for (int i = 0; i < serierCount; ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
            renderer.setSeriesOutlineStroke(i, (Stroke)new BasicStroke(2.0f));
            renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        }
        CategoryPlot plot = new CategoryPlot(dataSet, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        int categoryCount = dataSet.getColumnCount();
        if (categoryCount > 4) {
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getArea(ChartConfig cc) throws BIReportException {
        CategoryAxis categoryAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis valueAxis = new NumberAxis(cc.getYLabel());
        categoryAxis.setCategoryMargin(0.0);
        AreaRenderer renderer = new AreaRenderer();
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        return chart;
    }

    public static JFreeChart getStackedArea(ChartConfig cc) throws BIReportException {
        CategoryAxis categoryAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis valueAxis = new NumberAxis(cc.getYLabel());
        StackedAreaRenderer renderer = new StackedAreaRenderer();
        CategoryPlot plot = new CategoryPlot(cc.getDataSet(), categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(cc.isVertical() ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        JFreeChart chart = new JFreeChart(cc.getTitle(), (Plot)plot);
        return chart;
    }

    public static JFreeChart getBarLine(ChartConfig cc) throws BIReportException {
        CategoryPlot plot = new CategoryPlot();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        BarRenderer renderer = new BarRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)generator);
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        CategoryDataset dataset = cc.getDataSet();
        int rowCount = dataset.getRowCount();
        SubCategoryDataset dataset1 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, 0, rowCount - 1);
        SubCategoryDataset dataset2 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, rowCount - 1, rowCount);
        plot.setDataset((CategoryDataset)dataset1);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setDataset(1, (CategoryDataset)dataset2);
        plot.setRenderer(1, (CategoryItemRenderer)renderer2);
        plot.setDomainAxis(new CategoryAxis(cc.getXLabel()));
        plot.setRangeAxis((ValueAxis)new NumberAxis(cc.getYLabel()));
        plot.setRangeAxis(1, (ValueAxis)new NumberAxis(cc.getYLabel()));
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        renderer2.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        return new JFreeChart((Plot)plot);
    }

    public static JFreeChart getCombinedBarLine(ChartConfig cc) throws BIReportException {
        CategoryPlot plot1 = new CategoryPlot();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        BarRenderer renderer = new BarRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)generator);
        CategoryDataset dataset = cc.getDataSet();
        int rowCount = dataset.getRowCount();
        SubCategoryDataset dataset1 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, 0, rowCount - 1);
        SubCategoryDataset dataset2 = new SubCategoryDataset(dataset, TableOrder.BY_ROW, rowCount - 1, rowCount);
        CategoryAxis xAxis = new CategoryAxis(cc.getXLabel());
        NumberAxis yAxis = new NumberAxis(cc.getYLabel());
        plot1.setDataset((CategoryDataset)dataset1);
        plot1.setRenderer((CategoryItemRenderer)renderer);
        plot1.setDomainAxis(xAxis);
        plot1.setRangeAxis((ValueAxis)yAxis);
        plot1.setOrientation(PlotOrientation.VERTICAL);
        plot1.setRangeGridlinesVisible(true);
        plot1.setDomainGridlinesVisible(true);
        plot1.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        renderer = new LineAndShapeRenderer();
        CategoryPlot plot2 = new CategoryPlot();
        plot2.setDataset((CategoryDataset)dataset2);
        plot2.setRenderer((CategoryItemRenderer)renderer);
        plot2.setDomainAxis(xAxis);
        plot2.setRangeAxis((ValueAxis)yAxis);
        plot2.setOrientation(PlotOrientation.VERTICAL);
        plot2.setRangeGridlinesVisible(true);
        plot2.setDomainGridlinesVisible(true);
        plot2.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(xAxis);
        plot.add(plot2, 1);
        plot.add(plot1, 1);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        return new JFreeChart((Plot)plot);
    }
}

