/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.dao;

import com.kingdee.bos.ctrl.analysis.web.ext.DateUtil;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ExtReportVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.util.Uuid;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExtReportDAO {
    private Logger logger = CommonLogger.getLogger(ExtReportDAO.class);
    private static final String PERMISSION_FILTER = "select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID = ? and SUBSTRING(p.fpermission,1,1) = '1' union select  p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid where p.FUserID = ? and p.FOrgID is null and SUBSTRING(p.fpermission,1,1) = '1'union select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r on p.FReportID=r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid where uro.FUserID = ? and uro.FOrgID = ? and SUBSTRING(p.fpermission,1,1) = '1'";

    public static String getDeployName(String str) {
        int n;
        if (null == str) {
            return "";
        }
        if (str.length() > 0 && (n = str.indexOf("@@")) != -1) {
            str = str.substring(n + 2);
        }
        return str;
    }

    public ArrayList queryReportName(Connection connection, ExtReportVO qVo) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = connection;
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append("select d.FPortalAliasName as fname from T_BAS_DefineReport d where d.FBIPath =? and(( d.fcreatorid =? and (d.forgid =? or d.forgid=?)) or d.fid in (");
            sbSQL.append(PERMISSION_FILTER);
            sbSQL.append(")) and charindex(?,d.FPortalAliasName) = 1");
            pstmt = conn.prepareStatement(sbSQL.toString());
            pstmt.setString(1, qVo.getPortalPath());
            pstmt.setString(2, qVo.getCreator());
            pstmt.setString(3, qVo.getCreatorOrg());
            pstmt.setString(4, "qUvvbL4yQsyQYFIDSlvngID2+FI=");
            pstmt.setString(5, qVo.getCreator());
            pstmt.setString(6, qVo.getCreatorOrg());
            pstmt.setString(7, qVo.getCreator());
            pstmt.setString(8, qVo.getCreator());
            pstmt.setString(9, qVo.getCreatorOrg());
            pstmt.setString(10, qVo.getReportName());
            rs = pstmt.executeQuery();
            ArrayList<String> rsList = new ArrayList<String>();
            while (rs.next()) {
                String name = rs.getString("fname");
                rsList.add(name);
            }
            arrayList = rsList;
        }
        catch (SQLException e) {
            try {
                this.logger.warn((Object)"\u67e5\u8be2\u62a5\u8868\u540d\u79f0\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, pstmt);
        return arrayList;
    }

    public ArrayList queryByOrgAUser(Connection connection, ExtReportVO qVo, String systemId, String local) throws SQLException {
        ArrayList<ExtReportVO> arrayList;
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select d.fid, d.FBIPath, d.FIsStdProduct, d.ftemplettype, d.fmenuui as classname, ");
        sbSQL.append("o.Fname_").append(local).append(" as orgname, ");
        sbSQL.append("d.FPortalAliasName as fname, ");
        sbSQL.append("u.Fname_").append(local).append(" as user_name, ");
        sbSQL.append("d.flastupdatetime, d.fdeploypath ");
        sbSQL.append("from T_BAS_DefineReport d left outer join t_pm_user u on d.fcreatorid=u.fid left outer join t_org_baseunit o on o.fid=d.forgid ");
        sbSQL.append("where d.FBIPath =? and ( ( d.fcreatorid =? and (d.forgid =? or d.forgid=?) ) or d.fid in (");
        sbSQL.append(PERMISSION_FILTER);
        sbSQL.append(") )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = connection;
            pstmt = conn.prepareStatement(sbSQL.toString());
            pstmt.setString(1, systemId);
            pstmt.setString(2, qVo.getCreator());
            pstmt.setString(3, qVo.getCreatorOrg());
            pstmt.setString(4, "qUvvbL4yQsyQYFIDSlvngID2+FI=");
            pstmt.setString(5, qVo.getCreator());
            pstmt.setString(6, qVo.getCreatorOrg());
            pstmt.setString(7, qVo.getCreator());
            pstmt.setString(8, qVo.getCreator());
            pstmt.setString(9, qVo.getCreatorOrg());
            rs = pstmt.executeQuery();
            ArrayList<ExtReportVO> rsList = new ArrayList<ExtReportVO>();
            while (rs.next()) {
                ExtReportVO vo = new ExtReportVO();
                vo.setId(rs.getString("fid"));
                vo.setReportName(rs.getString("fname"));
                vo.setCreator(rs.getString("user_name"));
                vo.setCreatorOrg(rs.getString("orgname"));
                vo.setModifiedTime(DateUtil.formatDateTimeHHmm(rs.getTimestamp("flastupdatetime").toString()));
                vo.setEasPath(ExtReportDAO.getDeployName(rs.getString("fdeploypath")));
                vo.setPortalPath(rs.getString("FBIPath"));
                vo.setIsStandard(rs.getInt("fisstdproduct") == 1);
                int reportType = rs.getInt("ftemplettype");
                vo.setReportType(reportType == 0 ? "\u4e0a\u62a5\u6a21\u677f" : (reportType == 1 ? "\u6c47\u603b\u6a21\u677f" : ""));
                vo.setClassName(rs.getString("classname"));
                rsList.add(vo);
            }
            arrayList = rsList;
        }
        catch (SQLException e) {
            try {
                this.logger.warn((Object)"\u67e5\u8be2\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, pstmt);
        return arrayList;
    }

    public static void main(String[] args) {
        try {
            Connection conn = JDBCUtil.getConnection("alvan", "kingdee", "BOS");
            String sql = "insert into t_ext_report(id,url)values(?,?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            String extid = Uuid.randomUUID().toString();
            System.out.println(extid);
            pstmt.setString(1, extid);
            pstmt.setString(2, "http://times.com");
            pstmt.execute();
            JDBCUtil.close(pstmt);
            JDBCUtil.close(conn);
        }
        catch (SQLException e) {
            JDBCUtil.printException(e);
        }
    }
}

