/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.jcr.SMFile;
import com.kingdee.bos.ctrl.jcr.SMFolder;
import com.kingdee.bos.ctrl.jcr.SMResource;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMExistException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MetaData_EAS {
    private static Logger logger = CommonLogger.getLogger(MetaData_EAS.class);
    public static final String EAS_PERMISSION_PROPERTY_NAME = "permissionID";
    private static final String EAS_DASHBOARDTREE_TABLE_NAME = "T_FW_BIDashboardTree";
    private static final String EAS_THEMEANALYSISTREE_TABLE_NAME = "T_FW_BIThemeAnalysisTree";

    public static void delTreeNode_EAS(Connection con, String FID, int treeType, boolean closeConnection) throws RepositoryException {
        if (!BISystem.isEAS()) {
            return;
        }
        if (StringUtils.isEmpty((String)FID)) {
            return;
        }
        String tablename = "";
        String treename = "";
        if (treeType == 6) {
            tablename = EAS_THEMEANALYSISTREE_TABLE_NAME;
            treename = "\u4e1a\u52a1\u4e3b\u9898\u5206\u6790";
        } else if (treeType == 5) {
            tablename = EAS_DASHBOARDTREE_TABLE_NAME;
            treename = "\u4eea\u8868\u677f";
        } else {
            return;
        }
        String sql = "delete from " + tablename + " where CHARINDEX((select FLongNumber from " + tablename + " where FID ='" + FID + "'),FLongNumber)=1";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            int n = stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (closeConnection) {
                SQLUtils.cleanup((Statement)stmt, (Connection)con);
            } else {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
    }

    public static String saveDashboard_EAS(Repository rep, Connection con, String userID, String cu, int isLeaf, String name, String caption, boolean isNew, SMFolder parentFolder, SMResource smDashboard, boolean closeConnection) throws RepositoryException, BIReportException, SMException {
        if (!BISystem.isEAS()) {
            return null;
        }
        String id = null;
        String sql = "";
        String displayName_l1 = "";
        String displayName_l2 = caption;
        String displayName_l3 = caption;
        String name_l1 = "";
        String name_l2 = caption;
        String name_l3 = caption;
        String longNumber = rep.getRelationPath("DBD", smDashboard.getPath(), "/dashboard_tree");
        longNumber = longNumber.replace('/', '!');
        String searchSql = "select FID from T_FW_BIDashboardTree where FLongNumber='" + longNumber + "'";
        id = rep.executeQuery2(searchSql);
        if (id == null) {
            isNew = true;
        }
        if (isNew) {
            id = BOSUuid.create((BOSObjectType)MetaData_EAS.getPermissionBosType(Constants.PERMISSION_NAME_DASHBOARD_CONFIG)).toString();
            String parentID = "";
            int level = 1;
            String parentLongNumber = rep.getRelationPath("DBD", parentFolder.getPath(), "/dashboard_tree");
            if ((parentLongNumber = parentLongNumber.replace('/', '!')).equals("")) {
                parentLongNumber = null;
                parentID = null;
            } else {
                searchSql = "select FID from T_FW_BIDashboardTree where FLongNumber='" + parentLongNumber + "'";
                parentID = rep.executeQuery2(searchSql);
                if (parentID == null) {
                    throw new RepositoryException("\u627e\u4e0d\u5230\u4eea\u8868\u677f\u6811\u4e2d\u5bf9\u5e94\u7684\u7236\u7ed3\u70b9\uff01");
                }
            }
            if (parentLongNumber != null) {
                level = parentLongNumber.indexOf(92) == -1 ? 2 : parentLongNumber.split("\\!").length + 2;
            }
            String number = name;
            longNumber = parentLongNumber == null ? number : parentLongNumber + "!" + number;
            String discription_l1 = "";
            String discription_l2 = "";
            String discription_l3 = "";
            String simpleName = number;
            sql = "insert into T_FW_BIDashboardTree (FParentID,FIsLeaf,FLevel,FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,fsimplename,FLastUpdateUserID,FLastUpdateTime,FCreatorID,FCreateTime,FControlUnitID,FID)  values(" + (parentID == null ? "null" : "'" + parentID + "'") + "," + isLeaf + "," + level + ",'" + longNumber + "','" + displayName_l1 + "','" + displayName_l2 + "','" + displayName_l3 + "','" + name_l1 + "','" + name_l2 + "','" + name_l3 + "','" + number + "','" + discription_l1 + "','" + discription_l2 + "','" + discription_l3 + "','" + simpleName + "','" + userID + "',now(),'" + userID + "',now(),'" + cu + "','" + id + "')";
        } else {
            sql = "update T_FW_BIDashboardTree set FDisplayName_l1='" + displayName_l1 + "',FDisplayName_l2='" + displayName_l2 + "',FDisplayName_l3='" + displayName_l3 + "',FName_l1='" + name_l1 + "',FName_l2='" + name_l2 + "',FName_l3='" + name_l3 + "',FLastUpdateUserID='" + userID + "',FLastUpdateTime=now(),FControlUnitID='" + cu + "' where FLongNumber='" + longNumber + "'";
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            int row = stmt.executeUpdate();
            if (row != 1) {
                throw new RepositoryException(isNew ? "\u63d2\u5165" : "\u4fee\u6539\u4eea\u8868\u677f\u7ed3\u70b9\u5931\u8d25\uff01");
            }
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (closeConnection) {
                SQLUtils.cleanup((Statement)stmt, (Connection)con);
            } else {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        return id;
    }

    public static String saveThemeAnalysis_EAS(Repository rep, Connection con, String userID, String cu, int isLeaf, String name, String caption, boolean isNew, SMFolder parentFolder, SMResource smTheme, String subjectName, String reportPath, boolean closeConnection) throws RepositoryException, BIReportException, SMException {
        if (!BISystem.isEAS()) {
            return null;
        }
        String id = null;
        String sql = "";
        String displayName_l1 = "";
        String displayName_l2 = caption;
        String displayName_l3 = caption;
        String name_l1 = "";
        String name_l2 = caption;
        String name_l3 = caption;
        String longNumber = rep.getRelationPath("RPT", smTheme.getPath(), "/report_tree");
        longNumber = longNumber.replace('/', '!');
        String searchSql = "select FID from T_FW_BIThemeAnalysisTree where FLongNumber='" + longNumber + "'";
        id = rep.executeQuery2(searchSql);
        if (id == null) {
            isNew = true;
        }
        if (isNew) {
            id = BOSUuid.create((BOSObjectType)MetaData_EAS.getPermissionBosType(Constants.PERMISSION_NAME_THEME_CONFIG)).toString();
            String parentID = "";
            int level = 1;
            String parentLongNumber = rep.getRelationPath("RPT", parentFolder.getPath(), "/report_tree");
            if ((parentLongNumber = parentLongNumber.replace('/', '!')).equals("")) {
                parentLongNumber = null;
                parentID = null;
            } else {
                searchSql = "select FID from T_FW_BIThemeAnalysisTree where FLongNumber='" + parentLongNumber + "'";
                parentID = rep.executeQuery2(searchSql);
                if (parentID == null) {
                    throw new RepositoryException("\u627e\u4e0d\u5230\u4e3b\u9898\u6811\u4e2d\u5bf9\u5e94\u7684\u7236\u7ed3\u70b9\uff01");
                }
            }
            if (parentLongNumber != null) {
                level = parentLongNumber.indexOf(92) == -1 ? 2 : parentLongNumber.split("\\!").length + 2;
            }
            String number = name;
            longNumber = parentLongNumber == null ? number : parentLongNumber + "!" + number;
            String discription_l1 = "";
            String discription_l2 = "";
            String discription_l3 = "";
            String simpleName = number;
            sql = "insert into T_FW_BIThemeAnalysisTree (FParentID,FSubjectName,FReportPath,FIsLeaf,FLevel,FLongNumber,FDisplayName_l1,FDisplayName_l2,FDisplayName_l3,FName_l1,FName_l2,FName_l3,FNumber,FDescription_l1,FDescription_l2,FDescription_l3,fsimplename,FLastUpdateUserID,FLastUpdateTime,FCreatorID,FCreateTime,FControlUnitID,FID)  values(" + (parentID == null ? "null" : "'" + parentID + "'") + ",'" + subjectName + "','" + reportPath + "'," + isLeaf + "," + level + ",'" + longNumber + "','" + displayName_l1 + "','" + displayName_l2 + "','" + displayName_l3 + "','" + name_l1 + "','" + name_l2 + "','" + name_l3 + "','" + number + "','" + discription_l1 + "','" + discription_l2 + "','" + discription_l3 + "','" + simpleName + "','" + userID + "',now(),'" + userID + "',now(),'" + cu + "','" + id + "')";
        } else {
            sql = "update T_FW_BIThemeAnalysisTree set FSubjectName='" + subjectName + "',FReportPath='" + reportPath + "',FDisplayName_l1='" + displayName_l1 + "',FDisplayName_l2='" + displayName_l2 + "',FDisplayName_l3='" + displayName_l3 + "',FName_l1='" + name_l1 + "',FName_l2='" + name_l2 + "',FName_l3='" + name_l3 + "',FLastUpdateUserID='" + userID + "',FLastUpdateTime=now(),FControlUnitID='" + cu + "' where FLongNumber='" + longNumber + "'";
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            int row = stmt.executeUpdate();
            if (row != 1) {
                throw new RepositoryException(isNew ? "\u63d2\u5165" : "\u4fee\u6539\u4e3b\u9898\u5206\u6790\u7ed3\u70b9\u5931\u8d25\uff01");
            }
        }
        catch (SQLException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            if (closeConnection) {
                SQLUtils.cleanup((Statement)stmt, (Connection)con);
            } else {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        return id;
    }

    private static String createUserSql(String table, String field, String id) {
        return "select U.FNAME_L2 from " + table + " A, T_PM_User U where A." + field + " = U.FID AND A.FID='" + id + "'";
    }

    public static String getTree_Creator(int treeType, Repository rep, String id) throws RepositoryException {
        if (!BISystem.isEAS()) {
            return "";
        }
        String sql = "";
        if (treeType == 6) {
            sql = MetaData_EAS.createUserSql(EAS_THEMEANALYSISTREE_TABLE_NAME, "FCreatorID", id);
        } else if (treeType == 5) {
            sql = MetaData_EAS.createUserSql(EAS_DASHBOARDTREE_TABLE_NAME, "FCreatorID", id);
        } else {
            throw new RepositoryException("\u4e0d\u652f\u6301\u7684\u6811\u7c7b\u578b!" + treeType);
        }
        String creator = rep.executeQuery2(sql);
        if (creator == null) {
            logger.error((Object)("BI test: can't get creator sql: " + sql));
        }
        return creator == null ? "" : creator;
    }

    public static String getTree_LastUpdateUser(int treeType, Repository rep, String id) throws RepositoryException {
        if (!BISystem.isEAS()) {
            return "";
        }
        String sql = "";
        if (treeType == 6) {
            sql = MetaData_EAS.createUserSql(EAS_THEMEANALYSISTREE_TABLE_NAME, "FLastUpdateUserID", id);
        } else if (treeType == 5) {
            sql = MetaData_EAS.createUserSql(EAS_DASHBOARDTREE_TABLE_NAME, "FLastUpdateUserID", id);
        } else {
            throw new RepositoryException("\u4e0d\u652f\u6301\u7684\u6811\u7c7b\u578b!" + treeType);
        }
        String lastUpdateUser = rep.executeQuery2(sql);
        return lastUpdateUser == null ? "" : lastUpdateUser;
    }

    public static void upgradeReportTree(Connection con, Repository rep, String userId, String cu, SMFolder reportTreeRoot) {
        SMResource[] rs;
        try {
            rs = reportTreeRoot.getChildren();
        }
        catch (SMException e) {
            logger.error((Object)"\u8bfb\u53d6\u5b50\u7ed3\u70b9\u51fa\u9519\uff01", (Throwable)e);
            return;
        }
        for (int i = 0; i < rs.length; ++i) {
            try {
                String caption;
                if (RepositoryUtil.isThemeReport(rs[i])) {
                    if (MetaData_EAS.hasMetaFlag(rs[i])) continue;
                    caption = RepositoryUtil.getPropertyValue(rs[i], "caption");
                    String subjectName = rs[i].getProperty("subject");
                    String reportPath = rs[i].getProperty("reportPath");
                    String id = MetaData_EAS.saveThemeAnalysis_EAS(rep, con, userId, cu, 1, rs[i].getName(), caption, true, reportTreeRoot, rs[i], subjectName, reportPath, false);
                    if (id == null) continue;
                    rs[i].setProperty(EAS_PERMISSION_PROPERTY_NAME, id);
                    continue;
                }
                if (!(rs[i] instanceof SMFolder)) continue;
                if (!MetaData_EAS.hasMetaFlag(rs[i])) {
                    caption = RepositoryUtil.getPropertyValue(rs[i], "caption");
                    String id = MetaData_EAS.saveThemeAnalysis_EAS(rep, con, userId, cu, 0, rs[i].getName(), caption, true, reportTreeRoot, rs[i], "", "", false);
                    if (id != null) {
                        rs[i].setProperty(EAS_PERMISSION_PROPERTY_NAME, id);
                    }
                }
                MetaData_EAS.upgradeReportTree(con, rep, userId, cu, (SMFolder)rs[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u5199\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    public static void upgradeDashboardTree(Connection con, Repository rep, String userId, String cu, SMFolder dashboardTreeRoot) {
        SMResource[] rs;
        try {
            rs = dashboardTreeRoot.getChildren();
        }
        catch (SMException e) {
            logger.error((Object)"\u8bfb\u53d6\u5b50\u7ed3\u70b9\u51fa\u9519\uff01", (Throwable)e);
            return;
        }
        for (int i = 0; i < rs.length; ++i) {
            try {
                if (rs[i] instanceof SMFile) {
                    if (MetaData_EAS.hasMetaFlag(rs[i])) continue;
                    MetaData_EAS.saveDashboard_EAS(rep, con, userId, cu, 1, rs[i].getName(), RepositoryUtil.getPropertyValue(rs[i], "caption"), true, dashboardTreeRoot, rs[i], false);
                    continue;
                }
                if (!(rs[i] instanceof SMFolder)) continue;
                if (!MetaData_EAS.hasMetaFlag(rs[i])) {
                    MetaData_EAS.saveDashboard_EAS(rep, con, userId, cu, 0, rs[i].getName(), RepositoryUtil.getPropertyValue(rs[i], "caption"), true, dashboardTreeRoot, rs[i], false);
                }
                MetaData_EAS.upgradeDashboardTree(con, rep, userId, cu, (SMFolder)rs[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u5199\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    private static boolean hasMetaFlag(SMResource rs) throws SMException {
        try {
            rs.getProperty(EAS_PERMISSION_PROPERTY_NAME);
        }
        catch (SMExistException e) {
            return false;
        }
        return true;
    }

    public static String gerPermissionID(SMResource rs) throws SMException {
        try {
            return rs.getProperty(EAS_PERMISSION_PROPERTY_NAME);
        }
        catch (SMExistException e) {
            return null;
        }
    }

    public static boolean hasDataPermission(BITreeNode node, int treeType, BIPermission permission) throws BIReportException {
        boolean isReport;
        boolean bl = isReport = treeType == 1;
        if (BITreeUtil.isLeaf(node)) {
            boolean b;
            String itemID = node.getPropertyValue(EAS_PERMISSION_PROPERTY_NAME);
            if (itemID != null && (b = permission.hasDataPermission(isReport ? Constants.PERMISSION_NAME_THEME_CONFIG : Constants.PERMISSION_NAME_DASHBOARD_CONFIG, itemID))) {
                return true;
            }
        } else {
            int nChildCount = node.getChildCount();
            for (int n = 0; n < nChildCount; ++n) {
                boolean b = MetaData_EAS.hasDataPermission((BITreeNode)node.getChildAt(n), treeType, permission);
                if (!b) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasDataPermission$VerifyExtReport(BITreeNode node, int treeType, BIPermission permission, HttpServletRequest req) throws BIReportException {
        boolean isBIReport;
        boolean isReport = treeType == 1;
        boolean bl = isBIReport = null != BITreeUtil.getReportPath(node) && BITreeUtil.getReportPath(node).endsWith("olaprpt") && isReport;
        if (BITreeUtil.isLeaf(node)) {
            String itemID = node.getPropertyValue(EAS_PERMISSION_PROPERTY_NAME);
            if (itemID != null) {
                boolean b = false;
                if (isBIReport) {
                    b = permission.hasDataPermission(isReport ? Constants.PERMISSION_NAME_THEME_CONFIG : Constants.PERMISSION_NAME_DASHBOARD_CONFIG, itemID);
                } else if (isReport) {
                    try {
                        String reportID = BISystem.getRepository(req).getNodePropertyByPath("RPT", node.getID(), "reportPath");
                        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)req);
                        boolean isCloudRpt = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO").getMethod("isCloudReport", Context.class, String.class).invoke(null, ctx, reportID);
                        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                        String orgID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                        b = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO").getMethod("hasDataPermissionByReportId", Context.class, String.class, String.class, String.class, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind")).invoke(null, ctx, userID, orgID, reportID, Class.forName("com.kingdee.eas.rpts.ctrlreport.data.PermissionKind").getField("VIEW").get(null));
                        if (!b && isCloudRpt) {
                            b = (Boolean)Class.forName("com.kingdee.eas.rpts.ctrlreport.bo.CloudReportAuthBO").getMethod("hasDemoAuthByRptId", Context.class, String.class, String.class).invoke(null, ctx, reportID, userID);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                } else {
                    b = permission.hasDataPermission(isReport ? Constants.PERMISSION_NAME_THEME_CONFIG : Constants.PERMISSION_NAME_DASHBOARD_CONFIG, itemID);
                }
                if (b) {
                    return true;
                }
            }
        } else {
            int nChildCount = node.getChildCount();
            for (int n = 0; n < nChildCount; ++n) {
                boolean b = MetaData_EAS.hasDataPermission$VerifyExtReport((BITreeNode)node.getChildAt(n), treeType, permission, req);
                if (!b) continue;
                return true;
            }
        }
        return false;
    }

    public static void getNodePermissionIDList(SMResource node, int treeType, List list) throws BIReportException {
        boolean isFolder;
        boolean isReport = treeType == 6;
        boolean bl = isFolder = isReport ? RepositoryUtil.isThemeReport(node) : node instanceof SMFolder;
        if (isFolder) {
            SMResource[] sm = null;
            try {
                sm = ((SMFolder)node).getChildren();
            }
            catch (SMException e) {
                throw new BIReportException("\u8bfb\u53d6\u5b50\u7ed3\u70b9\u5931\u8d25!", e);
            }
            for (int n = 0; n < sm.length; ++n) {
                MetaData_EAS.getNodePermissionIDList(sm[n], treeType, list);
            }
        } else {
            String itemID = null;
            try {
                itemID = MetaData_EAS.gerPermissionID(node);
            }
            catch (SMException e) {
                throw new BIReportException("\u8bfb\u53d6\u7ed3\u70b9\u5c5e\u6027\u5931\u8d25!", e);
            }
            if (itemID != null) {
                BOSUuid bid = BOSUuid.read((String)itemID);
                ObjectUuidPK itemPK = new ObjectUuidPK("id", bid);
                list.add(itemPK);
            }
        }
    }

    public static void removeDataPermisstion(List listPermissionID, int treeType, Context ctx, boolean isWeb) throws BIReportException {
        if (listPermissionID.size() == 0) {
            return;
        }
        String permissionItemName = "";
        permissionItemName = treeType == 6 ? Constants.PERMISSION_NAME_THEME_CONFIG : Constants.PERMISSION_NAME_DASHBOARD_CONFIG;
        IDiscretePermission permission = null;
        try {
            permission = !isWeb ? DiscretePermissionFactory.getLocalInstance((Context)ctx) : DiscretePermissionFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            throw new BIReportException("\u65e0\u6cd5\u6743\u9650\u6821\u9a8c\u63a5\u53e3!", e);
        }
        BOSObjectType bosType = MetaData_EAS.getPermissionBosType(permissionItemName);
        try {
            permission.removeDiscretePermsByBoId(bosType, listPermissionID);
        }
        catch (EASBizException e) {
            throw new BIReportException("\u65e0\u6cd5\u5220\u9664\u6570\u636e\u6743\u9650\u9879!", e);
        }
        catch (BOSException e) {
            throw new BIReportException("\u65e0\u6cd5\u5220\u9664\u6570\u636e\u6743\u9650\u9879!", e);
        }
    }

    private static BOSObjectType getPermissionBosType(String permissionItemName) throws BIReportException {
        String classfullname = "";
        if (Constants.PERMISSION_NAME_THEME_CONFIG.equalsIgnoreCase(permissionItemName)) {
            classfullname = "com.kingdee.eas.framework.bireport.BIThemeAnalysisTreeInfo";
        } else if (Constants.PERMISSION_NAME_DASHBOARD_CONFIG.equalsIgnoreCase(permissionItemName)) {
            classfullname = "com.kingdee.eas.framework.bireport.BIDashboardTreeInfo";
        } else {
            throw new BIReportException("\u4e0d\u652f\u6301\u7684\u6743\u9650\u9879\u540d\u79f0\uff1a" + permissionItemName);
        }
        try {
            Class<?> c = Class.forName(classfullname);
            Method m = c.getMethod("getBOSType", null);
            Object o = c.getConstructor(null).newInstance(null);
            return (BOSObjectType)m.invoke(o, null);
        }
        catch (Exception e) {
            throw new BIReportException("\u65e0\u6cd5\u83b7\u53d6" + classfullname + "\u7684BosType", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getTreePathByID(Connection cn, String id, String type) {
        PreparedStatement stmt;
        ResultSet rs;
        StringBuffer path;
        block13: {
            path = new StringBuffer();
            String sql = null;
            if ("dashboard".equals(type)) {
                sql = "select FID,FLongNumber from T_FW_BIDashboardTree where FID='" + id + "'";
                path.append("/").append("dashboard_tree").append("/");
            } else if ("olap".equals(type) || "folder".equals(type)) {
                sql = "select FID,FLongNumber from T_FW_BIThemeAnalysisTree where FID='" + id + "'";
                path.append("report_tree").append("/");
            } else if ("ext".equals(type)) {
                sql = "select FID,FLongNumber from T_FW_BIThemeAnalysisTree where FID='" + id + "'";
                path.append("report_tree").append("/");
            } else if ("dupont".equals(type)) {
                sql = "select FID,FLongNumber from T_FW_BIThemeAnalysisTree where FID='" + id + "'";
                path.append("report_tree").append("/");
            } else if ("bimolap".equals(type)) {
                sql = "select FID,FLongNumber from T_FW_BIThemeAnalysisTree where FID='" + id + "'";
                path.append("report_tree").append("/");
            }
            rs = null;
            stmt = null;
            try {
                stmt = cn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block13;
                path.append(rs.getString("FLongNumber").replace('!', '/'));
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return path.toString();
    }
}

