/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.piece;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.XMLConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.jdom2.JDOMException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SnapshotPiece
implements Piece,
Serializable {
    private static final long serialVersionUID = -4795921218168441056L;
    private String name;
    private String caption;
    private String componentType;
    private String parentPath;
    private String pieceContent;
    private String themePath;

    public SnapshotPiece(String name, String caption, String parentPath, String pieceContent, String componenttype, String themePath) {
        this.name = name;
        this.caption = caption;
        this.componentType = componenttype;
        this.parentPath = parentPath;
        this.pieceContent = pieceContent;
        this.themePath = themePath;
    }

    public String getPieceContent() {
        return this.pieceContent;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public String save(HttpServletRequest request) throws BIReportException {
        Repository rep = null;
        try {
            rep = BISystem.getRepository(request);
            String string = rep.savePiece(this, BISystem.getCurrentUser(request));
            return string;
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u4fdd\u5b58\u9759\u6001\u5206\u6790\u7247\u6bb5" + this.name + "\u5931\u8d25! \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        finally {
            if (null != rep) {
                rep.close();
            }
        }
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private String toXML() {
        Document doc = XmlUtil.createDocument();
        Element eleRoot = doc.createElement("snapshot_piece");
        eleRoot.setAttribute("name", this.name);
        eleRoot.setAttribute("caption", this.caption);
        doc.appendChild(eleRoot);
        Element eleWorksheet = doc.createElement("worksheet");
        eleRoot.appendChild(eleWorksheet);
        CDATASection cdata = doc.createCDATASection(this.pieceContent);
        eleWorksheet.appendChild(cdata);
        StringWriter sw = new StringWriter();
        XmlUtil.print(doc, sw);
        return sw.toString();
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    public static SnapshotPiece fromXML(String xml, String name, String caption, String themePath) {
        XMLConfig xc = null;
        String pieceContent = "";
        try {
            xc = new XMLConfig(xml, "UTF-8");
            org.jdom2.Element[] element = xc.getNodes("/snapshot_piece/worksheet");
            if (element != null && element.length >= 1) {
                pieceContent = element[0].getText();
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new SnapshotPiece(name, caption, "", pieceContent, "worksheet", themePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBinaryData() {
        if (this.componentType.equalsIgnoreCase("worksheet")) {
            try {
                return this.toXML().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        String filename = this.pieceContent;
        if (filename == null) {
            return null;
        }
        File file = new File(System.getProperty("java.io.tmpdir"), filename);
        if (!file.exists()) {
            return new byte[0];
        }
        byte[] byteRead = new byte[(int)file.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int length = fis.read(byteRead);
            if (length != (int)file.length()) {
                byte[] ret = new byte[length];
                System.arraycopy(byteRead, 0, ret, 0, length);
                byte[] byArray = ret;
                return byArray;
            }
        }
        catch (FileNotFoundException length) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byteRead;
    }

    @Override
    public String getType() {
        return "snapshot";
    }

    @Override
    public String getThemeID() {
        return this.themePath;
    }
}

