/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.portlet;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.IPortletParameter;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletCollection;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletParameterCollection;
import com.kingdee.eas.portal.PortletParameterFactory;
import com.kingdee.eas.portal.PortletParameterInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PortletUtil {
    private static final Logger log = LogUtil.getPackageLogger(PortletUtil.class);
    public static final String PORTLET_DEFINEID = "portletDefineId";
    public static final String PORTLET_NUMBER = "portletNumber";
    public static final String PORTLET_NAME = "portletName";
    public static final String PORTLET_DESCRIPTION = "portletdescription";
    public static final String PORTLET_CU = "portletCU";
    public static final String PORTLET_CREATOR = "portletCreator";
    public static final String PORTLET_CREATETIME = "portletCreateTime";
    public static final String PORTLET_IS_TAB = "isTab";
    public static final String paramName_type = "paramName";
    public static final String paramValue = "paramValue";
    public static final String maskString = "#0";
    public static final String portletDefineId = "103";
    public static final String paramValue_path = "permissionID";

    public static String publishPortlet(Context ctx, Map params) throws BOSException, EASBizException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, SAXException {
        IPortlet iportlet = PortletFactory.getRemoteInstance();
        PortletInfo portletInfo = new PortletInfo();
        portletInfo.setId(BOSUuid.create((BOSObjectType)portletInfo.getBOSType()));
        portletInfo.setPortletDefineId((String)params.get(PORTLET_DEFINEID));
        portletInfo.setPortletNumber((String)params.get(PORTLET_NUMBER));
        portletInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        portletInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        portletInfo.setCreateTime(new Timestamp(new Date().getTime()));
        Locale[] loc = ApplicationUtil.getContextLocales((Context)ctx);
        Locale tempLoc2 = null;
        for (Locale tempLoc2 : loc) {
            portletInfo.setPortletName((String)params.get(PORTLET_NAME), tempLoc2);
            portletInfo.setDescription((String)params.get(PORTLET_DESCRIPTION), tempLoc2);
        }
        PortletParameterInfo paramInfo = new PortletParameterInfo();
        paramInfo.setCU(portletInfo.getCU());
        paramInfo.setCreator(portletInfo.getCreator());
        paramInfo.setCreateTime(portletInfo.getCreateTime());
        paramInfo.setParamName((String)params.get(paramName_type));
        paramInfo.setParamValue((String)params.get(paramValue_path));
        portletInfo.getParams().add(paramInfo);
        portletInfo.setEnable(PortletStateEnum.PORTLET_RUN);
        IObjectPK pk = iportlet.addnew((CoreBaseInfo)portletInfo);
        PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
        return pk.toString();
    }

    public static void updatePortlet(Context ctx, Map params) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(paramValue, (Object)((String)params.get(paramValue_path)), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        IPortletParameter iParam = null;
        PortletParameterInfo paramInfo = null;
        PortletParameterCollection paramCols = null;
        iParam = PortletParameterFactory.getRemoteInstance();
        paramCols = iParam.getPortletParameterCollection(ev);
        if (paramCols != null && paramCols.size() > 0) {
            paramInfo = paramCols.get(0);
            PortletInfo porInfo = null;
            porInfo = paramInfo.getPortlet();
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)porInfo.getId().toString(), CompareType.EQUALS));
            filter.setMaskString(" #0 ");
            ev.setFilter(filter);
            IPortlet iPortlet = null;
            PortletCollection porCols = null;
            iPortlet = PortletFactory.getRemoteInstance();
            porCols = iPortlet.getPortletCollection(ev);
            if (porCols != null && porCols.size() > 0) {
                porInfo = porCols.get(0);
                Locale[] loc = ApplicationUtil.getContextLocales((Context)ctx);
                Locale tempLoc2 = null;
                for (Locale tempLoc2 : loc) {
                    porInfo.setPortletName((String)params.get(PORTLET_NAME), tempLoc2);
                    porInfo.setDescription((String)params.get(PORTLET_DESCRIPTION), tempLoc2);
                }
                porInfo.setPortletNumber((String)params.get(PORTLET_NUMBER));
                String path = (String)params.get(paramValue_path);
                String oldPath = (String)params.get("old");
                paramInfo.setParamName((String)params.get(paramName_type));
                paramInfo.setParamValue(oldPath == null ? path : oldPath);
                porInfo.getParams().add(paramInfo);
                iPortlet.update((IObjectPK)new ObjectUuidPK(porInfo.getId()), (CoreBaseInfo)porInfo);
                try {
                    PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
            }
            IPortalServiceFacade portalService = PortalServiceFacadeFactory.getRemoteInstance();
            portalService.enablePortlet(porInfo.getId().toString());
            portalService.refreshPortletCache();
        } else {
            String permissionId = (String)params.get(paramValue_path);
            String flag = (String)params.get("flag");
            if (permissionId.indexOf("@//") != -1) {
                if (permissionId.split("@//")[1].equalsIgnoreCase("true") && (flag == null || "false".equals(flag))) {
                    String pId = permissionId.split("@//")[0];
                    params.put(paramValue_path, pId + "@//" + "false");
                    params.put("old", permissionId);
                    params.put("flag", flag == null ? "true" : "next");
                    PortletUtil.updatePortlet(ctx, params);
                } else if (permissionId.split("@//")[1].equalsIgnoreCase("false") && (flag == null || "true".equals(flag))) {
                    String pId = permissionId.split("@//")[0];
                    params.put(paramValue_path, pId + "@//" + "true");
                    params.put("old", permissionId);
                    params.put("flag", flag == null ? "false" : "next");
                    PortletUtil.updatePortlet(ctx, params);
                } else if ("next".equals(flag)) {
                    String pId = permissionId.split("@//")[0];
                    params.put(paramValue_path, pId);
                    params.put("old", permissionId);
                    params.put("flag", "end");
                    PortletUtil.updatePortlet(ctx, params);
                }
            }
        }
    }

    public static void deletePortlet(Context ctx, String pk) throws BOSException, EASBizException {
        IPortalServiceFacade portalService = PortalServiceFacadeFactory.getRemoteInstance();
        portalService.deletePortlet(pk);
        portalService.refreshPortletCache();
    }

    public static String getURLFromNodePath(HttpServletRequest request, String portletType, String nodePath) throws BIReportException {
        String url;
        String ctxPath = request.getContextPath();
        String servletURL = ctxPath + "/" + Constants.SERVLET_URL;
        if ("olap".equalsIgnoreCase(portletType)) {
            url = ctxPath + "/biweb/html/report_loader.htm?servletURL=" + servletURL + "&load=" + servletURL + "?servletType=" + "report" + "&repositoryPath=" + nodePath;
        } else if ("ext".equalsIgnoreCase(portletType)) {
            url = ctxPath + "/biweb/html/report_loader.htm?servletURL=" + servletURL + "&load=" + servletURL + "?servletType=" + "extReport" + "&repositoryPath=" + nodePath;
        } else if ("dupont".equalsIgnoreCase(portletType)) {
            url = ctxPath + "/biweb/html/report_loader.htm?servletURL=" + servletURL + "&load=" + servletURL + "?servletType=" + "dupontReport" + "&repositoryPath=" + nodePath;
        } else if ("dashboard".equalsIgnoreCase(portletType)) {
            url = ctxPath + "/biweb/dashboard/show_dashboard.htm?requestType=get&url=" + servletURL + "?servletType=" + "BIDashBoard" + "&dashboard_path=" + nodePath;
        } else if ("folder".equalsIgnoreCase(portletType)) {
            url = ctxPath + "/biweb/html/themeAnalysisPortlet.htm?folderPath=" + nodePath;
        } else if ("bimolap".equals(portletType)) {
            url = ctxPath + "/biweb/html/report_loader.htm?servletURL=" + servletURL + "&load=" + servletURL + "?servletType=" + "bimOlapReport" + "&repositoryPath=" + nodePath;
        } else {
            throw new BIReportException("\u672a\u77e5\u7684portlet\u7c7b\u578b" + portletType + "!");
        }
        return url + "&from=portlet";
    }
}

