/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.def;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourceDef {
    private InputStream is;
    private Document root;

    public DataSourceDef(InputStream is) {
        this.is = is;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Document getDocument() throws BIReportException {
        if (this.root != null) {
            return this.root;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.root = builder.parse(this.is);
            return this.root;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
    }

    public Map getAllTableInfo() throws BIReportException {
        HashMap<IgnoreCaseString, String> hm = new HashMap<IgnoreCaseString, String>();
        Document doc = this.getDocument();
        Element rootXML = doc.getDocumentElement();
        NodeList dsList = rootXML.getElementsByTagName("Table");
        for (int i = 0; i < dsList.getLength(); ++i) {
            Node dsNode = dsList.item(i);
            if (!(dsNode instanceof Element)) continue;
            Element dsElement = (Element)dsNode;
            String dsName = dsElement.getAttribute("name");
            String dsValue = XmlUtil.getNodeCDataValue(dsElement);
            dsValue = dsValue.replaceAll("\t", " ");
            dsValue = dsValue.replaceAll("\n", " ");
            String tagName = XmlUtil.getNodeCDataTagname(dsElement);
            if ("sql".equalsIgnoreCase(tagName)) {
                hm.put(new IgnoreCaseString(dsName), dsValue);
                continue;
            }
            throw new BIReportException("todo tagName:" + tagName);
        }
        return hm;
    }
}

