/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.impl;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BIComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BILayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class BITableLayout
implements BILayout {
    private Map mapComponents = null;
    private List[] rowCells = null;
    private int columns = 0;
    private Map mapMerge = new HashMap();

    public BITableLayout(Node node, Map mapComponents) throws Exception {
        this.mapComponents = mapComponents;
        this.loadXMLNode(node);
    }

    private boolean cellIgnoreByMerge(int row, int column) {
        for (MergeCell cell : this.mapMerge.values()) {
            if (!cell.inMergeCell(row, column)) continue;
            return true;
        }
        return false;
    }

    private void loadXMLNode(Node node) throws Exception {
        Node nodeTable = XmlUtil.getChildNode(node, "Table");
        Node nodeMerge = XmlUtil.getChildNode(node, "Merge");
        Node[] nodeBlocks = XmlUtil.getChildNodes(nodeMerge, "Block");
        for (int index = 0; index < nodeBlocks.length; ++index) {
            int row = Integer.parseInt(XmlUtil.getNodeAttribute(nodeBlocks[index], "row"));
            int col = Integer.parseInt(XmlUtil.getNodeAttribute(nodeBlocks[index], "col"));
            int colSpan = Integer.parseInt(XmlUtil.getNodeAttribute(nodeBlocks[index], "colspan"));
            int rowSpan = Integer.parseInt(XmlUtil.getNodeAttribute(nodeBlocks[index], "rowspan"));
            this.mapMerge.put(new Integer(row * 1000 + col), new MergeCell(row, col, rowSpan, colSpan));
        }
        Node[] nodeTRs = XmlUtil.getChildNodes(nodeTable, "TR");
        this.rowCells = new List[nodeTRs.length];
        boolean hasComponent = false;
        for (int index = 0; index < this.rowCells.length; ++index) {
            Node nodeTR = nodeTRs[index];
            Node[] nodeTDs = XmlUtil.getChildNodes(nodeTR, "TD");
            this.columns = nodeTDs.length;
            this.rowCells[index] = new ArrayList();
            for (int index2 = 0; index2 < nodeTDs.length; ++index2) {
                Object obj;
                if (this.cellIgnoreByMerge(index, index2)) continue;
                String componentName = "";
                int rowSpan = 1;
                int colSpan = 1;
                Node nodeTD = nodeTDs[index2];
                if (nodeTD.getFirstChild() != null) {
                    componentName = nodeTD.getFirstChild().getNodeValue();
                }
                if ((obj = this.mapMerge.get(new Integer(index * 1000 + index2))) instanceof MergeCell) {
                    MergeCell mergeCell = (MergeCell)obj;
                    rowSpan = mergeCell.getRowSpan();
                    colSpan = mergeCell.getColSpan();
                }
                Cell cell = new Cell(componentName, rowSpan, colSpan);
                this.rowCells[index].add(cell);
                if (componentName.equals("")) continue;
                hasComponent = true;
            }
        }
        if (!hasComponent) {
            throw new Exception("No component error!");
        }
    }

    @Override
    public int getCellColSpan(int row, int index) {
        Cell cell = (Cell)this.rowCells[row].get(index);
        return cell.getColSpan();
    }

    @Override
    public BIComponent getCellComponent(int row, int index) {
        Cell cell = (Cell)this.rowCells[row].get(index);
        String name = cell.getComponentName();
        return (BIComponent)this.mapComponents.get(name);
    }

    @Override
    public int getCellRowSpan(int row, int index) {
        Cell cell = (Cell)this.rowCells[row].get(index);
        return cell.getRowSpan();
    }

    @Override
    public int getRowCellCount(int row) {
        return this.rowCells[row].size();
    }

    @Override
    public int getRows() {
        return this.rowCells.length;
    }

    public int getColumns() {
        return this.columns;
    }

    class Cell {
        private int rowSpan;
        private int colSpan;
        private String componentName;

        public Cell(String name, int rowSpan, int colSpan) {
            this.componentName = name;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
        }

        public int getColSpan() {
            return this.colSpan;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }
    }

    class MergeCell {
        private int row;
        private int column;
        private int rowSpan;
        private int colSpan;

        public MergeCell(int row, int column, int rowSpan, int colSpan) {
            this.row = row;
            this.column = column;
            this.colSpan = colSpan;
            this.rowSpan = rowSpan;
        }

        public boolean inMergeCell(int row, int column) {
            if (row == this.row && column == this.column) {
                return false;
            }
            return row >= this.row && row <= this.row + this.rowSpan - 1 && column >= this.column && column <= this.column + this.colSpan - 1;
        }

        public int getColSpan() {
            return this.colSpan;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }
    }
}

