/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services;

import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.Interceptor;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorFilter;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceConfig;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceContext;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceItemMap;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.IMiniServer;
import com.kingdee.bos.ctrl.bibench.platform.services.util.Util;
import java.util.List;

public class ServiceLauncher {
    private IServiceManager manager = null;
    private IMiniServer server = null;
    private ServiceContext context = null;

    public ServiceLauncher(ServiceContext context) {
        this.context = context;
    }

    public ServiceContext getServiceContext() {
        return this.context;
    }

    private IMiniServer createServer() throws Exception {
        String serverClass = this.context.getServiceConfig().getServiceServerClass();
        return (IMiniServer)Util.createObject(serverClass, IMiniServer.class);
    }

    private IServiceManager createManager() throws Exception {
        String serverClass = this.context.getServiceConfig().getServiceManagerClass();
        IServiceManager service = (IServiceManager)Util.createObject(serverClass, IServiceManager.class);
        service.setServiceContext(this.context);
        return service;
    }

    public IServiceManager getServiceManager() {
        return this.manager;
    }

    public IMiniServer getMiniServer() {
        return this.server;
    }

    public void start() throws Exception {
        int i;
        this.manager = this.createManager();
        this.server = this.createServer();
        ServiceConfig sc = this.context.getServiceConfig();
        List filters = Util.createObjects(sc.getServiceFilterClasses(), InterceptorFilter.class);
        List interceptors = Util.createObjects(sc.getServiceInterceptorClasses(), Interceptor.class);
        List services = sc.getServiceItemMapList();
        for (i = 0; i < filters.size(); ++i) {
            this.manager.addInterceptorFilter((InterceptorFilter)filters.get(i));
        }
        for (i = 0; i < interceptors.size(); ++i) {
            this.manager.addInterceptor((Interceptor)interceptors.get(i));
        }
        for (i = 0; i < services.size(); ++i) {
            ServiceItemMap item = (ServiceItemMap)services.get(i);
            this.server.addService(item.getInterfaceClassName(), item.getImplementsClassName(), this.manager);
        }
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }
}

