/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.chart.Chart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class KDChartServletNew
extends HttpServlet {
    private static final long serialVersionUID = 191788956157671696L;

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        req.setCharacterEncoding("utf-8");
        res.setContentType("image/jpeg;charset=utf-8");
        String chartType = req.getParameter("charttype");
        String groupKeys = req.getParameter("groupkeys");
        String values = req.getParameter("values");
        String seriesKeys = req.getParameter("serieskeys");
        String width = req.getParameter("width");
        String height = req.getParameter("height");
        String title = req.getParameter("title");
        String fontFamily = req.getParameter("fontfamily");
        String fontSize = req.getParameter("fontsize");
        String fontStyle = req.getParameter("fontStyle");
        String background = req.getParameter("background");
        int iFontSize = 12;
        try {
            iFontSize = Integer.parseInt(fontSize);
        }
        catch (Exception e) {
            iFontSize = 12;
        }
        int iFontStyle = 0;
        try {
            iFontStyle = Integer.parseInt(fontStyle);
        }
        catch (Exception e) {
            iFontStyle = 0;
        }
        chartType = chartType.toLowerCase();
        groupKeys = new String(groupKeys.getBytes("ISO8859-1"), "UTF-8");
        seriesKeys = new String(seriesKeys.getBytes("ISO8859-1"), "UTF-8");
        values = new String(values.getBytes("ISO8859-1"), "UTF-8");
        title = new String(title.getBytes("ISO8859-1"), "UTF-8");
        fontFamily = new String(fontFamily.getBytes("ISO8859-1"), "UTF-8");
        int w = Integer.parseInt(width);
        int h = Integer.parseInt(height);
        try {
            PieChartData pieChartData = null;
            CommonChartData commonChartData = null;
            GanttChartData ganttChartData = null;
            KDChart chart = new KDChart();
            if (chartType.equals("pie")) {
                pieChartData = this.getPieChartData(groupKeys, values);
                chart.setChartType(ChartType.CT_PIE);
                chart.addChartData(pieChartData);
            } else if (chartType.equals("pie3d")) {
                pieChartData = this.getPieChartData(groupKeys, values);
                chart.setChartType(ChartType.CT_PIE3D);
                chart.addChartData(pieChartData);
            } else if (chartType.equals("pieexploded")) {
                pieChartData = this.getPieChartData(groupKeys, values);
                chart.setChartType(ChartType.CT_PIEEXPLODED);
                chart.addChartData(pieChartData);
            } else if (chartType.equals("gantt")) {
                ganttChartData = this.getGanttChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_GANTT);
                chart.addChartData(ganttChartData);
            } else if (chartType.equals("columnclustered")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_COLUMNCLUSTERED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("columnclustered3d")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_COLUMNCLUSTERED3D);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("columnsstacked")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_COLUMNSTACKED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("columnstacked3d")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_COLUMNSTACKED3D);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("barclustered")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_BARCLUSTERED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("barclustered3d")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_BARCLUSTERED3D);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("barstacked")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_BARSTACKED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("barstacked3d")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_BARSTACKED3D);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("line")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_LINE);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("linestacked")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_LINESTACKED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("linemarkers")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_LINEMARKERS);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("linemarkersstacked")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_LINEMARKERSSTACKED);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("xyscatter")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_XYSCATTER);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("xyscatterlines")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_XYSCATTERLINES);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("xyscatterlinesnomarkers")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_XYSCATTERLINESNOMARKERS);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("area")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_AREA);
                chart.addChartData(commonChartData);
            } else if (chartType.equals("areastacked")) {
                commonChartData = this.getCommonChartData(seriesKeys, groupKeys, values);
                chart.setChartType(ChartType.CT_AREASTACKED);
                chart.addChartData(commonChartData);
            }
            this.setChartTitle(chart, title);
            this.setChartFont(chart, fontFamily, iFontStyle, iFontSize);
            chart.setBackground(Color.getColor(background));
            chart.writeChartAsJPEG((OutputStream)res.getOutputStream(), 100.0f, chart.getDelegate(), w, h, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setChartTitle(KDChart chart, String title) {
        chart.getChartTitle().setText(title);
    }

    protected void setChartFont(Chart chart, String fontFamily, int fontStyle, int fontSize) {
        KDFont font = new KDFont(fontFamily, fontStyle, fontSize);
        chart.setFont((Font)font);
        chart.getChartTitle().setFont(font);
    }

    protected void setChartType(KDChart chart, ChartType type) {
        chart.setChartType(type);
    }

    public PieChartData getPieChartData(String groupKeys, String values) {
        String[] groupKeys1 = groupKeys.split(",");
        String[] values1 = values.split(",");
        int valueLen = values1.length;
        double[] values2 = new double[valueLen];
        for (int i = 0; i < valueLen; ++i) {
            values2[i] = new Double(values1[i]);
        }
        return ChartDataUtil.createPieChartData(groupKeys1, values2);
    }

    public CommonChartData getCommonChartData(String seriesKeys, String groupKeys, String values) {
        String[] seriesKeys1 = seriesKeys.split(",");
        String[] groupKeys1 = groupKeys.split(",");
        String[] values1 = values.split(";");
        int valueLen1 = values1.length;
        int valueLen2 = values1[0].split(",").length;
        double[][] values3 = new double[valueLen1][valueLen2];
        for (int i = 0; i < valueLen1; ++i) {
            String[] values2 = values1[i].split(",");
            for (int j = 0; j < valueLen2; ++j) {
                values3[i][j] = new Double(values2[j]);
            }
        }
        return ChartDataUtil.createCommonChartData(seriesKeys1, groupKeys1, values3);
    }

    public GanttChartData getGanttChartData(String seriesKeys, String groupKeys, String values) {
        String[] seriesKeys1 = seriesKeys.split(",");
        String[] groupKeys1 = groupKeys.split(",");
        String[] values1 = values.split("~");
        int valueLen1 = values1.length;
        int valueLen2 = values1[0].split(";").length;
        int valueLen3 = values1[0].split(";")[0].split(",").length;
        Date[][][] values4 = new Date[valueLen1][valueLen2][valueLen3];
        for (int i = 0; i < valueLen1; ++i) {
            String[] values2 = values1[i].split(";");
            for (int j = 0; j < valueLen2; ++j) {
                String[] values3 = values2[j].split(",");
                for (int k = 0; k < valueLen3; ++k) {
                    values4[i][j][k] = new Date(new Long(values3[k]));
                }
            }
        }
        return ChartDataUtil.createGanttData(seriesKeys1, groupKeys1, values4);
    }
}

