/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.chart.panel.LegendPropertyEditPanel;
import com.kingdee.bos.ctrl.swing.chart.panel.PlotPropertyEditPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Legend;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.ui.TitlePropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;

public class ChartPropertyEditPanel
extends KDPanel
implements ActionListener {
    public static final long serialVersionUID = 1001001001L;
    private LegendPropertyEditPanel legendPropertiesPanel;
    private PlotPropertyEditPanel plotPropertiesPanel;
    private KDCheckBox antialias;
    private PaintSample background;

    public ChartPropertyEditPanel(JFreeChart chart) {
        this.setLayout(new BorderLayout());
        KDPanel other = new KDPanel((LayoutManager)new BorderLayout());
        other.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        KDPanel general = new KDPanel((LayoutManager)new BorderLayout());
        general.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageManager.getLangMessage((String)"General", ChartPropertyEditPanel.class, (String)"General")));
        KDPanel interior = new KDPanel((LayoutManager)new LCBLayout(6));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.antialias = new KDCheckBox(LanguageManager.getLangMessage((String)"Draw_anti-aliased", ChartPropertyEditPanel.class, (String)"Draw anti-aliased"));
        this.antialias.setSelected(chart.getAntiAlias());
        interior.add((Component)this.antialias);
        interior.add((Component)new KDLabel(""));
        interior.add((Component)new KDLabel(""));
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Background_paint", ChartPropertyEditPanel.class, (String)"Background Paint")));
        this.background = new PaintSample(chart.getBackgroundPaint());
        interior.add((Component)this.background);
        KDButton button = new KDButton(LanguageManager.getLangMessage((String)"Select...", ChartPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("BackgroundPaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_Paint", ChartPropertyEditPanel.class, (String)"Series Paint")));
        KDTextField info = new KDTextField(LanguageManager.getLangMessage((String)"No_editor_implemented", ChartPropertyEditPanel.class, (String)"No Editor Implemented"));
        info.setEnabled(false);
        interior.add((Component)info);
        button = new KDButton(LanguageManager.getLangMessage((String)"Edit...", ChartPropertyEditPanel.class, (String)"Edit..."));
        button.setEnabled(false);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_Stroke", ChartPropertyEditPanel.class, (String)"Series Stroke")));
        info = new KDTextField(LanguageManager.getLangMessage((String)"No_editor_implemented", ChartPropertyEditPanel.class, (String)"No Editor Implemented"));
        info.setEnabled(false);
        interior.add((Component)info);
        button = new KDButton(LanguageManager.getLangMessage((String)"Edit...", ChartPropertyEditPanel.class, (String)"Edit..."));
        button.setEnabled(false);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_Outline_Paint", ChartPropertyEditPanel.class, (String)"Series Outline Paint")));
        info = new KDTextField(LanguageManager.getLangMessage((String)"No_editor_implemented", ChartPropertyEditPanel.class, (String)"No Editor Implemented"));
        info.setEnabled(false);
        interior.add((Component)info);
        button = new KDButton(LanguageManager.getLangMessage((String)"Edit...", ChartPropertyEditPanel.class, (String)"Edit..."));
        button.setEnabled(false);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_Outline_Stroke", ChartPropertyEditPanel.class, (String)"Series Outline Stroke")));
        info = new KDTextField(LanguageManager.getLangMessage((String)"No_editor_implemented", ChartPropertyEditPanel.class, (String)"No Editor Implemented"));
        info.setEnabled(false);
        interior.add((Component)info);
        button = new KDButton(LanguageManager.getLangMessage((String)"Edit...", ChartPropertyEditPanel.class, (String)"Edit..."));
        button.setEnabled(false);
        interior.add((Component)button);
        general.add((Component)interior, (Object)"North");
        other.add((Component)general, (Object)"North");
        KDPanel parts = new KDPanel((LayoutManager)new BorderLayout());
        Legend legend = chart.getLegend();
        Plot plot = chart.getPlot();
        KDTabbedPane tabs = new KDTabbedPane();
        if (legend != null) {
            this.legendPropertiesPanel = new LegendPropertyEditPanel(legend);
            this.legendPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.addTab(LanguageManager.getLangMessage((String)"Legend", ChartPropertyEditPanel.class, (String)"Legend"), (Component)((Object)this.legendPropertiesPanel));
        }
        this.plotPropertiesPanel = new PlotPropertyEditPanel(plot);
        this.plotPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab(LanguageManager.getLangMessage((String)"Plot", ChartPropertyEditPanel.class, (String)"Plot"), (Component)((Object)this.plotPropertiesPanel));
        tabs.add(LanguageManager.getLangMessage((String)"Other", ChartPropertyEditPanel.class, (String)"Other"), (Component)other);
        parts.add((Component)tabs, (Object)"North");
        this.add((Component)parts);
    }

    public TitlePropertyEditPanel getTitlePropertyEditPanel() {
        return null;
    }

    public LegendPropertyEditPanel getLegendPropertyEditPanel() {
        return this.legendPropertiesPanel;
    }

    public PlotPropertyEditPanel getPlotPropertyEditPanel() {
        return this.plotPropertiesPanel;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    public Paint getBackgroundPaint() {
        return this.background.getPaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Background_Color", ChartPropertyEditPanel.class, (String)"Background Color"), (Color)Color.blue);
        if (c != null) {
            this.background.setPaint((Paint)c);
        }
    }

    public void updateChartProperties(JFreeChart chart) {
        if (this.legendPropertiesPanel != null) {
            this.legendPropertiesPanel.setLegendProperties(chart.getLegend());
        }
        this.plotPropertiesPanel.updatePlotProperties(chart.getPlot());
        chart.setAntiAlias(this.getAntiAlias());
        chart.setBackgroundPaint(this.getBackgroundPaint());
    }
}

