/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.chart.panel.AxisPropertyEditPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

public class NumberAxisPropertyEditPanel
extends AxisPropertyEditPanel
implements FocusListener {
    public static final long serialVersionUID = 1001001001L;
    private boolean autoRange;
    private double minimumValue;
    private double maximumValue;
    private KDCheckBox autoRangeCheckBox;
    private KDTextField minimumRangeValue;
    private KDTextField maximumRangeValue;
    private PaintSample gridPaintSample;
    private StrokeSample gridStrokeSample;
    private StrokeSample[] availableStrokeSamples;

    public NumberAxisPropertyEditPanel(NumberAxis axis) {
        super((Axis)axis);
        this.autoRange = axis.isAutoRange();
        this.minimumValue = axis.getLowerBound();
        this.maximumValue = axis.getUpperBound();
        this.gridPaintSample = new PaintSample((Paint)Color.blue);
        this.gridStrokeSample = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        KDTabbedPane other = this.getOtherTabs();
        KDPanel range = new KDPanel((LayoutManager)new LCBLayout(3));
        range.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        range.add((Component)new KDPanel());
        this.autoRangeCheckBox = new KDCheckBox(LanguageManager.getLangMessage((String)"Auto-adjust_range", NumberAxisPropertyEditPanel.class, (String)"Auto-adjust Range"), this.autoRange);
        this.autoRangeCheckBox.setActionCommand("AutoRangeOnOff");
        this.autoRangeCheckBox.addActionListener((ActionListener)this);
        range.add((Component)this.autoRangeCheckBox);
        range.add((Component)new KDPanel());
        range.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Minimum_range_value", NumberAxisPropertyEditPanel.class, (String)"Minimum Range Value")));
        this.minimumRangeValue = new KDTextField(Double.toString(this.minimumValue));
        this.minimumRangeValue.setEnabled(!this.autoRange);
        this.minimumRangeValue.setActionCommand("MinimumRange");
        this.minimumRangeValue.addActionListener((ActionListener)this);
        this.minimumRangeValue.addFocusListener((FocusListener)this);
        range.add((Component)this.minimumRangeValue);
        range.add((Component)new KDPanel());
        range.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Maximum_range_value", NumberAxisPropertyEditPanel.class, (String)"Maximum Range Value")));
        this.maximumRangeValue = new KDTextField(Double.toString(this.maximumValue));
        this.maximumRangeValue.setEnabled(!this.autoRange);
        this.maximumRangeValue.setActionCommand("MaximumRange");
        this.maximumRangeValue.addActionListener((ActionListener)this);
        this.maximumRangeValue.addFocusListener((FocusListener)this);
        range.add((Component)this.maximumRangeValue);
        range.add((Component)new KDPanel());
        other.add(LanguageManager.getLangMessage((String)"Range", NumberAxisPropertyEditPanel.class, (String)"Range"), (Component)range);
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("GridStroke")) {
            this.attemptGridStrokeSelection();
        } else if (command.equals("GridPaint")) {
            this.attemptGridPaintSelection();
        } else if (command.equals("AutoRangeOnOff")) {
            this.toggleAutoRange();
        } else if (command.equals("MinimumRange")) {
            this.validateMinimum();
        } else if (command.equals("MaximumRange")) {
            this.validateMaximum();
        } else {
            super.actionPerformed(event);
        }
    }

    private void attemptGridStrokeSelection() {
        StrokeChooserPanel panel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Stroke_Selection", NumberAxisPropertyEditPanel.class, (String)"Stroke Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.gridStrokeSample.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptGridPaintSelection() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Grid_Color", NumberAxisPropertyEditPanel.class, (String)"Grid_Color"), (Color)Color.blue);
        if (c != null) {
            this.gridPaintSample.setPaint((Paint)c);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.getSource() == this.minimumRangeValue) {
            this.validateMinimum();
        } else if (event.getSource() == this.maximumRangeValue) {
            this.validateMaximum();
        }
    }

    public void toggleAutoRange() {
        this.autoRange = this.autoRangeCheckBox.isSelected();
        if (this.autoRange) {
            this.minimumRangeValue.setText(Double.toString(this.minimumValue));
            this.minimumRangeValue.setEnabled(false);
            this.maximumRangeValue.setText(Double.toString(this.maximumValue));
            this.maximumRangeValue.setEnabled(false);
        } else {
            this.minimumRangeValue.setEnabled(true);
            this.maximumRangeValue.setEnabled(true);
        }
    }

    public void validateMinimum() {
        double newMin;
        try {
            newMin = Double.parseDouble(this.minimumRangeValue.getText());
            if (newMin >= this.maximumValue) {
                newMin = this.minimumValue;
            }
        }
        catch (NumberFormatException e) {
            newMin = this.minimumValue;
        }
        this.minimumValue = newMin;
        this.minimumRangeValue.setText(Double.toString(this.minimumValue));
    }

    public void validateMaximum() {
        double newMax;
        try {
            newMax = Double.parseDouble(this.maximumRangeValue.getText());
            if (newMax <= this.minimumValue) {
                newMax = this.maximumValue;
            }
        }
        catch (NumberFormatException e) {
            newMax = this.maximumValue;
        }
        this.maximumValue = newMax;
        this.maximumRangeValue.setText(Double.toString(this.maximumValue));
    }

    @Override
    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setAutoRange(this.autoRange);
        if (!this.autoRange) {
            numberAxis.setRange(this.minimumValue, this.maximumValue);
        }
    }
}

