/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.title;

import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.chart.title.ITitle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.title.TextTitle;

public class ChartTitle
implements ITitle {
    public static final Paint DEFAULT_PAINT = Color.black;
    private String text;
    private KDFont font;
    private Paint paint = DEFAULT_PAINT;
    private Paint backgroundPaint;
    TextTitle delegate = new TextTitle("", (Font)this.getDefaultFont());

    public ChartTitle() {
        this("", null, DEFAULT_PAINT, null);
    }

    public ChartTitle(String text) {
        this(text, null);
    }

    public ChartTitle(String text, KDFont font) {
        this(text, font, DEFAULT_PAINT);
    }

    public ChartTitle(String text, KDFont font, Paint paint) {
        this(text, font, paint, null);
    }

    public ChartTitle(String text, KDFont font, Paint paint, Paint backgroundPaint) {
        this.setText(text);
        this.setFont(font);
        this.setPaint(paint);
        this.setBackgroundPaint(backgroundPaint);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.delegate.setText(text);
    }

    @Override
    public KDFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(KDFont font) {
        if (font == null) {
            font = this.getDefaultFont();
        }
        this.font = font;
        try {
            this.delegate.setFont((Font)font);
        }
        catch (Throwable e) {
            this.font = this.getDefaultFont();
            this.delegate.setFont((Font)this.getDefaultFont());
        }
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        this.delegate.setPaint(paint);
    }

    @Override
    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    @Override
    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
        this.delegate.setBackgroundPaint(backgroundPaint);
    }

    public void setDelegate(TextTitle delegate) {
        this.delegate = delegate;
        delegate.setFont((Font)this.font);
        delegate.setPaint(this.paint);
        delegate.setBackgroundPaint(this.backgroundPaint);
    }

    private KDFont getDefaultFont() {
        KDFont font;
        try {
            font = new KDFont("\u5b8b\u4f53", 0, 12);
        }
        catch (Throwable e) {
            font = new KDFont(null, 0, 12);
        }
        return font;
    }
}

