/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.layout.table;

import com.kingdee.bos.ctrl.common.layout.table.SizeAdjustor;
import com.kingdee.bos.ctrl.common.layout.table.Style;
import com.kingdee.bos.ctrl.common.layout.table.StyleInfo;
import com.kingdee.bos.ctrl.common.layout.table.Table;

class TableInfo {
    int _count;
    SizeAdjustor _adjustor;
    private SizeAdjustor _readjust = null;
    Style[] _aStyle;
    private boolean _isX;
    private Table _table;

    TableInfo(boolean isX, Table table) {
        this._isX = isX;
        this._count = isX ? table._cols : table._rows;
        this._table = table;
        this._aStyle = new Style[this._count];
        this._adjustor = new SizeAdjustor(this._count);
    }

    private StyleInfo getStyleInfo(Style style) {
        return this._isX ? style._x : style._y;
    }

    protected void makeOutInfo() {
        Style outStyle = new Style();
        for (int i = 0; i < this._count; ++i) {
            if (this._aStyle[i] == null) {
                outStyle.copy(this._table._defaultStyle);
            } else {
                outStyle.copy(this._aStyle[i]);
                outStyle.makeFields(this._table._defaultStyle);
            }
            this._adjustor.getInfoAt(i).init(this.getStyleInfo(outStyle));
            if (outStyle.isVisible()) continue;
            this._adjustor.getInfoAt(i).setConstant(0);
        }
    }

    protected boolean fitSpace(int space) {
        StyleInfo si;
        Style style = this._table._style;
        if (style != null && (si = this.getStyleInfo(style)).has(this._isX ? 256 : 1)) {
            if (si.isPercent()) {
                if (space < 0) {
                    this._readjust = new SizeAdjustor(this._adjustor);
                    this._adjustor.useSpace();
                    return false;
                }
                space = (space - si.getMargin()) * -si.getVal() / 100;
            } else {
                space = si.getVal();
            }
            this._adjustor.fitSpace(space);
            return true;
        }
        this._adjustor.useSpace();
        return true;
    }

    protected boolean readjustSpace(int space) {
        if (this._readjust != null) {
            this._adjustor = this._readjust;
            this._readjust = null;
            this.fitSpace(space);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this._count; ++i) {
            if (this._aStyle[i] == null) continue;
            s.append("\r\n[" + i + "] <Style>" + this._aStyle[i].toString() + "</Style>");
        }
        return "<Adjustor>" + this._adjustor.toString() + "\r\n</Adjustor>\r\n<Styles>" + s.toString() + "\r\n</Styles>";
    }
}

