/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.WrapableArray;

public class ArrayWrapper {
    private WrapableArray wrappableArray;
    private int[] indexMap;
    private boolean[] nullVals;
    private int maxSize;
    private int size;
    private float loadFactor;

    public Object clone() {
        ArrayWrapper wrapper = new ArrayWrapper(this.loadFactor);
        wrapper.size = this.size;
        wrapper.maxSize = this.maxSize;
        wrapper.nullVals = new boolean[this.nullVals.length];
        wrapper.indexMap = new int[this.indexMap.length];
        System.arraycopy(this.nullVals, 0, wrapper.nullVals, 0, this.nullVals.length);
        System.arraycopy(this.indexMap, 0, wrapper.indexMap, 0, this.indexMap.length);
        return wrapper;
    }

    public ArrayWrapper() {
        this(0.75f);
    }

    public ArrayWrapper(float lf) {
        this(10, lf);
    }

    public ArrayWrapper(int initialCapacity, float lf) {
        this(initialCapacity, -1, lf);
    }

    public ArrayWrapper(int initialCapacity, int maxCapacity, float lf) {
        if (lf < 0.0f) {
            lf = 0.0f;
        }
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        if (maxCapacity > 0 && maxCapacity < initialCapacity) {
            maxCapacity = initialCapacity;
        }
        this.indexMap = new int[initialCapacity];
        this.nullVals = new boolean[this.indexMap.length];
        for (int i = 0; i < this.indexMap.length; ++i) {
            this.indexMap[i] = -1;
            this.nullVals[i] = true;
        }
        this.size = 0;
        this.maxSize = maxCapacity;
        this.loadFactor = lf;
    }

    public final ArrayWrapper wrap(WrapableArray array) {
        if (this.wrappableArray != array) {
            this.wrappableArray = array;
            if (this.wrappableArray.size() < this.indexMap.length) {
                this.wrappableArray.increaseSize(this.indexMap.length);
            }
        }
        return this;
    }

    final void checkArray() {
        if (this.wrappableArray == null) {
            throw new NoArrayWrappedException();
        }
    }

    public final int size() {
        this.checkArray();
        return this.size;
    }

    public final int maxSize() {
        return this.maxSize;
    }

    public final void remove(int idx) {
        this.checkArray();
        if (idx < 0 || idx > this.size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        this.nullVals[this.indexMap[idx]] = true;
        this.wrappableArray.set(this.indexMap[idx], null);
        this.indexMap[idx] = -1;
        for (int i = idx + 1; i < this.indexMap.length; ++i) {
            if (this.indexMap[i] == -1) continue;
            this.indexMap[i - 1] = this.indexMap[i];
            this.indexMap[i] = -1;
        }
    }

    public final void batchRemove(WrapableArray[] arries, int idx) {
        int i;
        if (idx < 0 || idx > this.size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        this.nullVals[this.indexMap[idx]] = true;
        for (i = 0; i < arries.length; ++i) {
            arries[i].set(this.indexMap[idx], null);
        }
        this.indexMap[idx] = -1;
        for (i = idx + 1; i < this.indexMap.length; ++i) {
            if (this.indexMap[i] == -1) continue;
            this.indexMap[i - 1] = this.indexMap[i];
            this.indexMap[i] = -1;
        }
    }

    public final int add(Object obj) {
        return this.add(-1, obj);
    }

    public final int add(int idx, Object obj) {
        int i;
        this.checkArray();
        if (idx < 0) {
            idx = this.size;
        }
        if (idx > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.indexMap.length) {
            if (this.maxSize == this.size) {
                throw new ReachedMaxSizeException();
            }
            int tmpSize = (int)((float)this.size * (1.0f + this.loadFactor));
            if (tmpSize > this.maxSize && this.maxSize != -1) {
                tmpSize = this.maxSize;
            }
            this.increaseIndexes(tmpSize);
            this.increaseDataes(this.wrappableArray, tmpSize);
        }
        int pos = -1;
        for (i = 0; i < this.indexMap.length; ++i) {
            if (!this.nullVals[i]) continue;
            pos = i;
            break;
        }
        for (i = this.indexMap.length - 1; i >= idx; --i) {
            if (this.indexMap[i] == -1) continue;
            this.indexMap[i + 1] = this.indexMap[i];
            this.indexMap[i] = -1;
        }
        this.wrappableArray.set(pos, obj);
        this.nullVals[pos] = false;
        this.indexMap[idx] = pos;
        ++this.size;
        return idx == -1 ? this.size() - 1 : idx;
    }

    public final int batchAdd(WrapableArray[] arries, int idx, Object obj) {
        int i;
        this.checkArray();
        if (idx < 0) {
            idx = this.size;
        }
        if (idx > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.indexMap.length) {
            if (this.maxSize == this.size) {
                throw new ReachedMaxSizeException();
            }
            int tmpSize = (int)((float)this.size * (1.0f + this.loadFactor));
            if (tmpSize > this.maxSize && this.maxSize != -1) {
                tmpSize = this.maxSize;
            }
            this.increaseIndexes(tmpSize);
            for (i = 0; i < arries.length; ++i) {
                this.increaseDataes(arries[i], tmpSize);
            }
        }
        int pos = -1;
        for (i = 0; i < this.indexMap.length; ++i) {
            if (!this.nullVals[i]) continue;
            pos = i;
            break;
        }
        for (i = this.indexMap.length - 1; i >= idx; --i) {
            if (this.indexMap[i] == -1) continue;
            this.indexMap[i + 1] = this.indexMap[i];
            this.indexMap[i] = -1;
        }
        for (int j = 0; j < arries.length; ++j) {
            this.wrap(arries[j]);
            arries[j].set(pos, obj);
        }
        this.nullVals[pos] = false;
        this.indexMap[idx] = pos;
        ++this.size;
        return idx == -1 ? this.size() - 1 : idx;
    }

    public final Object get(int idx) {
        if (this.wrappableArray == null) {
            throw new NoArrayWrappedException();
        }
        if (idx > this.size - 1 || idx < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.wrappableArray.get(this.indexMap[idx]);
    }

    public final void set(int idx, Object obj) {
        if (this.wrappableArray == null) {
            throw new NoArrayWrappedException();
        }
        if (idx > this.size - 1 || idx < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.wrappableArray.set(this.indexMap[idx], obj);
        this.nullVals[this.indexMap[idx]] = false;
    }

    private final void increaseIndexes(int spacity) {
        if (spacity != this.indexMap.length) {
            int[] tmpMap = new int[spacity];
            boolean[] tmpNullVals = new boolean[spacity];
            System.arraycopy(this.indexMap, 0, tmpMap, 0, this.size);
            System.arraycopy(this.nullVals, 0, tmpNullVals, 0, this.size);
            for (int i = this.size; i < spacity; ++i) {
                tmpMap[i] = -1;
                tmpNullVals[i] = true;
            }
            this.indexMap = tmpMap;
            this.nullVals = tmpNullVals;
        }
    }

    private final void increaseDataes(WrapableArray array, int spacity) {
        array.increaseSize(spacity);
    }

    public final void clear() {
        this.wrappableArray = null;
        this.indexMap = new int[0];
        this.nullVals = new boolean[0];
        this.size = 0;
    }

    public final void print(String message) {
    }

    public static class ReachedMaxSizeException
    extends RuntimeException {
        private static final long serialVersionUID = 5070097381336871538L;
    }

    public static class NoArrayWrappedException
    extends RuntimeException {
        private static final long serialVersionUID = -7839978163648795036L;
    }
}

