/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.text.Normalizer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CommonLogger
extends Logger {
    private Logger logger = null;

    public CommonLogger(Logger l) {
        super("CommonLogger");
        this.logger = l;
    }

    public static CommonLogger getLogger(Class clazz) {
        Logger logger = Logger.getLogger((Class)clazz);
        return new CommonLogger(logger);
    }

    public static CommonLogger getLogger(String clazz) {
        Logger logger = Logger.getLogger((String)clazz);
        return new CommonLogger(logger);
    }

    public static CommonLogger getRootLogger() {
        Logger logger = Logger.getRootLogger();
        return new CommonLogger(logger);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getCommonLogger() {
        return this.logger;
    }

    public void warn(Object message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(CommonLogger.convertValidLog(message));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(CommonLogger.convertValidLog(message), t);
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(CommonLogger.convertValidLog(message));
        }
    }

    public void info(Object message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(CommonLogger.convertValidLog(message), t);
        }
    }

    public void error(Object message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(CommonLogger.convertValidLog(message));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(CommonLogger.convertValidLog(message), t);
        }
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(CommonLogger.convertValidLog(message));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(CommonLogger.convertValidLog(message), t);
        }
    }

    public void trace(Object message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(CommonLogger.convertValidLog(message));
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(CommonLogger.convertValidLog(message), t);
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public static String convertValidLog(String message) {
        String log = message;
        if (null == log) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("%0d");
        list.add("%0a");
        list.add("%0D");
        list.add("%0A");
        list.add("\r");
        list.add("\n");
        String encode = Normalizer.normalize(log, Normalizer.Form.NFKC);
        for (String toReplaceStr : list) {
            encode = encode.replace(toReplaceStr, "");
        }
        return log;
    }

    public static Object convertValidLog(Object message) {
        if (message instanceof String) {
            return CommonLogger.convertValidLog((String)message);
        }
        return message;
    }
}

