/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = LogUtil.getPackageLogger(FileUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final char FILE_SEPARATOR_CHAR = FILE_SEPARATOR.charAt(0);
    private static final int BUFFER_SIZE = 32768;

    public static final boolean isExist(String filePath) {
        File f = new File(filePath);
        return f.exists();
    }

    public static final File createFolder(String filePath) {
        File f = new File(FilenameUtils.normalize((String)filePath));
        if (f.exists()) {
            return f;
        }
        return FileUtil.createFolder(filePath.split("\\" + FILE_SEPARATOR));
    }

    public static final File createFolder(String[] names) {
        String filePath = names[0];
        File f = null;
        for (int i = 1; i < names.length; ++i) {
            filePath = filePath + FILE_SEPARATOR + names[i];
            f = new File(filePath = FilenameUtils.normalize((String)filePath));
            if (f.exists()) {
                if (!f.isFile()) continue;
                log.info((Object)(":( The diretory may contains files!!! " + filePath));
                return null;
            }
            if (f.mkdir()) continue;
            log.error((Object)(":( Create directory failed!!! " + filePath));
            return null;
        }
        return f;
    }

    public static final File createFile(String filePath) throws IOException {
        File f = new File(filePath = FilenameUtils.normalize((String)filePath));
        if (f.exists()) {
            return f;
        }
        int i = filePath.lastIndexOf(FILE_SEPARATOR);
        if (i == -1) {
            log.error((Object)(":( Invalid file path!!! " + filePath));
            return null;
        }
        if (null == FileUtil.createFolder(filePath.substring(0, i))) {
            return null;
        }
        f = new File(filePath);
        if (!f.createNewFile()) {
            log.error((Object)(":( Create file failed!!! " + filePath));
            return null;
        }
        return f;
    }

    public static File deleteFile(File file) {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File f = FileUtil.deleteFile(new File(file.getPath() + FILE_SEPARATOR + files[i]));
                if (f == null) continue;
                return f;
            }
        }
        if (file.delete()) {
            return null;
        }
        return file;
    }

    public static File deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static boolean deleteContent(String dir) {
        return FileUtil.deleteContent(dir, null);
    }

    public static final boolean deleteContent(String dir, final String prefix) {
        try {
            File file = new File(dir);
            if (file.isDirectory()) {
                String[] files = null;
                files = StringUtil.isEmptyString(prefix) ? file.list() : file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(dir + FILE_SEPARATOR + files[i]);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static final void writeFileString(String filePath, String content) throws FileNotFoundException, IOException {
        try (RandomAccessFile rfile = null;){
            rfile = new RandomAccessFile(filePath, "rw");
            rfile.writeBytes(content);
        }
    }

    public static final void writeFile(String filePath, byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(data);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(fos);
            throw throwable;
        }
        StreamUtil.closeStream(fos);
    }

    public static void safeCopyFile(File from, File to) throws IOException {
        if (from.isDirectory()) {
            throw new UnsupportedOperationException(":( Unsupport copy directory!!!");
        }
        if (to.isDirectory()) {
            throw new UnsupportedOperationException(":( Unsupport copy file to directory!!!");
        }
        if (!to.exists() && (to = FileUtil.createFile(to.getAbsolutePath())) == null) {
            throw new IOException(":( Couldn't create file!!!" + to.getAbsolutePath());
        }
        FileUtil.copyFile(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            StreamUtil.copy(fis, fos, 32768);
        }
        catch (Throwable throwable) {
            StreamUtil.closeStream(fos);
            StreamUtil.closeStream(fis);
            throw throwable;
        }
        StreamUtil.closeStream(fos);
        StreamUtil.closeStream(fis);
    }

    public static String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            return FileUtil.getExtension(filename);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String filePath) {
        RandomAccessFile rfile = null;
        try {
            rfile = new RandomAccessFile(filePath, "r");
            byte[] classBytes = new byte[(int)rfile.length()];
            rfile.read(classBytes);
            rfile.close();
            byte[] byArray = classBytes;
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (rfile != null) {
                CtrlUtil.Stream.closeStream(rfile);
            }
        }
    }

    public static String getExtension(String filename) {
        int i;
        if (!StringUtil.isEmptyString(filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static File createTemporaryFile(boolean folder, String baseFolder) throws IOException {
        String name = "xx" + System.currentTimeMillis();
        if (baseFolder == null) {
            baseFolder = System.getProperty("user.home");
        }
        if (baseFolder == null) {
            baseFolder = System.getProperty("user.dir");
        }
        String fullName = baseFolder + File.separator + name;
        fullName = FilenameUtils.normalize((String)fullName);
        File file = new File(fullName);
        if (folder) {
            FileUtil.createFolder(fullName);
        } else {
            FileUtil.createFile(fullName);
        }
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileLocked(File file) {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        RandomAccessFile rcFile = null;
        AbstractInterruptibleChannel fc = null;
        try {
            rcFile = new RandomAccessFile(file, "rw");
            fc = rcFile.getChannel();
            FileLock fl = ((FileChannel)fc).tryLock();
            if (null != fl) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fc) {
                try {
                    fc.close();
                }
                catch (IOException iOException) {}
            }
            if (null != rcFile) {
                try {
                    rcFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

