/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.list;

import com.kingdee.bos.ctrl.common.util.list.Block;
import com.kingdee.bos.ctrl.common.util.list.BlockTable;
import com.kingdee.bos.ctrl.common.util.list.IList;
import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;
import java.util.ArrayList;

public abstract class BasicList
implements IList {
    protected BlockTable blockTable;

    @Override
    public int maxSize() {
        return this.blockTable.maxCapacity();
    }

    public BasicList(int capacity, boolean fixedObjectSize) {
        this.blockTable = new BlockTable(capacity, fixedObjectSize);
    }

    private void checkBound(int index, boolean forAdd) {
        if (!forAdd) {
            if (index < 0 || index >= this.blockTable.getObjectsCount()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + (index < 0 ? index + "<0" : index + ">=" + this.blockTable.getObjectsCount()));
            }
        } else if (index < 0 || index > this.blockTable.getObjectsCount()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + (index < 0 ? index + "<0" : index + ">" + this.blockTable.getObjectsCount()));
        }
    }

    private int getSequentialBlockInfoes(int index, int len, ArrayList blockList, int[] positions, int[] sizes) {
        Block block;
        int count = 0;
        while (count < len && (block = this.blockTable.locate(index + count)) != null) {
            if (blockList != null) {
                blockList.add(block);
            }
            int sequentialCount = block.tailIndex() - (index + count) + 1;
            int position = block.objectPosition(index + count);
            for (int k = 0; k < sequentialCount && count != len; ++count, ++k) {
                sizes[count] = block.objectSize(index + count);
                positions[count] = position;
                position += sizes[count];
            }
        }
        return count;
    }

    @Override
    public Object get(int index) {
        this.checkBound(index, false);
        Block block = this.blockTable.locate(index);
        return this.pureReadObject(block.objectPosition(index), block.objectSize(index));
    }

    @Override
    public int getBatch(int index, Object[] objs, int from, int len) {
        if (len <= 0) {
            return 0;
        }
        this.checkBound(index, false);
        this.checkBound(index + len - 1, false);
        int[] positions = new int[len];
        int[] sizes = new int[len];
        int count = this.getSequentialBlockInfoes(index, len, null, positions, sizes);
        for (int i = 0; i < count; ++i) {
            objs[from + i] = this.pureReadObject(positions[i], sizes[i]);
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(int index, Object obj) throws OutOfCapacityException {
        this.checkBound(index, true);
        int objSize = this.pureGetObjectStoreSize(obj);
        if (objSize != -1) {
            Block blk = this.blockTable.balloc(index, 1, objSize, false, false);
            if (blk == null) throw new OutOfCapacityException();
            blk.setObjectSize(index, objSize);
            this.pureWriteObject(blk.objectPosition(index), obj);
            return;
        } else {
            if (this.maxSize() != -1) {
                throw new OutOfCapacityException();
            }
            Block blk = this.blockTable.balloc(index, 1, 1, true, true);
            objSize = this.pureWriteObject(blk.startPosition(), obj);
            this.blockTable.balloc(index, 1, objSize, true, false);
        }
    }

    @Override
    public void add(Object obj) throws OutOfCapacityException {
        this.add(this.blockTable.getObjectsCount(), obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addBatch(int index, Object[] objs, int from, int len) throws OutOfCapacityException {
        this.checkBound(index, true);
        boolean unkownSize = false;
        int objsSize = 0;
        for (int i = 0; i < len; ++i) {
            int objSize = this.pureGetObjectStoreSize(objs[i + from]);
            if (objSize == -1) {
                unkownSize = true;
                break;
            }
            objsSize += objSize;
        }
        if (!unkownSize) {
            Block blk = this.blockTable.balloc(index, len, objsSize, false, false);
            if (blk == null) throw new OutOfCapacityException();
            int pos = blk.objectPosition(index);
            for (int i = 0; i < len; ++i) {
                int objSize = this.pureGetObjectStoreSize(objs[i + from]);
                blk.setObjectSize(index + i, objSize);
                this.pureWriteObject(pos, objs[i + from]);
                pos += objSize;
            }
            return;
        } else {
            if (this.maxSize() != -1) {
                throw new OutOfCapacityException();
            }
            Block blk = this.blockTable.balloc(index, len, 1, true, true);
            int position = blk.startPosition();
            for (int i = 0; i < len; ++i) {
                position += this.pureWriteObject(position, objs[i]);
            }
            blk = this.blockTable.balloc(index, len, position - blk.startPosition(), true, false);
        }
    }

    @Override
    public void addBatch(int index, Object[] objs) throws OutOfCapacityException {
        this.addBatch(index, objs, 0, objs.length);
    }

    @Override
    public void addBatch(Object[] objs) throws OutOfCapacityException {
        this.addBatch(this.blockTable.getObjectsCount(), objs);
    }

    @Override
    public boolean set(int index, Object object) throws OutOfCapacityException {
        this.checkBound(index, false);
        Block blk = this.blockTable.locate(index);
        if (blk != null) {
            int newSize = this.pureGetObjectStoreSize(object);
            int oldSize = blk.objectSize(index);
            if (newSize == -1 && this.maxSize() != -1) {
                throw new OutOfCapacityException();
            }
            int position = blk.objectPosition(index);
            if (oldSize == newSize) {
                this.pureWriteObject(position, object);
            } else {
                this.blockTable.freeBlock(blk, index, 1);
                this.pureClearObject(position, oldSize);
                if (newSize != -1) {
                    blk = this.blockTable.balloc(index, 1, newSize, false, false);
                    if (blk != null) {
                        this.pureWriteObject(blk.objectPosition(index), object);
                    }
                } else {
                    blk = this.blockTable.balloc(index, 1, 1, true, true);
                    newSize = this.pureWriteObject(blk.startPosition(), object);
                    this.blockTable.balloc(index, 1, newSize, true, false);
                }
            }
            return true;
        }
        throw new OutOfCapacityException();
    }

    @Override
    public void remove(int index) {
        this.checkBound(index, false);
        Block blk = this.blockTable.locate(index);
        this.blockTable.freeBlock(blk, index, 1);
        this.pureClearObject(blk.objectPosition(index), blk.objectSize(index));
    }

    @Override
    public int removeBatch(int index, int len) {
        this.checkBound(index, false);
        this.checkBound(index + len - 1, false);
        int[] positions = new int[len];
        int[] sizes = new int[len];
        ArrayList blockList = new ArrayList();
        int count = this.getSequentialBlockInfoes(index, len, blockList, positions, sizes);
        for (int i = 0; i < count; ++i) {
            this.pureClearObject(positions[i], sizes[i]);
        }
        int lastGotIndex = index + count - 1;
        int size = blockList.size();
        int lastGot = -1;
        if (size > 0) {
            Block lastBlk = (Block)blockList.get(size - 1);
            if (lastBlk.tailIndex() > lastGotIndex) {
                lastGot = lastGotIndex - lastBlk.startIndex() + 1;
            }
            int objects = 0;
            for (int i = 0; i < size; ++i) {
                Block blk = (Block)blockList.get(i);
                if (blk == lastBlk && lastGot != -1) {
                    if (i == 0) {
                        this.blockTable.freeBlock(blk, index, lastGot);
                        break;
                    }
                    this.blockTable.freeBlock(blk, blk.startIndex(), lastGot);
                    break;
                }
                if (i == 0) {
                    objects = blk.tailIndex() - index + 1;
                    this.blockTable.freeBlock(blk, index, objects);
                    continue;
                }
                this.blockTable.freeBlock(blk);
                objects += blk.objectsCount();
            }
        }
        blockList = null;
        return count;
    }

    @Override
    public void clear() {
        this.removeBatch(0, this.blockTable.getObjectsCount());
    }

    @Override
    public int size() {
        return this.blockTable.getObjectsCount();
    }

    protected int pureGetObjectStoreSize(Object object) {
        return -1;
    }

    abstract void pureClearObject(int var1, int var2);

    protected abstract int pureWriteObject(int var1, Object var2);

    protected abstract Object pureReadObject(int var1, int var2);
}

