/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.list;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.list.BasicList;
import com.kingdee.bos.ctrl.common.util.list.Block;
import com.kingdee.bos.ctrl.common.util.list.exception.ReadObjectFaildException;
import com.kingdee.bos.ctrl.common.util.list.exception.WriteObjectFailedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class FileBasedList
extends BasicList {
    protected RandomAccessFile randomFile;
    protected String filePath;

    public FileBasedList(int capacity, boolean fixedObjectSize) {
        super(capacity, fixedObjectSize);
    }

    public FileBasedList(String filePath) throws IOException {
        this(new File(filePath));
    }

    public FileBasedList(File file) throws IOException {
        super(-1, false);
        this.randomFile = new RandomAccessFile(file, "rws");
        this.randomFile.setLength(0L);
        this.filePath = file.getAbsolutePath();
    }

    public byte[] readBytes(int index) throws IOException {
        Block block = this.blockTable.locate(index);
        return this.readBytes(block.objectPosition(index), block.objectSize(index));
    }

    protected byte[] readBytes(int position, int size) throws IOException {
        this.randomFile.seek(position);
        byte[] bytes = new byte[size];
        this.randomFile.read(bytes);
        return bytes;
    }

    protected void writeBytes(int position, byte[] bytes) throws IOException {
        this.randomFile.seek(position);
        this.randomFile.write(bytes);
    }

    @Override
    protected Object pureReadObject(int position, int size) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.readBytes(position, size)));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (IOException ex) {
            throw new ReadObjectFaildException("Read row/object failed, IOException:'" + ex.toString() + "'");
        }
        catch (ClassNotFoundException e1) {
            throw new ReadObjectFaildException("Read row/object failed, ClassNotFoundException:'" + e1.toString() + "'");
        }
    }

    @Override
    protected int pureWriteObject(int position, Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            int size = baos.size();
            this.writeBytes(position, baos.toByteArray());
            baos.close();
            return size;
        }
        catch (IOException e) {
            throw new WriteObjectFailedException("Occured exception when writing object,IOException:" + e.toString());
        }
    }

    @Override
    protected int pureGetObjectStoreSize(Object object) {
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                int len = baos.toByteArray().length;
                baos.close();
                return len;
            }
            catch (Exception ex) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    protected void pureClearObject(int position, int size) {
    }

    public void destroy() {
        try {
            if (this.randomFile != null) {
                this.randomFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtil.isEmptyString(this.filePath)) {
            new File(this.filePath).delete();
        }
    }

    @Override
    public void clear() {
        this.blockTable.clear();
        try {
            if (this.randomFile != null) {
                this.randomFile.setLength(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

