/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.logger;

import com.kingdee.bos.ctrl.common.util.logger.LogRecord;
import java.util.StringTokenizer;

public class LogParser {
    public static final String LOG_START = "[";
    public static final String LOG_END = "]";
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static LogRecord parse(String log) {
        LogRecord record = new LogRecord();
        int end = log.indexOf(LOG_END);
        int endOfLine = log.indexOf(LINE_SEPARATOR, end);
        endOfLine = endOfLine == -1 ? log.length() : endOfLine;
        record.setMessage(log.substring(end + 1, endOfLine));
        if (endOfLine + 1 < log.length()) {
            record.setThrownStackTrace(log.substring(endOfLine + 1));
        }
        LogParser.parsePattern(log.substring(1, log.indexOf(LOG_END)), record);
        return record;
    }

    public static boolean isLog(String text) {
        return text == null ? false : text.startsWith(LOG_START);
    }

    private static void parsePattern(String log, LogRecord record) {
        StringTokenizer st = new StringTokenizer(log);
        record.setDate(st.nextToken());
        record.setTime(st.nextToken());
        record.setLevel(st.nextToken());
        st.nextToken();
        record.setLocation(st.nextToken());
    }
}

