/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.logger;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.logger.LogParser;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class LogReader {
    private Map indexes;
    private long length;
    private String file;
    private boolean parse;
    private static int BUFFER_SIZE = 32768;
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public LogReader(String file, int pageRowCount, boolean parse) throws FileNotFoundException, IOException {
        this.file = file;
        this.length = -1L;
        this.parse = parse;
        this.indexes = new HashMap();
        this.buildIndex(pageRowCount);
    }

    public int getPageCount() {
        return this.indexes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readPage(int page) throws FileNotFoundException, IOException {
        ArrayList<Object> logs = new ArrayList<Object>();
        if (page > this.getPageCount() || page <= 0) {
            return logs;
        }
        long currentPos = (Long)this.indexes.get(new Integer(page));
        long nextPos = this.length;
        if (page < this.indexes.size()) {
            nextPos = (Long)this.indexes.get(new Integer(page + 1));
        }
        RandomAccessFile raf = null;
        byte[] buffer = new byte[(int)(nextPos - currentPos)];
        try {
            raf = new RandomAccessFile(this.file, "r");
            raf.seek(currentPos);
            raf.read(buffer);
        }
        catch (Throwable throwable) {
            StreamUtil.closeCloseable(raf);
            throw throwable;
        }
        StreamUtil.closeCloseable((Closeable)raf);
        String data = new String(buffer);
        StringTokenizer st = new StringTokenizer(data, this.parse ? "[" : LINE_SEPARATOR, false);
        while (st.hasMoreTokens()) {
            String tokens;
            String string = tokens = this.parse ? "[" + st.nextToken().trim() : st.nextToken();
            if (this.parse) {
                logs.add(LogParser.parse(tokens));
                continue;
            }
            logs.add(tokens);
        }
        st = null;
        data = null;
        buffer = null;
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex(int pageRows) throws IOException {
        long readPos;
        int page;
        int row;
        RandomAccessFile raf;
        byte[] buffer;
        block6: {
            buffer = new byte[BUFFER_SIZE];
            raf = null;
            raf = new RandomAccessFile(this.file, "r");
            row = -1;
            page = 0;
            readPos = 0L;
            this.length = raf.length();
            if (this.length > 0L) break block6;
            StreamUtil.closeCloseable((Closeable)raf);
            return;
        }
        try {
            String delim = this.parse ? "[" : LINE_SEPARATOR;
            int delimLen = delim.length();
            while (raf.getFilePointer() < this.length) {
                int previousPos;
                readPos = raf.getFilePointer();
                int size = this.readBlock(buffer, raf);
                String data = new String(buffer, 0, size);
                if (!data.endsWith(LINE_SEPARATOR) && raf.getFilePointer() < raf.length()) {
                    data = data + raf.readLine() + LINE_SEPARATOR;
                }
                int nextPos = previousPos = -delimLen;
                while (true) {
                    previousPos = previousPos < 0 ? 0 : nextPos;
                    if ((nextPos = data.indexOf(delim, nextPos + delimLen)) < 0) break;
                    if (++row % pageRows != 0) continue;
                    long bytepos = data.substring(0, this.parse ? nextPos : previousPos).getBytes().length;
                    this.indexes.put(new Integer(++page), new Long(readPos + bytepos));
                }
                data = null;
            }
            raf.close();
        }
        catch (Throwable throwable) {
            StreamUtil.closeCloseable(raf);
            throw throwable;
        }
        StreamUtil.closeCloseable((Closeable)raf);
        buffer = null;
    }

    private int readBlock(byte[] buffer, RandomAccessFile raf) throws IOException {
        Arrays.fill(buffer, (byte)32);
        return raf.read(buffer);
    }
}

