/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.util.Calendar;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        result.setObject(Util.addCalendar(cal, right.toBigDecimal()));
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        result.setObject(Util.addCalendar(cal, right.toBigDecimal().negate()));
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        BigDecimal days = left.toBigDecimal().multiply(right.toBigDecimal());
        days.setScale(7, 4);
        long leftval = Util.getMillis2BaseDate(days);
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double rightval = right.doubleValue();
        if (rightval == 0.0) {
            ExprErr.goError(2L, null);
        }
        BigDecimal days = left.toBigDecimal().divide(right.toBigDecimal(), 7, 4);
        long leftval = Util.getMillis2BaseDate(days);
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double rightval = right.doubleValue();
        if (rightval == 0.0) {
            ExprErr.goError(2L, null);
        }
        long leftval = Util.getMillis2BaseDate(left.doubleValue() % rightval);
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }
}

